<?php
/*
    Appointment Limits Addon
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_appLimit' ) )
{
    class CPAPPB_appLimit extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-appLimit-20180607";
		protected $name = "Limit the number of appointments per user";
		protected $description;
        
        protected $default_label = 'Number of allowed appointments exceeded.';

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_appLimit_id' ] )
			)
			{
                $this->add_field_verify("limitlabel", "TEXT");
                $this->add_field_verify("futurelimit", "TEXT");
                $this->add_field_verify("limitfield", "TEXT");
                
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									'applimit_enable'	 => $_REQUEST["applimit_enable"],
                                    'daylimit'	 => $_REQUEST["daylimit"],
                                    'weeklimit'	 => $_REQUEST["weeklimit"],
                                    'monthlimit'	 => $_REQUEST["monthlimit"],                                    
                                    'futurelimit'	 => $_REQUEST["futurelimit"], 
                                    'limitby'	 => $_REQUEST["limitby"],   // 0 means email, 1 means registered user
                                    'limitlabel'	 => $_REQUEST["limitlabel"],
                                    'limitfield'	 => $_REQUEST["limitfield"]
								),
								array( '%d', '%d', '%d', '%d', '%d', '%d', '%d', '%s', '%s' )
							);          
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["applimit_enable"] = 0;
			    $row["daylimit"] = 0;
                $row["weeklimit"] = 0;
                $row["monthlimit"] = 0;
                $row["futurelimit"] = 0;
                $row["limitby"] = 0;
                $row["limitlabel"] = $this->default_label;
                $row["limitfield"] = $this->limitfield;
			} else {
			    $row["applimit_enable"] = $rows[0]->applimit_enable;
			    $row["daylimit"] = $rows[0]->daylimit;
                $row["weeklimit"] = $rows[0]->weeklimit;
                $row["monthlimit"] = $rows[0]->monthlimit;
                $row["futurelimit"] = $rows[0]->futurelimit;
                $row["limitby"] = $rows[0]->limitby;
                $row["limitlabel"] = $rows[0]->limitlabel;
                $row["limitfield"] = $rows[0]->limitfield;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_appLimit_id" value="1" />
                     Enable appointments limits  for this calendar? :<br />
                        <?php $option = $row['applimit_enable']; ?>
                        <select name="applimit_enable" id="applimit_enable" onchange="abclimit_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
                   
                   <div id="appLimitcontent_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                         <br />
                         <strong>Daily Limit (# of appointments):</strong><br />
                         <select name="daylimit">
                          <option value="0"> - unlimited - </option>
                          <?php for($i=1; $i<100; $i++) {?><option value="<?php echo $i; ?>" <?php if ($i==$row["daylimit"]) echo 'selected'; ?>><?php echo $i; ?></option><?php } ?>
                         </select>
                         <br />

                         <strong>Weekly Limit (# of appointments):</strong><br />
                         <select name="weeklimit">
                          <option value="0"> - unlimited - </option>
                          <?php for($i=1; $i<100; $i++) {?><option value="<?php echo $i; ?>" <?php if ($i==$row["weeklimit"]) echo 'selected'; ?>><?php echo $i; ?></option><?php } ?>
                         </select>
                         <br />

                         <strong>Monthly Limit (# of appointments):</strong><br />
                         <select name="monthlimit">
                          <option value="0"> - unlimited - </option>
                          <?php for($i=1; $i<100; $i++) {?><option value="<?php echo $i; ?>" <?php if ($i==$row["monthlimit"]) echo 'selected'; ?>><?php echo $i; ?></option><?php } ?>
                         </select>
                         <br />
                         

                         <strong>Allow only limited future bookings for customer:</strong><br />
                         <select name="futurelimit">
                          <option value="0" <?php if (0 ==$row["futurelimit"]) echo 'selected'; ?>>No, don't apply this limit. Allow the customer have multiple future bookings.</option>
                          <?php for ($maxi=1;$maxi<100; $maxi++) { ?>
                          <option value="<?php echo $maxi; ?>" <?php if ($maxi ==$row["futurelimit"]) echo 'selected'; ?>>Yes, apply this limit. Maximun <?php echo $maxi; ?> future bookings</option>
                          <?php } ?>
                         </select>
                         <em>* If enabled won't allow new bookings if the customer already has the indicated number of bookings for future dates.</em>
                         <br />                         
                         
                         <strong>Limit type:</strong><br />
                         <select name="limitby" id="limitby" onchange="abclimit_display_limitfield(this)">
                          <option value="0" <?php if (0 ==$row["limitby"]) echo 'selected'; ?>>Apply limit using the customer email address</option>
                          <option value="1" <?php if (1 ==$row["limitby"]) echo 'selected'; ?>>Apply limit for registered WordPress users</option>
                          <option value="2" <?php if (2 ==$row["limitby"]) echo 'selected'; ?>>Apply limit for other form field</option>
                         </select>
                         <br>
                         <div id="limitwhichfield" style="margin-keft:30px;display:none"> 
                           <strong>Which field?:</strong><br />
                           <input type="text" size="20" name="limitfield" value="<?php echo esc_attr( (!$row["limitfield"]?'fieldname2':$row["limitfield"])); ?>" /><br />
                           <em>Enter the ID of the field. <a href="https://apphourbooking.dwbooster.com/customdownloads/field-ids-tags-form-builder.png" target="_blank">Click for info about locating the field IDs</a>.
                         </div>
                         
                         <br />   

                         <strong>Message text:</strong><br />
                         <input type="text" size="80" name="limitlabel" value="<?php echo esc_attr( (!$row["limitlabel"]?$this->default_label:$row["limitlabel"])); ?>" /> 
                         <br />                          
                   </div>
                   <script type="text/javascript">
                       function abclimit_display_option(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("appLimitcontent_yes").style.display = '';
                           else
                               document.getElementById("appLimitcontent_yes").style.display = 'none';
                       }
                       function abclimit_display_limitfield(item) 
                       {                         
                           if (item.selectedIndex == 2) 
                               document.getElementById("limitwhichfield").style.display = '';
                           else
                               document.getElementById("limitwhichfield").style.display = 'none';
                       }
                       abclimit_display_limitfield(document.getElementById("limitby"));
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_applimit';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on adds support for limiting the number of appointments per user", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
            
            if (!is_admin()) // Insert the JS code to validate the recaptcha code through AJAX
            {                
		        add_action( 'cpappb_script_after_validation', array( &$this, 'validate_form_script'), 1, 2 );
            }
            
            add_action( 'init', array( &$this, 'applimit_check' ), 10, 1 );
            
            add_filter('cpappb_limit_allowed', array( &$this, 'pp_cpappb_limit_allowed' ), 10, 3);

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;

			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    applimit_enable INT NOT NULL,
                    daylimit INT NOT NULL, 
                    weeklimit INT NOT NULL, 
                    monthlimit INT NOT NULL, 
                    futurelimit INT NOT NULL, 
                    limitby INT NOT NULL, 
                    limitlabel TEXT,
                    limitfield TEXT,
					UNIQUE KEY id (id)
				) $charset_collate;";
            
			$wpdb->query($sql);
            
		} // end update_database
        
        
       

		/************************ PUBLIC METHODS  *****************************/

        
		public function applimit_check( )
		{
            global $wpdb;
            if (!isset($_GET["cpapphb_validate_limits"]) || !isset($_GET["form"]) )
                return;
            $rows = $wpdb->get_results( 
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $_GET["form"] ) 
					);       
			if (!$rows[0]->applimit_enable)		
			    return;            
 
            $new_items = array();
            $orgdates = explode(";", $_GET["sel"]);
            $current_user = wp_get_current_user();
            foreach ($orgdates as $orgdate)
                if (trim($orgdate) != '')
                {            
                    $orgdate = substr($orgdate,0,strpos($orgdate," ")); //str_replace(",","-",$orgdate);
                    if ($rows[0]->daylimit)
                    {
                        $from = date("Y-m-d 00:00", strtotime($orgdate));
                        $to = date("Y-m-d 23:59", strtotime($orgdate));
                        $this->check_interval($from, $to, $rows[0]->daylimit, $current_user, $rows[0], $newitems);                
                    }    
                    if ($rows[0]->weeklimit)
                    {
                        $from = date("Y-m-d 00:00", strtotime('monday this week ', strtotime($orgdate)));
                        $to = date("Y-m-d 23:59", strtotime('sunday this week ', strtotime($orgdate)));
                        $this->check_interval($from, $to, $rows[0]->weeklimit, $current_user, $rows[0], $newitems);                
                    }              
                    if ($rows[0]->monthlimit)
                    {
                        $from = date("Y-m-01 00:00", strtotime($orgdate));
                        $to = date("Y-m-01 00:00", strtotime('first day of '.$orgdate." +1 month"));
                        $this->check_interval($from, $to, $rows[0]->monthlimit, $current_user, $rows[0], $newitems);                
                    }              
                    if ($rows[0]->futurelimit)
                    {
                        $from = date("Y-m-d H:i");
                        $to = date("Y-m-d H:i", strtotime("+10 years"));
                        $this->check_interval($from, $to, $rows[0]->futurelimit, $current_user, $rows[0], $newitems);
                    }
                    // count this new item as added
                    $d = date("Y-m-d", strtotime($orgdate));
                    if (!isset($newitems["d".$d]))
                        $newitems["d".$d] = 1;
                    else
                        $newitems["d".$d]++;                    
                }
            
            echo 'OK';
            exit ();

		}        
        
        
        public function pp_cpappb_limit_allowed($value, $formid, $orgdate)
        {
            global $wpdb;
            $rows = $wpdb->get_results( 
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ) 
					);                  
			if (!$rows[0]->applimit_enable)		
			    return true;     
        
            $current_user = wp_get_current_user();
            
            if ($rows[0]->daylimit)
            {
                $from = date("Y-m-d 00:00", strtotime($orgdate));
                $to = date("Y-m-d 23:59", strtotime($orgdate));
                if (!$this->check_interval($from, $to, $rows[0]->daylimit, $current_user, $rows[0], array(), false))
                    return false;
            }    
            if ($rows[0]->weeklimit)
            {
                $from = date("Y-m-d 00:00", strtotime('monday this week ', strtotime($orgdate)));
                $to = date("Y-m-d 23:59", strtotime('sunday this week ', strtotime($orgdate)));
                if ($this->check_interval($from, $to, $rows[0]->weeklimit, $current_user, $rows[0], array(), false))
                    return false;                
            }              
            if ($rows[0]->monthlimit)
            {
                $from = date("Y-m-01 00:00", strtotime($orgdate));
                $to = date("Y-m-01 00:00", strtotime('first day of '.$orgdate." +1 month"));
                if (!$this->check_interval($from, $to, $rows[0]->monthlimit, $current_user, $rows[0], array(), false))
                    return false;                
            }              
            if ($rows[0]->futurelimit)
            {
                $from = date("Y-m-d H:i");
                $to = date("Y-m-d H:i", strtotime("+10 years"));
                if (!$this->check_interval($from, $to, $rows[0]->futurelimit, $current_user, $rows[0], array(), false))
                    return false;
            }
                        
            return true;
        }
        
        
        private function check_interval($from, $to, $max, $current_user, $settings, $newitems, $output = true)
        {
            global $wpdb, $cp_appb_plugin;
            
            if (intval($settings->limitby) == 1)
            {  
                $cp_appb_plugin->add_field_verify($wpdb->prefix.$cp_appb_plugin->table_messages, "whoadded");
                $results = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages.
                      " WHERE formid=".intval($_GET["form"]).
                      (isset($_GET["ahb_excl"]) && intval($_GET["ahb_excl"]) ? " AND (id<>".intval($_GET["ahb_excl"]).") " : "" ).
                      " AND (whoadded='".$current_user->ID."')"); 
            }    
            else if (intval($settings->limitby) == 2)
            {  
                $results = array();
                $initialresults = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages.
                      " WHERE formid=".intval($_GET["form"]).
                      (isset($_GET["ahb_excl"]) && intval($_GET["ahb_excl"]) ? " AND (id<>".intval($_GET["ahb_excl"]).") " : "" ).
                      " AND posted_data LIKE '%".esc_sql($_GET["cpapphb_validate_limits"])."%'");
                foreach ($initialresults as $item)
                {
                    $params = unserialize($item->posted_data); 
                    if ($params[$settings->limitfield] == $_GET["cpapphb_validate_limits"])  
                        $results[] = $item;                        
                }
            }             
            else 
                $results = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages.
                      " WHERE formid=".intval($_GET["form"]).
                      (isset($_GET["ahb_excl"]) && intval($_GET["ahb_excl"]) ? " AND (id<>".intval($_GET["ahb_excl"]).") " : "" ).
                     " AND (notifyto='".esc_sql($_GET["cpapphb_validate_limits"])."')");
                    
            // exclude cancelled and out of date
            $matches = 0;
            foreach ($results as $item)
            {
                $params = unserialize($item->posted_data);
                $apps = $params["apps"];
                foreach ($params["apps"] as $app)
                {
                    if ($app["date"]." 00:00" >= $from && $app["date"]." 00:00" <= $to && (!isset($app["cancelled"]) || @$app["cancelled"] == ''))
                    {
                        $matches++;  
                    }
                }
            }              

            // count items already processed in this booking request
            foreach ($newitems as $item => $value)            
            {
                $d = substr($item, 1)." 00:00";
                echo $from;
                if ($from <= $d  && $d <= $to)
                    $matches += $value;
            }
            
            if ($matches >= $max)
            {
                if ($output)
                {
                    echo 'Result abcappexceeded';
                    exit();
                }
                else 
                    return false;
            }  
            else if (!$output) 
                return true;
        }

       	/**
         * validation script
         */
        public function validate_form_script( $sequence, $formid )
        {            
            global $wpdb, $cp_appb_plugin;
            
            $rows = $wpdb->get_results( 
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ) 
					);
			if (!$rows[0]->applimit_enable)		
			    return;
            
            $selected_field = '';
            $form_data = json_decode($cp_appb_plugin->cleanJSON($cp_appb_plugin->get_option('form_structure', CP_APPBOOK_DEFAULT_form_structure)));          
            foreach($form_data[0] as $field)
                if ($field->ftype == 'fapp')
                    $selected_field = $field->name.'_'.$sequence;
            if ($selected_field == '')
                return;
		?>
            var email = '';
            try{
<?php if (intval($rows[0]->limitby) == 2) { ?>
                var emfield = '#<?php echo $rows[0]->limitfield; ?>';
<?php } else { ?>
                var emfield = '#<?php echo $cp_appb_plugin->get_option('cu_user_email_field', CP_APPBOOK_DEFAULT_cu_user_email_field); ?>';                          
<?php } ?>
                email = $dexQuery(emfield+"_<?php echo $sequence; ?>").val();
            } catch (e) {
            }
            try{
               if (email == '')
                   email = document.cp_appbooking_pform_<?php echo $sequence; ?>.email.value;
            } catch (e) {
            }
			var result = $dexQuery.ajax({
				type: "GET",
				url:  "<?php echo $cp_appb_plugin->get_site_url(); ?>",
				data: {
					form: "<?php echo $formid; ?>",
                    sel: $dexQuery("#<?php echo $selected_field; ?>").val(), 
                    ahb_excl: $dexQuery("#ahb_edititem").val(),
					cpapphb_validate_limits: email
				},
				async: false
			}).responseText;
			if (result.indexOf("abcappexceeded") != -1)
			{
				alert('<?php echo( _e( (!$rows[0]->limitlabel?$this->default_label:$rows[0]->limitlabel) , 'appointment-hour-booking') ); ?>');
				return false;
			}           
		<?php            
        }
        
        
		/**
		 *	Add field if not exists
		 */
        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL")
        {
            global $wpdb, $cp_appb_plugin;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$this->form_table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }
        

		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}
        


    } // End Class

    // Main add-on code
    $CPAPPB_appLimit_obj = new CPAPPB_appLimit();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_appLimit_obj->get_addon_id() ] = $CPAPPB_appLimit_obj;
}


?>