<?php
/*
Documentation: https://Coupons.com/docs/quickstart
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_Coupons' ) )
{
    class CPAPPB_Coupons extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-Coupons-20151212";
		protected $name = "Coupons";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
            
            $this->add_field_verify('dc_timesby' , "varchar(10) DEFAULT '0' NOT NULL");
?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
           <div id="cpabc_nocodes_availmsg">Loading...</div>
          
           <br />               
           <strong>Add new discount code:</strong>
           <br />
           <table border="0" cellpadding="0" cellspacing="0" style="margin-top:5px;">
            <tr>
             <td style="padding:0px;">Code:</td>
             <td style="padding-left:20px;" >Discount:</td>
             <td style="padding:0px;"></td>
             <td style="padding-left:20px;">Can be used:</td>
             <td style="padding:0px;">Apply limit:</td>
             <td style="padding:0px;">Valid until:</td>             
             <td style="padding:0px;"></td>
            </tr> 
            <tr>
             <td style="padding:0px;" nowrap><input type="text" name="cpabc_dc_code" id="cpabc_dc_code" size="4" value="" /></td>
             <td style="padding-left:20px;" nowrap><input type="text" size="3" name="cpabc_dc_discount" id="cpabc_dc_discount"  value="25" /></td>
             <td style="padding:0px;" nowrap><select name="cpabc_dc_discounttype" id="cpabc_dc_discounttype">
                   <option value="0">Percent</option>
                   <option value="1">Fixed Value</option>
                 </select></td>
             <td style="padding-left:20px;" nowrap><select name="dex_dc_times" id="dex_dc_times">
                   <option value="0">Unlimited</option>
                   <?php for ($i=1;$i<20;$i++) { ?><option value="<?php echo $i; ?>"><?php echo $i; ?> times</option><?php } ?>
                   <?php for ($i=20;$i<50;$i+=5) { ?><option value="<?php echo $i; ?>"><?php echo $i; ?> times</option><?php } ?>
                   <?php for ($i=50;$i<500;$i+=10) { ?><option value="<?php echo $i; ?>"><?php echo $i; ?> times</option><?php } ?>
                   <?php for ($i=500;$i<10000;$i+=50) { ?><option value="<?php echo $i; ?>"><?php echo $i; ?></option><?php } ?>
                 </select></td>
                <td style="padding-right:20px;" nowrap><select name="cpabc_dc_discountlimitby" id="cpabc_dc_discountlimitby">
                   <option value="0">Globally</option>
                   <option value="1">Per user (filter by logged in user)</option>
                   <option value="2">Per user (filter by email address)</option>
                 </select></td>                 
             <td style="padding:0px;" nowrap><input type="text"  size="10" name="cpabc_dc_expires" id="cpabc_dc_expires" value="" /></td>             
             <td style="padding:0px;"><input type="button" name="cpabc_dc_subccode" id="cpabc_dc_subccode" value="Add" /></td>
            </tr>             
           </table>   
           <em>Note: Expiration date based in server time. Server time now is <?php echo date("Y-m-d H:i"); ?></em>
<script type="text/javascript">
 var $j = jQuery.noConflict();
 $j(function() {
 	$j("#cpabc_dc_expires").datepicker({     	                
                    dateFormat: 'yy-mm-dd'
                 }); 	
 });
 $j('#cpabc_nocodes_availmsg').load('<?php echo $cp_appb_plugin->get_site_url(true); ?>/?apphbcoupons=1&inAdmin=1&item=<?php echo $form_id; ?>');
 $j('#cpabc_dc_subccode').click (function() {
                               var code = $j('#cpabc_dc_code').val();
                               var discount = $j('#cpabc_dc_discount').val();
                               var expires = $j('#cpabc_dc_expires').val();
                               var dc_times = $j('#dex_dc_times').val();             
                               var dc_timesby = $j('#cpabc_dc_discountlimitby').val();                                            
                               var discounttype = $j('#cpabc_dc_discounttype').val();
                               if (code == '') { alert('Please enter a code'); return; }
                               if (parseInt(discount)+"" != discount) { alert('Please numeric discount percent'); return; }
                               if (expires == '') { alert('Please enter an expiration date for the code'); return; }
                               var params = '&add=1&expires='+encodeURI(expires)+'&discount='+encodeURI(discount)+'&discounttype='+encodeURI(discounttype)+'&code='+encodeURI(code)+'&tm='+encodeURI(dc_times)+'&tby='+encodeURI(dc_timesby);                               
                               $j('#cpabc_nocodes_availmsg').load('<?php echo $cp_appb_plugin->get_site_url(true); ?>/?apphbcoupons=1&inAdmin=1&item=<?php echo $form_id; ?>'+params);
                               $j('#cpabc_dc_code').val();
                             });
                             
  function cpabc_delete_coupon(id)                             
  {
     $j('#cpabc_nocodes_availmsg').load('<?php echo $cp_appb_plugin->get_site_url(true); ?>/?apphbcoupons=1&inAdmin=1&item=<?php echo $form_id; ?>&delete=1&code='+id);
  }
</script>  
                   </div>
                 </div>  
<?php

		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_coupons';
        private $form_table_user = 'cpappbk_couponsused';
        private $form_table_customers = 'cpappbk_couponscustomers';
        private $_inserted = false;
		private $_apphbmain;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			
			$this->description = __("The add-on adds support for coupons / discounts codes", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

			add_action( 'cpappb_process_data_before_insert', array( &$this, 'pp_Coupons' ), 1, 1 );
            
            add_action( 'cpappb_process_data', array( &$this, 'pp_Coupons_after' ), 10, 1 );

			add_action( 'init', array( &$this, 'pp_Coupons_process_admin' ), 1 );
            
            add_filter( 'cpappb_calculate_coupondiscount', array( &$this, 'pp_Coupons_calculate_action' ), 10, 3 );

			//add_action( 'cpappb_script_after_validation', array( &$this, 'pp_payments_script' ), 10, 2 );

			add_filter( 'cpappb_the_form', array( &$this, 'insert_payment_fields'), 99, 2 );

			if( is_admin() )
			{
				// Delete forms
				add_action( 'apphb_delete_form', array(&$this, 'delete_form') );

				// Clone forms
				add_action( 'apphb_clone_form', array(&$this, 'clone_form'), 10, 2 );

				// Export addon data
				add_action( 'apphb_export_addons', array(&$this, 'export_form'), 10, 2 );

				// Import addon data
				add_action( 'apphb_import_addons', array(&$this, 'import_form'), 10, 2 );
			}

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb, $cp_appb_plugin;
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
                    cal_id mediumint(9) NOT NULL DEFAULT 1,
                    code VARCHAR(250) DEFAULT '' NOT NULL,
                    discount VARCHAR(250) DEFAULT '' NOT NULL,
                    expires datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
                    dc_times varchar(10) DEFAULT '0' NOT NULL,
                    dc_timesby varchar(10) DEFAULT '0' NOT NULL,
                    availability int(10) unsigned NOT NULL DEFAULT 0,
                    used int(10) unsigned NOT NULL DEFAULT 0,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
            $wpdb->query($sql);
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table_user." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
                    cal_id mediumint(9) NOT NULL DEFAULT 1,
                    submission_id mediumint(9) NOT NULL DEFAULT 1,
                    coupon VARCHAR(250) DEFAULT '' NOT NULL,
                    email VARCHAR(250) DEFAULT '' NOT NULL,
                    user VARCHAR(250) DEFAULT '' NOT NULL,                    
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
            $wpdb->query($sql);            

		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
         * Inserts banks and Check if the Optional is enabled in the form, and inserts radiobutton
         */
        public function	insert_payment_fields( $form_code, $id )
		{
            global $wpdb, $cp_appb_plugin;

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE cal_id=%d", $id )
					);

			if (empty( $rows ))
			    return $form_code;
            
            $buffer = '<div class="fields" id="field-c0-couponcode">'.
                      '   <label>'.__('Discount code','appointment-hour-booking').'</label>'.
                      '   <div class="dfield">'.
                      '     <input type="text" name="couponcode" id="couponcode_'.($cp_appb_plugin->print_counter-1).'" value="">'.
                      '   </div>'.
                      '   <div class="clearer"></div>'.
                      '</div>';           
     
            return str_replace( '<!--addons-payment-fields-->', $buffer.'<!--addons-payment-fields-->', $form_code );

            return $form_code;
		} // End insert_payment_fields


		/**
         * process payment
         */
		public function pp_Coupons(&$params)
		{
            global $wpdb, $cp_appb_plugin;

            $price = $params["final_price"];  

            $codes = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE ((dc_times>used) OR dc_times='0' OR dc_timesby<>'0') AND code='".esc_sql(@$_POST["couponcode"])."' AND expires>='".date("Y-m-d")." 00:00:00' AND `cal_id`=".$params["formid"]);
            if (count($codes) && $this->userLimitOK($codes[0], $params[$cp_appb_plugin->get_option('cu_user_email_field', CP_APPBOOK_DEFAULT_cu_user_email_field)]) )  // calculation partially duplicated in the function pp_Coupons_calculate_action
            {
                $params["original_price"] = $price;
                $coupon = $codes[0];
                if ($coupon->availability==1)
                {
                    $price = number_format (floatval ($price) - $coupon->discount,2, ".", "");
                    $discount_note = $coupon->discount;
                }
                else
                {
                    $price = number_format (floatval ($price) - $price*$coupon->discount/100,2, ".", "");
                    $discount_note = $coupon->discount;
                }
                $params["coupon"] = $coupon->code;
                $params["discount_applied"] = $discount_note;     
                if (floatval($price) < 0)                 
                    $price = 0;                
                $params["final_price"] = $price;
                
                $wpdb->query("UPDATE ".$wpdb->prefix.$this->form_table." SET used=used+1 WHERE id=".intval($codes[0]->id));
            }                

		} // end pp_Coupons
        
        
        
        function pp_Coupons_calculate_action ($price, $coupon, $formid)
        {
            global $wpdb, $cp_appb_plugin;
            $codes = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE ((dc_times>used) OR dc_times='0' OR dc_timesby<>'0') AND code='".esc_sql($coupon)."' AND expires>='".date("Y-m-d")." 00:00:00' AND `cal_id`=".$formid);
            if (count($codes) && $this->userLimitOK($codes[0], '') )   // this may be a problem for limits applied by email address, seems to be ignored
            {         
                $coupon = $codes[0];
                if ($coupon->availability==1)
                    $price = number_format (floatval ($price) - $coupon->discount,2, ".", "");
                else
                    $price = number_format (floatval ($price) - $price*$coupon->discount/100,2, ".", "");             
            }
            return $price;            
        } // end pp_Coupons_calculate_action
        
        
        function userLimitOK ($codes, $email)
        {
            global $wpdb, $cp_appb_plugin;            
            if ($codes->dc_timesby == '0')
                return true;
            else if ($codes->dc_timesby == '1')
            {
                $current_user = wp_get_current_user();
                if (!$current_user->ID)
                    return false;
                $used = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table_user." WHERE user='".esc_sql($current_user->ID)."' AND coupon='".esc_sql($codes->code)."' AND `cal_id`=".intval($codes->cal_id));
                return (count($used) < $codes->dc_times) || ($codes->dc_times == 0);
            }
            else if ($codes->dc_timesby == '2')
            {
                if ($email == '')
                {    
                    if (isset($_POST["em"]))
                        $email = sanitize_email($_POST["em"]);
                    else
                        return false;
                }
                $used = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table_user." WHERE email='".esc_sql($email)."' AND coupon='".esc_sql($codes->code)."' AND `cal_id`=".intval($codes->cal_id));
             
                return (count($used) < $codes->dc_times) || ($codes->dc_times == 0);
            } 
            else
                return true; // unknown filter
            
        }
        
        
		/**
         * process payment
         */
		public function pp_Coupons_after(&$params)
		{
            global $wpdb, $cp_appb_plugin;

            if (isset($params["discount_applied"]) && $params["discount_applied"])
            {
               
                $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $params["itemnumber"]) );
                if (empty( $myrows ))
			       return;
               
                $current_user = wp_get_current_user();
                $email = $myrows[0]->notifyto;
                $wpdb->query( "INSERT  INTO ".$wpdb->prefix.$this->form_table_user." (cal_id,submission_id,coupon,email,user) VALUES (".intval($params["formid"]).",".intval($params["itemnumber"]).",'".esc_sql($params["coupon"])."','".esc_sql($email)."','".esc_sql($current_user->ID)."')");
               
                if (floatval($params["final_price"]) == 0)
                {                    
                    $params2 = unserialize($myrows[0]->posted_data);
                    $params2["paid"] = '1';
                    $params2["payment_type"] = "Coupon code";
                    $params2["itemnumber"] = $params["itemnumber"];
                    $wpdb->query( $wpdb->prepare("UPDATE  ".$wpdb->prefix.$cp_appb_plugin->table_messages." SET posted_data=%s WHERE id=%d", serialize($params2), $params["itemnumber"]) );
                    $cp_appb_plugin->update_status($params["itemnumber"], $cp_appb_plugin->get_option('defaultpaidstatus', '') );   
                    $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $params["itemnumber"]) );                
                    $params = unserialize($myrows[0]->posted_data);
                }
            }    
            

		} // end pp_Coupons_after        

        
		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}


        /**
         * script process payment
         */
		public function pp_Coupons_process_admin()
		{
            global $wpdb, $cp_appb_plugin;

            if (!isset($_GET["apphbcoupons"]) || !isset($_GET["item"]) || !is_admin())
                return;

            $form_id = $_GET["item"];
	       
            if (isset($_GET["add"]) && $_GET["add"] == "1")
                $wpdb->insert( $wpdb->prefix.$this->form_table, array(   'cal_id' => $form_id,
                                                                         'code' => $_GET["code"],
                                                                         'discount' => $_GET["discount"],
                                                                         'availability' => $_GET["discounttype"],
                                                                         'dc_times' => $_GET["tm"],
                                                                         'dc_timesby' => $_GET["tby"],
                                                                         'expires' => $_GET["expires"],
                                                                      ));
            if (isset($_GET["delete"]) && $_GET["delete"] == "1")
            {
                $codes = $wpdb->get_results( 'SELECT * FROM '.$wpdb->prefix.$this->form_table.' WHERE `id`='.intval($_GET["code"]));
                $wpdb->query( $wpdb->prepare( "DELETE FROM ".$wpdb->prefix.$this->form_table." WHERE id = %d", $_GET["code"] ));
                $wpdb->query( $wpdb->prepare( "DELETE FROM ".$wpdb->prefix.$this->form_table_user." WHERE cal_id=%d AND coupon=%s", $codes[0]->cal_id, $codes[0]->code ));
            }
            
            $codes = $wpdb->get_results( 'SELECT * FROM '.$wpdb->prefix.$this->form_table.' WHERE `cal_id`='.$form_id);
            if (count ($codes))
            {
                echo '<table cellpadding="5">';
                echo '<tr>';
                echo '  <th style="background-color: #cccccc;">Cupon Code</th>';
                echo '  <th style="background-color: #cccccc;">Discount</th>';
                echo '  <th style="background-color: #cccccc;">Type</th>';
                echo '  <th style="background-color: #cccccc;" nowrap>Can be used?</th>';
                echo '  <th style="background-color: #cccccc;text-align:left" nowrap>Limit by:</th>';
                echo '  <th style="background-color: #cccccc;" nowrap>Used so far</th>';
                echo '  <th style="background-color: #cccccc;">Valid until</th>';
                echo '  <th style="background-color: #cccccc;">Options</th>';
                echo '</tr>';
                foreach ($codes as $value)
                {
                   echo '<tr>';
                   echo '<td>'.$value->code.'</td>';
                   echo '<td>'.$value->discount.'</td>';
                   echo '<td>'.($value->availability==1?"Fixed Value":"Percent").'</td>';
                   echo '<td nowrap>'.($value->dc_times=='0'?'Unlimited':$value->dc_times.' times').'</td>';
                   echo '<td nowrap>'.($value->dc_timesby=='0'?'Globally':($value->dc_timesby=='1'?'Per user (logged in)':'Per user (email)')).'</td>';
                   echo '<td nowrap>'.$value->used.' times</td>';
                   echo '<td>'.substr($value->expires,0,10).'</td>';
                   echo '<td>[<a href="javascript:cpabc_delete_coupon('.$value->id.')">Delete</a>]</td>';
                   echo '</tr>';
                }
                echo '</table>';
            }
            else
                echo 'No discount codes listed for this calendar yet.';
    
			exit;

         }


        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL", $table = '')
        {
            global $wpdb, $cp_appb_plugin;
            if ($table == '')
                $table = $this->form_table;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }

		/**
		 *	Delete the form from the addon's table
		 */
        public function delete_form( $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$wpdb->delete( $wpdb->prefix.$this->form_table, array('formid' => $formid), '%d' );
		} // delete_form

        		/**
		 *	Clone the form's row
		 */
		public function clone_form( $original_form_id, $new_form_id )
		{
			global $wpdb, $cp_appb_plugin;

			$form_rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $original_form_id ), ARRAY_A);

			if(!empty($form_rows))
			{
				foreach($form_rows as $form_row)
				{
					unset($form_row["id"]);
					$form_row["formid"] = $new_form_id;
					$wpdb->insert( $wpdb->prefix.$this->form_table, $form_row);
				}
			}
		} // End clone_form

		/**
		 *	It is called when the form is exported to export the addons data too.
		 *  Receive an array with the other addons data, and the form's id for filtering.
		 */
		public function export_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ), ARRAY_A );
			if(!empty($rows))
			{
				$addons_array[ $this->addonID ] = array();
				foreach($rows as $row)
				{
					unset($row['id']);
					unset($row['formid']);
					$addons_array[ $this->addonID ][] = $row;
				}
			}
			return $addons_array;
		} // End export_form

		/**
		 *	It is called when the form is imported to import the addons data too.
		 *  Receive an array with all the addons data, and the new form's id.
		 */
		public function import_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			if(isset($addons_array[$this->addonID]))
			{
				foreach($addons_array[$this->addonID] as $row)
				{
					if(!empty($row))
					{
						$row['formid'] = $formid;
						$wpdb->insert(
							$wpdb->prefix.$this->form_table,
							$row
						);
					}
				}
			}
		} // End import_form


    } // End Class

    // Main add-on code
    $CPAPPB_Coupons_obj = new CPAPPB_Coupons();

    global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_Coupons_obj->get_addon_id() ] = $CPAPPB_Coupons_obj;
}
?>