<?php
/*
....
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_CustomStatuses' ) )
{
    class CPAPPB_CustomStatuses extends CPAPPB_BaseAddon
    {
        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-customstatuses-20201229";
		protected $name = "Additional Booking Statuses";
		protected $description;
		
		public function get_addon_settings()
		{
			if( isset( $_REQUEST[ 'cpappb_CustomStatuses' ] ) )
			{	
				check_admin_referer( 'session_idcs_'.session_id(), '_cpappb_nonce' );
				update_option( 'cpappb_CustomStatuses_sitekey', trim( $_REQUEST[ 'cpappb_CustomStatuses_sitekey' ] ) );
			}	
			?>
			<form method="post">
				<div id="metabox_basic_settings" class="postbox" >
					<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
					<div class="inside"> 
						<table cellspacing="0" style="width:100%;">
							<tr>
								<td style="white-space:nowrap;width:200px;"><?php _e('New Custom Statuses (one per line)', 'appointment-hour-booking');?>:<br />
									<textarea cols="50" rows="5" name="cpappb_CustomStatuses_sitekey"><?php echo ( ( $key = get_option( 'cpappb_CustomStatuses_sitekey' ) ) !== false ) ? esc_textarea($key) : ''; ?></textarea>
								</td>
							</tr>                    
						</table>
						<input type="submit" name="Save settings" />
					</div>
					<input type="hidden" name="cpappb_CustomStatuses" value="1" />
					<input type="hidden" name="_cpappb_nonce" value="<?php echo wp_create_nonce( 'session_idcs_'.session_id() ); ?>" />
				</div>
			</form>
			<?php
		}
		
		/************************ ADDON CODE *****************************/
        /************************ ATTRIBUTES *****************************/

        /************************ CONSTRUCT *****************************/
		
        function __construct()
        {
			$this->description = __("The add-on allows to add new statuses to the bookings.", 'appointment-hour-booking');
			
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
			
			// TO-DO
			// Insert action or filter for checking the captcha in the submitted information
			
			// check captcha validation
			add_action( 'init', array( &$this, 'check_add_status' ), 1 );
            
        } // End __construct

		
		/************************ PUBLIC METHODS  *****************************/
        
        public function	check_add_status ()
        {
            global $cp_appb_plugin;
            $statuses = explode("\n",get_option( 'cpappb_CustomStatuses_sitekey', '' ));
            foreach ($statuses as $item)
            {
                $field = sanitize_text_field(trim($item));
                if ($field != '')
                    $cp_appb_plugin->add_status($field);
            }
        }
      
		
    } // End Class
    
    // Main add-on code
    $cpappb_CustomStatuses_obj = new CPAPPB_CustomStatuses();
    
	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $cpappb_CustomStatuses_obj->get_addon_id() ] = $cpappb_CustomStatuses_obj;
}
?>