<?php
/*
Documentation: https://apphourbooking.dwbooster.com/
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_Deposits' ) )
{
    class CPAPPB_Deposits extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-deposits-20151212";
		protected $name = "Deposit Payments";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_iCalImport_id' ] )
			)
			{
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									'depenable'	 => $_REQUEST["depenable"],
                                    'deptype'	 => $_REQUEST["deptype"],
                                    'amount'	 => $_REQUEST["depamount"],
								),
								array( '%d', '%d', '%d', '%s' )
							);                 
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["depenable"] = 0;
                $row["deptype"] = 0;
			    $row["amount"] = '50';
			} else {
			    $row["depenable"] = $rows[0]->depenable;
                $row["deptype"] = $rows[0]->deptype;
			    $row["amount"] = $rows[0]->amount;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_iCalImport_id" value="1" />
                     Enable deposit payments for this calendar? :<br />
                        <?php $option = $row['depenable']; ?>
                        <select name="depenable" id="depenable" onchange="cpappbdeposit_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
                   
                   <div id="depositcontent_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                        <br />
                        Deposit type:<br />
                        <?php $option = $row['deptype']; ?>
                        <select name="deptype" id="deptype">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>Fixed amount</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Percent of booking cost</option>
                         </select><br />
                         <br />
                         <strong>Deposit amount:</strong><br />
                         <input type="text" name="depamount" size="10" value="<?php $text = esc_attr($row['amount']); echo $text; ?>" /><br />
                   </div>
                   <script type="text/javascript">
                       function cpappbdeposit_display_option(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("depositcontent_yes").style.display = '';
                           else
                               document.getElementById("depositcontent_yes").style.display = 'none';
                       }
                   </script>                   
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_deposits';
        private $_inserted = false;
		private $_apphbmain;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			
			$this->description = __("The add-on enables the option to accept payment deposit as fixed amount or percent of the booking cost", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

			add_action( 'cpappb_process_data_before_insert', array( &$this, 'pp_Deposits' ), 1, 1 );

            add_filter( 'cpappb_calculate_price', array( &$this, 'pp_Deposits_process_price' ), 10, 2 );

			if( is_admin() )
			{
				// Delete forms
				add_action( 'apphb_delete_form', array(&$this, 'delete_form') );

				// Clone forms
				add_action( 'apphb_clone_form', array(&$this, 'clone_form'), 10, 2 );

				// Export addon data
				add_action( 'apphb_export_addons', array(&$this, 'export_form'), 10, 2 );

				// Import addon data
				add_action( 'apphb_import_addons', array(&$this, 'import_form'), 10, 2 );
			}

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb, $cp_appb_plugin;
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
                    formid mediumint(9) NOT NULL DEFAULT 1,
                    depenable INT NOT NULL,
                    deptype INT NOT NULL,
                    amount VARCHAR(250) DEFAULT '0' NOT NULL,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
            $wpdb->query($sql);

		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
         * process payment
         */
		public function pp_Deposits(&$params)
		{
            global $wpdb, $cp_appb_plugin;
            
            $codes = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE depenable=1 AND `formid`=".$params["formid"]);
            if (count($codes))
            {
                $price = $params["final_price"];    
                       
                if (floatval($price) == 0)            
                    return;
                $params["original_price"] = $price;
                
                $price = $this->pp_Deposits_process_price($price, $params["formid"]);               
                
                $params["final_price"] = $price;
            }    

		} // end pp_Deposits
        
        
        public function pp_Deposits_process_price($price, $form_id)
        {
            global $wpdb, $cp_appb_plugin;
            
            $codes = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE depenable=1 AND `formid`=".$form_id);
            if (count($codes))
            {  
                $coupon = $codes[0];
                if ($coupon->deptype==0)
                    $price = number_format ( $coupon->amount ,2, ".", "");
                else
                    $price = number_format ($price*$coupon->amount/100,2, ".", "");      
            }    
            return $price;
        }

        
		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		} 


        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL", $table = '')
        {
            global $wpdb, $cp_appb_plugin;
            if ($table == '')
                $table = $this->form_table;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }

		/**
		 *	Delete the form from the addon's table
		 */
        public function delete_form( $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$wpdb->delete( $wpdb->prefix.$this->form_table, array('formid' => $formid), '%d' );
		} // delete_form

        		/**
		 *	Clone the form's row
		 */
		public function clone_form( $original_form_id, $new_form_id )
		{
			global $wpdb, $cp_appb_plugin;

			$form_rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $original_form_id ), ARRAY_A);

			if(!empty($form_rows))
			{
				foreach($form_rows as $form_row)
				{
					unset($form_row["id"]);
					$form_row["formid"] = $new_form_id;
					$wpdb->insert( $wpdb->prefix.$this->form_table, $form_row);
				}
			}
		} // End clone_form

		/**
		 *	It is called when the form is exported to export the addons data too.
		 *  Receive an array with the other addons data, and the form's id for filtering.
		 */
		public function export_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ), ARRAY_A );
			if(!empty($rows))
			{
				$addons_array[ $this->addonID ] = array();
				foreach($rows as $row)
				{
					unset($row['id']);
					unset($row['formid']);
					$addons_array[ $this->addonID ][] = $row;
				}
			}
			return $addons_array;
		} // End export_form

		/**
		 *	It is called when the form is imported to import the addons data too.
		 *  Receive an array with all the addons data, and the new form's id.
		 */
		public function import_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			if(isset($addons_array[$this->addonID]))
			{
				foreach($addons_array[$this->addonID] as $row)
				{
					if(!empty($row))
					{
						$row['formid'] = $formid;
						$wpdb->insert(
							$wpdb->prefix.$this->form_table,
							$row
						);
					}
				}
			}
		} // End import_form


    } // End Class

    // Main add-on code
    $CPAPPB_Deposits_obj = new CPAPPB_Deposits();

    global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_Deposits_obj->get_addon_id() ] = $CPAPPB_Deposits_obj;
}
?>