<?php
/*

*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_DoubleOptIn' ) )
{
    class CPAPPB_DoubleOptIn extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-DoubleOptIn-20200805";
		protected $name = "Double opt-in email verification";
		protected $description;
        protected $approved_by_customer_indicator = '';

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_DoubleOptInlinks_id' ] )
			)
			{
                $cp_appb_plugin->add_field_verify ($wpdb->prefix.$this->form_table, 'cemail_notification_to_customer_disable', 'varchar(1) DEFAULT \'0\' NOT NULL');
                $cp_appb_plugin->add_field_verify ($wpdb->prefix.$this->form_table, 'cemail_notification_to_admin_disable', 'varchar(1) DEFAULT \'0\' NOT NULL');
                $cp_appb_plugin->add_field_verify ($wpdb->prefix.$this->form_table, 'cancel_dontuse_captcha', 'varchar(1) DEFAULT \'0\' NOT NULL');

                $_REQUEST["cemail_subject_notification_to_admin"] = stripcslashes($_REQUEST["cemail_subject_notification_to_admin"]);
                $_REQUEST["cemail_subject_notification_to_customer"] = stripcslashes($_REQUEST["cemail_subject_notification_to_customer"]);
                $_REQUEST["cemail_notification_to_customer"] = stripcslashes($_REQUEST["cemail_notification_to_customer"]);
                $_REQUEST["cemail_notification_to_admin"] = stripcslashes($_REQUEST["cemail_notification_to_admin"]);

			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,

									'cancelredirect'	 => $_REQUEST["dopin_cancelredirect"],
									'cancelredirectexpired'	 => $_REQUEST["dopin_cancelredirectexpired"],
                                    'canceluntil'	 => $_REQUEST["dopin_canceluntil"],

                                    'cemail_subject_notification_to_admin'	 => $_REQUEST["dopin_cemail_subject_notification_to_admin"],
									'cnadmin_emailformat'	 => $_REQUEST["dopin_cnadmin_emailformat"],
                                    'cemail_notification_to_admin'	 => $_REQUEST["dopin_cemail_notification_to_admin"],

                                    'cemail_subject_notification_to_customer'	 => $_REQUEST["dopin_cemail_subject_notification_to_customer"],
                                    'cncustomer_emailformat'	 => $_REQUEST["dopin_cncustomer_emailformat"],
                                    'cemail_notification_to_customer'	 => $_REQUEST["dopin_cemail_notification_to_customer"],

                                    'cemail_notification_to_customer_disable' => $_REQUEST["dopin_cemail_notification_to_customer_disable"],
                                    'cemail_notification_to_admin_disable' => $_REQUEST["dopin_cemail_notification_to_admin_disable"],
                                    'cancel_dontuse_captcha' => $_REQUEST["doubleoptin_cancel_dontuse_captcha"]

								),
								array( '%d', '%s', '%s', '%s',
								             '%s', '%s', '%s',
                                             '%s', '%s', '%s',
                                             '%s', '%s', '%s'
								              )
							);
			}
            
			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["cancelredirect"] = $cp_appb_plugin->get_site_url();
			    $row["cancelredirectexpired"] = $cp_appb_plugin->get_site_url();
                $row["canceluntil"] = '0';
                $row["cemail_subject_notification_to_admin"] = 'Appointment verified...';
                $row["cnadmin_emailformat"] = 'text';
                $row["cemail_notification_to_admin"] = "The following appointment was verified:\n\n<"."%INFO%".">\n\nBest regards.";
                $row["cemail_subject_notification_to_customer"] = 'Appointment verified...';
                $row["cncustomer_emailformat"] = 'text';
                $row["cemail_notification_to_customer"] = "The following appointment was verified:\n\n<"."%INFO%".">\n\nBest regards.";
                $row["cemail_notification_to_customer_disable"] = '0';
                $row["cemail_notification_to_admin_disable"] = '0';
                $row["cancel_dontuse_captcha"] = '0';
			} else {
			    $row["cancelredirect"] = $rows[0]->cancelredirect;
			    $row["cancelredirectexpired"] = $rows[0]->cancelredirectexpired;
                $row["canceluntil"] = $rows[0]->canceluntil;
                $row["cemail_subject_notification_to_admin"] = $rows[0]->cemail_subject_notification_to_admin;
                $row["cnadmin_emailformat"] = $rows[0]->cnadmin_emailformat;
                $row["cemail_notification_to_admin"] = $rows[0]->cemail_notification_to_admin;
                $row["cemail_subject_notification_to_customer"] = $rows[0]->cemail_subject_notification_to_customer;
                $row["cncustomer_emailformat"] = $rows[0]->cncustomer_emailformat;
                $row["cemail_notification_to_customer"] = $rows[0]->cemail_notification_to_customer;
                $row["cemail_notification_to_customer_disable"] = $rows[0]->cemail_notification_to_customer_disable;
                $row["cemail_notification_to_admin_disable"] = $rows[0]->cemail_notification_to_admin_disable;
                $row["cancel_dontuse_captcha"] = $rows[0]->cancel_dontuse_captcha;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_DoubleOptInlinks_id" value="1" />
                   <strong>Note: Use the tag <span style="color:#007700">%EMAILVERIFY%</span> to add a Double Opt-in link into the emails and <a href="https://apphourbooking.dwbooster.com/images/articles/status-update-emails/default-booking-status.png" target="_blank">put the defalt status of the booking as pending</a>.</strong></br ></br >
                   On successful validation redirect to the following page:<br />
                   <input type="text" name="dopin_cancelredirect" value="<?php echo esc_attr($row['cancelredirect']); ?>"><br />
                   On failed validation redirect to the following page:<br />
                   <input type="text" name="dopin_cancelredirectexpired" value="<?php echo esc_attr($row['cancelredirectexpired']); ?>"><br />
                   Double Opt-in validation allowed up to (hours before the booking):<br />
                   <input type="text" name="dopin_canceluntil" value="<?php echo esc_attr($row['canceluntil']); ?>">
                   <br /><em>*Note: Calculation time based in WordPress timezone. Current WordPress time is <?php echo date("Y-m-d H:i", current_time('timestamp'));?></em>
                   <br /><br />
                   Protect Double Opt-in link with captcha? :<br />
                         <?php $option = $row['cancel_dontuse_captcha']; ?>
                         <select name="doubleoptin_cancel_dontuse_captcha" id="doubleoptin_cancel_dontuse_captcha">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>Yes</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>No</option>
                         </select><br /><br />

                   <div id="optin_cemailcontent_no">
                         &raquo; <a href="javascript:doubleoptin_abc_display_emailsdoptin(true);">Display Double Opt-in Email Contents</a>
                   </div>
                   <div id="optin_cemailcontent_yes" style="display:none">
                         &raquo; <a href="javascript:doubleoptin_abc_display_emailsdoptin(false);">Hide Double Opt-in Email Contents</a>

                         <br /><br />

                          <div style="display:none;border: 1px dotted black;padding:15px;">Note: The following additional tags can be used in the Double Opt-in email:<br /><br />
                          <strong>%optin_date%</strong>: Opt-in date.<br />
                          <strong>%optin_time%</strong>: Opt-in time.<br />
                          <strong>%optin_starttime%</strong>: Opt-in start time.<br />
                          <strong>%optin_endtime%</strong>: Opt-in end time.<br /><br />
                          ... the above tags are useful in the case of single date Double Opt-ins, in other cases use the standard tags available for all emails.
                          </div /><br />


                         Enable notification email to administrator? :<br />
                         <?php $option = $row['cemail_notification_to_admin_disable']; ?>
                         <select name="dopin_cemail_notification_to_admin_disable" id="cemail_notification_to_admin_disable">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>Yes</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>No</option>
                         </select><br />
                         <strong>Double Opt-in Email subject (to admin):</strong><br />
                         <input type="text" name="dopin_cemail_subject_notification_to_admin" size="70" value="<?php $text = esc_attr($row['cemail_subject_notification_to_admin']); echo $text; ?>" /><br />
                         <strong>Double Opt-in Email format?:</strong><br />
                         <?php $option = $row['cnadmin_emailformat']; ?>
                         <select name="dopin_cnadmin_emailformat">
                          <option value="text"<?php if ($option != 'html') echo ' selected'; ?>>Plain Text (default)</option>
                          <option value="html"<?php if ($option == 'html') echo ' selected'; ?>>HTML (use html in the textarea below)</option>
                         </select><br />
                         <strong>Double Opt-in Email content (to admin):</strong><br />
                         <textarea cols="70" rows="5" name="dopin_cemail_notification_to_admin"><?php $text = $row['cemail_notification_to_admin']; echo $text; ?></textarea><br />

                         <br /><br />

                         Enable notification email to customer? :<br />
                         <?php $option = $row['cemail_notification_to_customer_disable']; ?>
                         <select name="dopin_cemail_notification_to_customer_disable" id="cemail_notification_to_customer_disable">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>Yes</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>No</option>
                         </select><br />
                         <strong>Double Opt-in Email subject (to customer):</strong><br />
                         <input type="text" name="dopin_cemail_subject_notification_to_customer" size="70" value="<?php $text = esc_attr($row['cemail_subject_notification_to_customer']); echo $text; ?>" /><br />
                         <strong>Double Opt-in Email format?:</strong><br />
                         <?php $option = $row['cncustomer_emailformat']; ?>
                         <select name="dopin_cncustomer_emailformat">
                          <option value="text"<?php if ($option != 'html') echo ' selected'; ?>>Plain Text (default)</option>
                          <option value="html"<?php if ($option == 'html') echo ' selected'; ?>>HTML (use html in the textarea below)</option>
                         </select><br />
                         <strong>DoubleOptIn Email content (to customer):</strong><br />
                         <textarea cols="70" rows="5" name="dopin_cemail_notification_to_customer"><?php $text = $row['cemail_notification_to_customer']; echo $text; ?></textarea><br />


                   </div>
                   <script type="text/javascript">
                       function doubleoptin_abc_display_emailsdoptin(dodisplay)
                       {
                           document.getElementById("optin_cemailcontent_no").style.display = 'none';
                           document.getElementById("optin_cemailcontent_yes").style.display = 'none';
                           if (dodisplay)
                               document.getElementById("optin_cemailcontent_yes").style.display = '';
                           else
                               document.getElementById("optin_cemailcontent_no").style.display = '';
                       }
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_DoubleOptInlinks';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("Double opt-in email verification link to mark the booking as approved", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            add_action( 'cpappb_process_data', array( &$this, 'pp_DoubleOptIn_process_data' ), 10, 1 );

			add_action( 'init', array( &$this, 'pp_DoubleOptIn_update_status' ), 10, 1 );

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    cancelredirect varchar(255) DEFAULT '' NOT NULL,
			        cancelredirectexpired varchar(255) DEFAULT '' NOT NULL,
                    canceluntil varchar(255) DEFAULT '' NOT NULL,
                    cemail_subject_notification_to_admin mediumtext,
                    cnadmin_emailformat varchar(255) DEFAULT '' NOT NULL,
                    cemail_notification_to_admin mediumtext,
                    cemail_subject_notification_to_customer mediumtext,
                    cncustomer_emailformat varchar(255) DEFAULT '' NOT NULL,
                    cemail_notification_to_customer mediumtext,
                    cemail_notification_to_customer_disable varchar(1) DEFAULT '0' NOT NULL,
                    cemail_notification_to_admin_disable varchar(1) DEFAULT '0' NOT NULL,
                    cancel_dontuse_captcha varchar(1) DEFAULT '0' NOT NULL,
					UNIQUE KEY id (id)
				) $charset_collate;";

			$wpdb->query($sql);
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}

        public function pp_DoubleOptIn_process_data( &$params )
        {
            global $wpdb, $cp_appb_plugin;
            $passcode = get_option('CPAHB_PASSCODE',"");
            if ($passcode == '')
            {
                $passcode = openssl_random_pseudo_bytes(10);
                update_option( 'CPAHB_PASSCODE', base64_encode($passcode));
            }
            $params["EMAILVERIFY"] = $cp_appb_plugin->get_site_url().'?cpahb_em=1&i='.($params[ 'itemnumber' ]).'&v='.substr(md5($params[ 'itemnumber' ].get_option('CPAHB_PASSCODE',"")),0,10);

            $params["emailverify"] = $params["EMAILVERIFY"];
            $wpdb->update( $wpdb->prefix.$cp_appb_plugin->table_messages,
                       array( 'posted_data' => serialize($params) ),
                       array ( 'id' => $params[ 'itemnumber' ]),
                       array( '%s' ),
	                   array( '%d' )
                       );
        }


		public function pp_DoubleOptIn_update_status( )
		{
            global $wpdb, $cp_appb_plugin;


            if (!isset($_GET["cpahb_em"]) || !intval($_GET["cpahb_em"]))
                return;

            $itemnumber = intval($_GET["i"]);

            if (substr(md5($itemnumber.get_option('CPAHB_PASSCODE',"")),0,10) != $_GET["v"])
            {
                echo 'Access denied - verify value is not correct. Be sure to paste the complete link.';
                exit ();
            }

            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $itemnumber) );

            if (!count($myrows))
            {
                return;
            }
            
            $cp_appb_plugin->setId($myrows[0]->formid);

            $DoubleOptInSettings = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $myrows[0]->formid )
					);
            @session_start();
            if (
                   $DoubleOptInSettings[0]->cancel_dontuse_captcha != '1' &&
                   (
                       !apply_filters( 'cpappb_valid_cancel_submission', false) &&
                       (
                           (
                             (strtolower($cp_appb_plugin->get_param('hdcaptcha_cancel_post')) != strtolower($_SESSION['rand_code'])) ||
                             ($_SESSION['rand_code'] == '')
                           )
                           &&
                           (
                             (md5(strtolower($cp_appb_plugin->get_param('hdcaptcha_cancel_post'))) != ($_COOKIE['rand_code'])) ||
                             ($_COOKIE['rand_code'] == '')
                           )
                       )
                   )
                )
                {
                    echo '<html><head><title>'.__('Double Opt-in', 'appointment-hour-booking').'</title><link rel="stylesheet" type="text/css" href="?cp_cpappb_resources=css" /></head><body id="ahb_cancel_body" style="text-align:center;">';
                    echo '<div id="ahb_doubleoptin_header"></div>';
                    echo '<form id="ahb_doubleoptin_form" action="" method="post" style="border: 1px dotted #444444; width: 350px; margin: auto;padding:20px;">';
                    echo '<p>'.__('Please enter the following security code to confirm the appointment:', 'appointment-hour-booking').'</p>';
                    
                    $recaptcha = apply_filters('cpappb_cancel_captcha', '');
                    if ($recaptcha == '')
                    {
                    ?>
                    <img src="<?php echo $cp_appb_plugin->get_site_url().'/?'.$cp_appb_plugin->prefix.'_captcha=captcha&ps=&inAdmin=1&width='.$cp_appb_plugin->get_option('cv_width', CP_APPBOOK_DEFAULT_cv_width).'&height='.$cp_appb_plugin->get_option('cv_height', CP_APPBOOK_DEFAULT_cv_height).'&letter_count='.$cp_appb_plugin->get_option('cv_chars', CP_APPBOOK_DEFAULT_cv_chars).'&min_size='.$cp_appb_plugin->get_option('cv_min_font_size', CP_APPBOOK_DEFAULT_cv_min_font_size).'&max_size='.$cp_appb_plugin->get_option('cv_max_font_size', CP_APPBOOK_DEFAULT_cv_max_font_size).'&noise='.$cp_appb_plugin->get_option('cv_noise', CP_APPBOOK_DEFAULT_cv_noise).'&noiselength='.$cp_appb_plugin->get_option('cv_noise_length', CP_APPBOOK_DEFAULT_cv_noise_length).'&bcolor='.$cp_appb_plugin->get_option('cv_background', CP_APPBOOK_DEFAULT_cv_background).'&border='.$cp_appb_plugin->get_option('cv_border', CP_APPBOOK_DEFAULT_cv_border).'&font='.$cp_appb_plugin->get_option('cv_font', CP_APPBOOK_DEFAULT_cv_font); ?>"  id="captchaimg" alt="security code" border="0"  />
                    <br /><?php _e("Please enter the security code",'appointment-hour-booking'); ?>:<br />
                    <input type="text" size="20" name="hdcaptcha_cancel_post" id="hdcaptcha_cancel_post" value="" /><br /><br />
                    <?php 
                    }  else {
                        echo $recaptcha;    
                    }
                    ?>
                    <input type="submit" size="20" name="verifybtn" id="verifybtn" value="<?php echo __('Verify', 'appointment-hour-booking'); ?>" />
                    <?php
                    if (@$_POST["verifybtn"] != '') echo '<br /><br /><div style="font-weight:bold;color:#ff0000;">'.__('Incorrect verification code', 'appointment-hour-booking').'</div>';
                    echo '</form>';                    
                    echo '<div id="ahb_doubleoptin_footer"></div>';
                    do_action('cpappb_captcha_footer');
                    echo '</body></html>';
                    exit;
                }

            // check here if DoubleOptIn is being requested
            $cancelled_date = '';
            $cancelled_time = '';
            $data = unserialize($myrows[0]->posted_data);
            $something_cancelled = array();
            $already_cancelled = false;
            $DoubleOptIn_up = date("Y-m-d H:i", strtotime(date("Y-m-d H:i", current_time('timestamp'))." +".$DoubleOptInSettings[0]->canceluntil." hours"));
            for($i=0; $i<count($data["apps"]); $i++)
                if (
                     apply_filters('cpappb_limit_allowed', true, $myrows[0]->formid, date("Y-m-d",strtotime($data["apps"][$i]["date"])) ) &&
                     (!isset($_GET["s"]) || $_GET["s"] == $data["apps"][$i]["id"]) &&   // if this sub-item has to be cancelled
                     $DoubleOptIn_up < date("Y-m-d H:i",strtotime($data["apps"][$i]["date"]." ".substr($data["apps"][0]["slot"],0,strpos($data["apps"][0]["slot"],"/")) ))   // and if the time restriction matches
                   )
                   {
                       if ( isset($data["apps"][$i]["cancelled"]) && $data["apps"][$i]["cancelled"] != '' )
                       {
                           $data["apps"][$i]["cancelled"] = $this->approved_by_customer_indicator;
                           $something_cancelled[]  = $data["apps"][$i];
                           $cancelled_date = $cp_appb_plugin->format_date($data["apps"][$i]["date"]);
                           $cancelled_time = $data["apps"][$i]["slot"];
                       }
                       else
                           $already_cancelled = true;
                   }

            if (count($something_cancelled))
            {
                $data_update = array ( 'posted_data' => serialize($data) );
                $wpdb->update ( $wpdb->prefix.$cp_appb_plugin->table_messages, $data_update, array( 'id' => $itemnumber ));
                do_action( 'cpappb_update_status', $itemnumber, $this->approved_by_customer_indicator );

                // send emails
                $email_content_admin = $DoubleOptInSettings[0]->cemail_notification_to_admin;
                $email_content_customer = $DoubleOptInSettings[0]->cemail_notification_to_customer;

                $email_content_admin = str_replace('<'.'%', '%', $email_content_admin);
                $email_content_customer = str_replace('<'.'%', '%', $email_content_customer);
                $email_content_admin = str_replace('%'.'>', '%', $email_content_admin);
                $email_content_customer = str_replace('%'.'>', '%', $email_content_customer);

                $email_content_admin = str_replace('%INFO%', $myrows[0]->data, $email_content_admin);
                $email_content_customer = str_replace('%INFO%', $myrows[0]->data, $email_content_customer);
                $email_content_admin = str_replace('%itemnumber%', $itemnumber, $email_content_admin);
                $email_content_customer = str_replace('%itemnumber%', $itemnumber, $email_content_customer);

                $email_content_admin = str_replace('%optin_date%', $cancelled_date, $email_content_admin);
                $email_content_customer = str_replace('%optin_date%', $cancelled_date, $email_content_customer);

                $email_content_admin = str_replace('%optin_time%', $cancelled_time, $email_content_admin);
                $email_content_customer = str_replace('%optin_time%', $cancelled_time, $email_content_customer);

                $slotpieces = explode("/",$cancelled_time);

                $email_content_admin = str_replace('%optin_starttime%', $slotpieces[0], $email_content_admin);
                $email_content_customer = str_replace('%optin_starttime%', $slotpieces[0], $email_content_customer);

                $email_content_admin = str_replace('%optin_endtime%', $slotpieces[1], $email_content_admin);
                $email_content_customer = str_replace('%optin_endtime%', $slotpieces[1], $email_content_customer);

                $email_content_customer = $cp_appb_plugin->replace_tags($email_content_customer, $data);
                $email_content_admin = $cp_appb_plugin->replace_tags($email_content_admin, $data);

                $from = $cp_appb_plugin->get_option('fp_from_email', @CP_APPBOOK_DEFAULT_fp_from_email);
                $to = explode(",",$cp_appb_plugin->get_option('fp_destination_emails', @CP_APPBOOK_DEFAULT_fp_destination_emails));
                $to = array_unique ($to);
                if (!strpos($from,">"))
                    $from = '"'.$from.'" <'.$from.'>';

                if ('html' == $DoubleOptInSettings[0]->cnadmin_emailformat) $content_type = "Content-Type: text/html; charset=utf-8\n"; else $content_type = "Content-Type: text/plain; charset=utf-8\n";

                if ($DoubleOptInSettings[0]->cemail_notification_to_admin_disable != '1')
                    foreach ($to as $item)
                        if (trim($item) != '')
                            wp_mail(trim($item), $cp_appb_plugin->replace_tags($DoubleOptInSettings[0]->cemail_subject_notification_to_admin, $data), $email_content_admin,
                                "From: ".$from."\r\n".
                                $content_type.
                                "X-Mailer: PHP/" . phpversion());

                // send email to customer
                $to = $myrows[0]->notifyto;
                if ('html' == $DoubleOptInSettings[0]->cncustomer_emailformat) $content_type = "Content-Type: text/html; charset=utf-8\n"; else $content_type = "Content-Type: text/plain; charset=utf-8\n";

                if ($DoubleOptInSettings[0]->cemail_notification_to_customer_disable != '1')
                    wp_mail(trim($to), $cp_appb_plugin->replace_tags($DoubleOptInSettings[0]->cemail_subject_notification_to_customer, $data), $email_content_customer,
                            "From: ".$from."\r\n".
                            $content_type.
                            "X-Mailer: PHP/" . phpversion());

                header("Location: ".$DoubleOptInSettings[0]->cancelredirect);
            }
            else
            {
                if ($already_cancelled)
                    header("Location: ".$DoubleOptInSettings[0]->cancelredirect);
                else
                    header("Location: ".$DoubleOptInSettings[0]->cancelredirectexpired);
            }
            exit ();

		}


    } // End Class

    // Main add-on code
    $cpappb_DoubleOptIn_obj = new CPAPPB_DoubleOptIn();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $cpappb_DoubleOptIn_obj->get_addon_id() ] = $cpappb_DoubleOptIn_obj;
}

