<?php
/*

*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_BookingEdition' ) )
{
    class CPAPPB_BookingEdition extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-Edition-20170903";
		protected $name = "Edition / Booking modification for customers";
		protected $description;
        protected $pending_message = 'This booking is pending payment of the balance. Complete the payment or revert the selection to the original.';

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_BookingEditionlinks_id' ] )
			)
			{

			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,

                                    'bookingeditpage'	 => $_REQUEST["bookingeditpage"],
									'bookingredirect'	 => $_REQUEST["bookingredirect"],
									'bookingredirectexpired'	 => $_REQUEST["bookingredirectexpired"],
                                    'editionuntil'	 => $_REQUEST["editionuntil"],

                                    'ebemail_subject_notification_to_admin'	 => $_REQUEST["ebemail_subject_notification_to_admin"],
									'ebadmin_emailformat'	 => $_REQUEST["ebadmin_emailformat"],
                                    'ebemail_notification_to_admin'	 => $_REQUEST["ebemail_notification_to_admin"],

                                    'ebemail_subject_notification_to_customer'	 => $_REQUEST["ebemail_subject_notification_to_customer"],
                                    'ebcustomer_emailformat'	 => $_REQUEST["ebcustomer_emailformat"],
                                    'ebemail_notification_to_customer'	 => $_REQUEST["ebemail_notification_to_customer"],

                                    'ebemail_notification_to_customer_disable' => $_REQUEST["ebemail_notification_to_customer_disable"],
                                    'ebemail_notification_to_admin_disable' => $_REQUEST["ebemail_notification_to_admin_disable"],
                                    'eb_dontuse_captcha' => $_REQUEST["eb_dontuse_captcha"]

								),
								array( '%d', '%s', '%s', '%s', '%s',
								             '%s', '%s', '%s',
                                             '%s', '%s', '%s',
                                             '%s', '%s', '%s'
								              )
							);
			}
            
			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
                $row["bookingeditpage"] = $cp_appb_plugin->get_site_url();
			    $row["bookingredirect"] = $cp_appb_plugin->get_site_url();
			    $row["bookingredirectexpired"] = $cp_appb_plugin->get_site_url();
                $row["editionuntil"] = '24';
                $row["ebemail_subject_notification_to_admin"] = 'Appointment edited...';
                $row["ebadmin_emailformat"] = 'text';
                $row["ebemail_notification_to_admin"] = "The following appointment was edited:\n\n<"."%INFO%".">\n\nBest regards.";
                $row["ebemail_subject_notification_to_customer"] = 'Appointment edited...';
                $row["ebcustomer_emailformat"] = 'text';
                $row["ebemail_notification_to_customer"] = "The following appointment was edited:\n\n<"."%INFO%".">\n\nBest regards.";
                $row["ebemail_notification_to_customer_disable"] = '0';
                $row["ebemail_notification_to_admin_disable"] = '0';
                $row["eb_dontuse_captcha"] = '0';
			} else {               
                $row["bookingeditpage"] = $rows[0]->bookingeditpage;
			    $row["bookingredirect"] = $rows[0]->bookingredirect;
			    $row["bookingredirectexpired"] = $rows[0]->bookingredirectexpired;
                $row["editionuntil"] = $rows[0]->editionuntil;
                $row["ebemail_subject_notification_to_admin"] = $rows[0]->ebemail_subject_notification_to_admin;
                $row["ebadmin_emailformat"] = $rows[0]->ebadmin_emailformat;
                $row["ebemail_notification_to_admin"] = $rows[0]->ebemail_notification_to_admin;
                $row["ebemail_subject_notification_to_customer"] = $rows[0]->ebemail_subject_notification_to_customer;
                $row["ebcustomer_emailformat"] = $rows[0]->ebcustomer_emailformat;
                $row["ebemail_notification_to_customer"] = $rows[0]->ebemail_notification_to_customer;
                $row["ebemail_notification_to_customer_disable"] = $rows[0]->ebemail_notification_to_customer_disable;
                $row["ebemail_notification_to_admin_disable"] = $rows[0]->ebemail_notification_to_admin_disable;
                $row["eb_dontuse_captcha"] = $rows[0]->eb_dontuse_captcha;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_BookingEditionlinks_id" value="1" />
                   
                   Indicate the address of the page that contains the booking edition form:<br />
                   <input type="text" name="bookingeditpage" size="90" value="<?php echo esc_attr($row['bookingeditpage']); ?>"><br />
                   <strong>Note: <span style="color:#ff0000">Important!</span> Add the shortcode <span style="color:#ff0000">[CP_APP_HOUR_BOOKING_EDIT_BOOKING]</span> to the above page.</strong></br ></br >
                   
                   
                   <strong>Note: Use the tag <span style="color:#ff0000">%EDITLINK%</span> to add a edition link into the emails or the <span style="color:#ff0000">EDITLINK</span> column name in the lists shortcode.</strong></br ></br >
                   
                   After edited redirect to the following page:<br />
                   <input type="text" name="bookingredirect" size="90" value="<?php echo esc_attr($row['bookingredirect']); ?>"><br />
                   If edition link expired redirect to the following page:<br />
                   <input type="text" name="bookingredirectexpired" size="90" value="<?php echo esc_attr($row['bookingredirectexpired']); ?>"><br />
                   Edition allowed up to (hours before the booking):<br />
                   <input type="text" name="editionuntil" value="<?php echo esc_attr($row['editionuntil']); ?>">
                   <br /><em>*Note: Calculation time based in WordPress timezone. Current WordPress time is <?php echo date("Y-m-d H:i", current_time('timestamp'));?></em>
                   <br /><br />
                   <div style="display:none">
                   Protect Edition link with captcha? :<br />
                         <?php $option = $row['eb_dontuse_captcha']; ?>
                         <select name="eb_dontuse_captcha" id="eb_dontuse_captcha">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>Yes</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>No</option>
                         </select><br /><br />
                  </div>       
                  <div>
                   <div id="abceditcemailcontent_no">
                         &raquo; <a href="javascript:abcedit_display_emails(true);">Display Edition Email Contents</a>
                   </div>
                   <div id="abceditcemailcontent_yes" style="display:none">
                         &raquo; <a href="javascript:abcedit_display_emails(false);">Hide Edition Email Contents</a>

                         <br /><br />

                          <div style="border: 1px dotted black;padding:15px;">Note: The following tags can be used in the Edition email: <a target="_blank" href="https://apphourbooking.dwbooster.com/faq#q507">https://apphourbooking.dwbooster.com/faq#q507</a>
                                                 
                          </div /><br />


                         Enable notification email to administrator? :<br />
                         <?php $option = $row['ebemail_notification_to_admin_disable']; ?>
                         <select name="ebemail_notification_to_admin_disable" id="ebemail_notification_to_admin_disable">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>Yes</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>No</option>
                         </select><br />
                         <strong>Edition Email subject (to admin):</strong><br />
                         <input type="text" name="ebemail_subject_notification_to_admin" size="70" value="<?php $text = esc_attr($row['ebemail_subject_notification_to_admin']); echo $text; ?>" /><br />
                         <strong>Edition Email format?:</strong><br />
                         <?php $option = $row['ebadmin_emailformat']; ?>
                         <select name="ebadmin_emailformat">
                          <option value="text"<?php if ($option != 'html') echo ' selected'; ?>>Plain Text (default)</option>
                          <option value="html"<?php if ($option == 'html') echo ' selected'; ?>>HTML (use html in the textarea below)</option>
                         </select><br />
                         <strong>Edition Email content (to admin):</strong><br />
                         <textarea cols="70" rows="5" name="ebemail_notification_to_admin"><?php $text = $row['ebemail_notification_to_admin']; echo $text; ?></textarea><br />

                         <br /><br />

                         Enable notification email to customer? :<br />
                         <?php $option = $row['ebemail_notification_to_customer_disable']; ?>
                         <select name="ebemail_notification_to_customer_disable" id="ebemail_notification_to_customer_disable">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>Yes</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>No</option>
                         </select><br />
                         <strong>Edition Email subject (to customer):</strong><br />
                         <input type="text" name="ebemail_subject_notification_to_customer" size="70" value="<?php $text = esc_attr($row['ebemail_subject_notification_to_customer']); echo $text; ?>" /><br />
                         <strong>Edition Email format?:</strong><br />
                         <?php $option = $row['ebcustomer_emailformat']; ?>
                         <select name="ebcustomer_emailformat">
                          <option value="text"<?php if ($option != 'html') echo ' selected'; ?>>Plain Text (default)</option>
                          <option value="html"<?php if ($option == 'html') echo ' selected'; ?>>HTML (use html in the textarea below)</option>
                         </select><br />
                         <strong>Edition Email content (to customer):</strong><br />
                         <textarea cols="70" rows="5" name="ebemail_notification_to_customer"><?php $text = $row['ebemail_notification_to_customer']; echo $text; ?></textarea><br />


                   </div>
                  </div> 
                   <script type="text/javascript">
                       function abcedit_display_emails(dodisplay)
                       {
                           document.getElementById("abceditcemailcontent_no").style.display = 'none';
                           document.getElementById("abceditcemailcontent_yes").style.display = 'none';
                           if (dodisplay)
                               document.getElementById("abceditcemailcontent_yes").style.display = '';
                           else
                               document.getElementById("abceditcemailcontent_no").style.display = '';
                       }
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_Editionlinks';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on allows customers to modify/edit the bookings", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            add_shortcode( 'CP_APP_HOUR_BOOKING_EDIT_BOOKING', array( &$this, 'pp_EditionForm' ) );

            add_action( 'cpappb_process_data', array( &$this, 'pp_Edition_process_data' ), 10, 1 );

			//add_action( 'init', array( &$this, 'pp_Edition_update_status' ), 10, 1 );
            
            add_filter('ahb_edition_allowed', array( &$this, 'pp_Edition_allowed_by_id' ), 10, 2);
            
            add_filter('ahb_edition_verifyhash', array( &$this, 'pp_verify_hash' ), 10, 2);
            
            add_filter('ahb_edition_link', array( &$this, 'pp_Edition_link' ), 10, 3);
            
            add_action( 'cpappb_redirect', array( &$this, 'cpappb_redirect'), 10 );

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    bookingeditpage varchar(255) DEFAULT '' NOT NULL,
                    bookingredirect varchar(255) DEFAULT '' NOT NULL,
			        bookingredirectexpired varchar(255) DEFAULT '' NOT NULL,
                    editionuntil varchar(255) DEFAULT '' NOT NULL,
                    ebemail_subject_notification_to_admin mediumtext,
                    ebadmin_emailformat varchar(255) DEFAULT '' NOT NULL,
                    ebemail_notification_to_admin mediumtext,
                    ebemail_subject_notification_to_customer mediumtext,
                    ebcustomer_emailformat varchar(255) DEFAULT '' NOT NULL,
                    ebemail_notification_to_customer mediumtext,
                    ebemail_notification_to_customer_disable varchar(1) DEFAULT '0' NOT NULL,
                    ebemail_notification_to_admin_disable varchar(1) DEFAULT '0' NOT NULL,
                    eb_dontuse_captcha varchar(1) DEFAULT '0' NOT NULL,
					UNIQUE KEY id (id)
				) $charset_collate;";

			$wpdb->query($sql);
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


        public function pp_EditionForm($atts)
		{
            global $wpdb, $cp_appb_plugin;           
            extract( shortcode_atts( array(
	        	'calendar' => '',
	        ), $atts ) ); 
            
            $error_message = __('Access denied - edition link is not correct.', 'appointment-hour-booking');
            
            $verifyhash = @$_GET["ahbedt"];
            $itemnumber = intval(@$_GET["i"]);
            if (substr(md5($itemnumber.get_option('CPAHB_PASSCODEEDITION',"")),0,10) != $verifyhash)
            {
                return $error_message;                
            }
            
            $event_query = "SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=".intval($itemnumber);
            $event = $wpdb->get_results( $event_query );
            if (count($event))
                $preload_params = unserialize($event[0]->posted_data);
            else
                return $error_message;
            
            $is_pending_payment = (
                                   floatval($preload_params["oldprice"]) && 
                                   floatval($preload_params["final_price"]) > floatval(@$preload_params["oldprice"]) &&
                                   (!count($preload_params["apps"]) || $preload_params["apps"][0]["cancelled"] != '')
                                  );
               
                
            
            $EditionSettings = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $preload_params["formid"] )
					);
            if (!count($EditionSettings))        
                return  __('Access denied - edition add-on not enabled for this booking form.', 'appointment-hour-booking');;
                       
            if (!$this->pp_Edition_allowed($preload_params))   
                return '<script>document.location="'.$EditionSettings[0]->bookingredirectexpired.'";</script>';          

            return ($is_pending_payment?"<div class=\"ahb_pending\">".__($this->pending_message,'appointment-hour-booking')."</div>":"").$cp_appb_plugin->filter_content(array('id' => $preload_params["formid"], 'prefill' => $itemnumber));
        }



		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}


        /**
         * Avoid redirect the plugin to the thanks page.
         */
        function cpappb_redirect()
        {
            global $wpdb, $cp_appb_plugin;
                        
			if (!(isset($_POST["edititem"]) && $_POST["edititem"]))  // if it isn't edition then no need to send emails
                return true;
                
            
            $EditionSettings = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $cp_appb_plugin->getId() )
					);         
                    
            if (!$EditionSettings[0]->bookingredirect)        
                return true;
            else
            {
                header("Location: ". ($EditionSettings[0]->bookingredirect));
                exit();                                
            }
        }
        
        
        public function pp_Edition_process_data( &$params )
        {
            global $wpdb, $cp_appb_plugin;
               
            if (isset($_POST["edititem"]) && $_POST["edititem"])   
            {
                if (floatval($params["final_price"]) > floatval(@$params["oldprice"]))                       
                {
                    for($k=0; $k<count($params["apps"]); $k++)
                    {
                         $params["apps"][$k]["cancelled"] = $cp_appb_plugin->get_option('defaultstatus', '');         
                         $params["app_status_".($k+1)] = $cp_appb_plugin->get_option('defaultstatus', '');         
                    }
                } 
                else 
                {
                    if (floatval($params["final_price"]) < floatval(@$params["oldprice"]))
                        for($k=0; $k<count($params["apps"]); $k++)
                        {
                             $params["apps"][$k]["cancelled"] = $cp_appb_plugin->get_option('paidstatus', '');         
                             $params["app_status_".($k+1)] = $cp_appb_plugin->get_option('paidstatus', '');         
                        }
                }                 
            }

            $params["EDITLINK"] = $this->pp_Edition_link('', $params[ 'itemnumber' ], $params[ 'formid' ]); 
            $params["editlink"] = $params["EDITLINK"];
            if ($params["EDITLINK"])
                $wpdb->update( $wpdb->prefix.$cp_appb_plugin->table_messages,
                       array( 'posted_data' => serialize($params) ),
                       array ( 'id' => $params[ 'itemnumber' ]),
                       array( '%s' ),
	                   array( '%d' )
                       );
            
            // send emails
            $EditionSettings = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params[ 'formid' ] )
					);  
            if (!count($EditionSettings))  
                return;
            
            if (!(isset($_POST["edititem"]) && $_POST["edititem"]))  // if it isn't edition then no need to send emails
                return; 
                
            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT data FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $params[ 'itemnumber' ]) );
            $buffer = $myrows[0]->data;
                
            $from = $cp_appb_plugin->get_option('fp_from_email', @CP_APPBOOK_DEFAULT_fp_from_email);
            if ($EditionSettings[0]->ebemail_notification_to_admin_disable == '0')
            {
                $subject = $cp_appb_plugin->replace_tags($EditionSettings[0]->ebemail_subject_notification_to_admin, $params);
                $message = $cp_appb_plugin->replace_tags($EditionSettings[0]->ebemail_notification_to_admin, $params);
                $to = explode(",",$cp_appb_plugin->get_option('fp_destination_emails', @CP_APPBOOK_DEFAULT_fp_destination_emails));
                $from_1 = $from;
                if ('html' == $EditionSettings[0]->ebadmin_emailformat)
                    $message = str_replace('%INFO%',str_replace("\n","<br />",str_replace('<','&lt;',$buffer)),$message);
                else
                    $message = str_replace('%INFO%',$buffer,$message);
                if ('html' == $EditionSettings[0]->ebadmin_emailformat) $content_type = "Content-Type: text/html; charset=utf-8\n"; else $content_type = "Content-Type: text/plain; charset=utf-8\n";
                foreach ($to as $item)
                    if (trim($item) != '')
                    {
                        if (!strpos($from_1,">"))
                            $from_1 = '"'.$from_1.'" <'.$from_1.'>';                  
                        wp_mail(trim($item), $subject, $message,
                            "From: ".$from_1."\r\n". 
                            $content_type.
                            "X-Mailer: PHP/" . phpversion(), $attachments);
                    }                
            }
            
            if ($EditionSettings[0]->ebemail_notification_to_customer_disable == '0')
            {
                $subject = $cp_appb_plugin->replace_tags($EditionSettings[0]->ebemail_subject_notification_to_customer, $params);
                $message = $cp_appb_plugin->replace_tags($EditionSettings[0]->ebemail_notification_to_customer, $params);
                $to = $cp_appb_plugin->get_option('cu_user_email_field', CP_APPBOOK_DEFAULT_cu_user_email_field);
                $to = $params[$to];
                $from_1 = $from;
                if ('html' == $EditionSettings[0]->ebcustomer_emailformat)
                    $message = str_replace('%INFO%',str_replace("\n","<br />",str_replace('<','&lt;',$buffer)),$message);
                else
                    $message = str_replace('%INFO%',$buffer,$message);                
                if ('html' == $EditionSettings[0]->ebcustomer_emailformat) $content_type = "Content-Type: text/html; charset=utf-8\n"; else $content_type = "Content-Type: text/plain; charset=utf-8\n";
                if (trim($to) != '')
                {
                    if (!strpos($from_1,">"))
                        $from_1 = '"'.$from_1.'" <'.$from_1.'>';                  
                    wp_mail(trim($to), $subject, $message,
                        "From: ".$from_1."\r\n". 
                        $content_type.
                        "X-Mailer: PHP/" . phpversion(), $attachments);
                }                  
            }
                       
        }
        
 
        public function pp_Edition_link($link, $itemnumber, $formid)
        {
            global $wpdb, $cp_appb_plugin;
            
            $passcode = get_option('CPAHB_PASSCODEEDITION',"");
            if ($passcode == '')
            {
                $passcode = openssl_random_pseudo_bytes(10);
                update_option( 'CPAHB_PASSCODEEDITION', base64_encode($passcode));
            }            
            
            $EditionSettings = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid )
					);
            if (!count($EditionSettings))        
                return $link;
            
            $bkpage = $EditionSettings[0]->bookingeditpage;
            if (!strpos("--".$bkpage,"?"))
                $bkpage .= '?';
            else 
                $bkpage .= '&';
            
            return $bkpage.'i='.$itemnumber.'&ahbedt='.substr(md5($itemnumber.get_option('CPAHB_PASSCODEEDITION',"")),0,10);
        }
        
    
        public function pp_verify_hash($allowed, $params)
        {
            global $wpdb, $cp_appb_plugin;
            if (isset($_GET["ahbedt"])) 
                $verifyhash = $_GET["ahbedt"];
            else if (isset($_POST["ahbedt"])) 
                $verifyhash = $_POST["ahbedt"];
            else
                return $allowed;

            $EditionSettings = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);
            if (!count($EditionSettings))        
                return $allowed;   

           return (substr(md5($params["itemnumber"].get_option('CPAHB_PASSCODEEDITION',"")),0,10) == $verifyhash);            
                        
        }
 
 
        public function pp_Edition_allowed_by_id($allowed, $id)
        {
            global $wpdb, $cp_appb_plugin;
            $event_query = "SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=".intval($id);
            $event = $wpdb->get_results( $event_query );
            if (count($event))
            {
                return $this->pp_Edition_allowed( unserialize($event[0]->posted_data) );
            }
            else
                return $allowed;
        }
 
 
        public function pp_Edition_allowed($params)
        {
            global $wpdb, $cp_appb_plugin;
            $EditionSettings = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);
            if (!count($EditionSettings))        
                return false;
            $Edition_up = date("Y-m-d H:i", strtotime(date("Y-m-d H:i", current_time('timestamp'))." +".$EditionSettings[0]->editionuntil." hours"));
            foreach ($params["apps"] as $app)
            {
                $time = $app["date"]." ".substr($app["slot"],0,strpos($app["slot"],"/"));               
                $time = substr($time,0, strpos($time."/","/")); 
                if (date("Y-m-d H:i", strtotime($time)) < $Edition_up)
                    return false;
            }
            return true;
        }


    } // End Class

    // Main add-on code
    $CPAPPB_BookingEdition_obj = new CPAPPB_BookingEdition();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_BookingEdition_obj->get_addon_id() ] = $CPAPPB_BookingEdition_obj;
}

