<?php
/*

*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_FollowUp' ) )
{
    class CPAPPB_FollowUp extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-FollowUp-20170903";
		protected $name = "FollowUp notifications for bookings";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_FollowUplinks_id' ] )
			)
			{
                $_REQUEST["foupemail_subject_notification_to_customer"] = stripcslashes($_REQUEST["foupemail_subject_notification_to_customer"]);
                $_REQUEST["foupemail_notification_to_customer"] = stripcslashes($_REQUEST["foupemail_notification_to_customer"]);
              
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									
									'foup_enable'	 => $_REQUEST["foup_enable"],
                                    'foup_hours'	 => $_REQUEST["foup_hours"],
                                    
                                    'foupemail_subject_notification_to_customer'	 => $_REQUEST["foupemail_subject_notification_to_customer"],
                                    'foupcustomer_emailformat'	 => $_REQUEST["foupcustomer_emailformat"],
                                    'foupemail_notification_to_customer'	 => $_REQUEST["foupemail_notification_to_customer"]

								),
								array( '%d', '%d', '%d',  
                                             '%s', '%s', '%s'
								              )
							);
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["foup_enable"] = 0;
			    $row["foup_hours"] = 24;
                $row["foupemail_subject_notification_to_customer"] = 'Appointment followup...';
                $row["foupcustomer_emailformat"] = 'text';
                $row["foupemail_notification_to_customer"] = "Followup for the following appointment:\n\n<"."%INFO%".">\n\nBest regards.";
			} else {
			    $row["foup_enable"] = $rows[0]->foup_enable;
			    $row["foup_hours"] = $rows[0]->foup_hours;
                $row["foupemail_subject_notification_to_customer"] = $rows[0]->foupemail_subject_notification_to_customer;
                $row["foupcustomer_emailformat"] = $rows[0]->foupcustomer_emailformat;
                $row["foupemail_notification_to_customer"] = $rows[0]->foupemail_notification_to_customer;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_FollowUplinks_id" value="1" />
                     Enable followups? :<br />
                        <?php $option = $row['foup_enable']; ?>
                        <select name="foup_enable" id="foup_enable" onchange="foup_display_emails(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
                   
                   
                   <div id="foupemailcontent_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                        <br /><br />
                        <strong>Send email
                        <input type="text" name="foup_hours" value="<?php echo esc_attr($row['foup_hours']); ?>"> hours after the booked time</strong>
                        <br /><em>*Note: Calculation based in server time. Current server time is <?php echo date("Y-m-d H:i");?></em>
                        <br /><br />
                                                 
                         <strong>Followup Email subject (to customer):</strong><br />
                         <input type="text" name="foupemail_subject_notification_to_customer" size="70" value="<?php $text = esc_attr($row['foupemail_subject_notification_to_customer']); echo $text; ?>" /><br />
                         <strong>Followup Email format?:</strong><br />
                         <?php $option = $row['foupcustomer_emailformat']; ?>
                         <select name="foupcustomer_emailformat">
                          <option value="text"<?php if ($option != 'html') echo ' selected'; ?>>Plain Text (default)</option>
                          <option value="html"<?php if ($option == 'html') echo ' selected'; ?>>HTML (use html in the textarea below)</option>
                         </select><br />
                         <strong>Followup Email content (to customer):</strong><br />
                         <textarea cols="70" rows="5" name="foupemail_notification_to_customer"><?php $text = $row['foupemail_notification_to_customer']; echo $text; ?></textarea><br />
                                                
                   </div>
                   <script type="text/javascript">
                       function foup_display_emails(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("foupemailcontent_yes").style.display = '';
                           else
                               document.getElementById("foupemailcontent_yes").style.display = 'none';
                       }
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_followuplinks';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on adds support for followup notifications", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
            
			add_action( 'init', array( &$this, 'pp_FollowUp_update_status' ), 10, 1 );

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb, $cp_appb_plugin;

			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    foup_enable INT NOT NULL,
                    foup_hours INT NOT NULL,
                    foupemail_subject_notification_to_customer mediumtext,
                    foupcustomer_emailformat varchar(255) DEFAULT '' NOT NULL, 
                    foupemail_notification_to_customer mediumtext,
					UNIQUE KEY id (id)
				) $charset_collate;";
            
			$wpdb->query($sql);
            
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}
        
		public function pp_FollowUp_update_status( )
		{
            global $wpdb, $cp_appb_plugin;
            
            $last_checked = get_option('CPAHB_foup_LASTCHECKED',0);
            if ($last_checked != 0 && $last_checked > date("Y-m-d H:i:s", strtotime("-3 minutes")))
                return;
            update_option('CPAHB_foup_LASTCHECKED',date("Y-m-d H:i:s"));
            
            if (get_option('CPAHB_foup_UPDATE_QUERIES','0') != '1')
            {
                $cp_appb_plugin->add_field_verify($wpdb->prefix.$cp_appb_plugin->table_messages, 'followupstatus', 'int(11) NOT NULL DEFAULT 0');update_option('CPAHB_foup_UPDATE_QUERIES','1');
            }    
            
            $saved_id = $cp_appb_plugin->getId();
            $followups = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE foup_enable=1" );        
            foreach ($followups as $followup)
            {
                $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE followupstatus=0 AND formid=%d", $followup->formid) );
                $cp_appb_plugin->setId($followup->formid);
                $from = $cp_appb_plugin->get_option('fp_from_email', @CP_APPBOOK_DEFAULT_fp_from_email);                               
                if (!strpos($from,">"))
                    $from = '"'.$from.'" <'.$from.'>'; 
                
                $followup_up = date("Y-m-d H:i", strtotime("-".$followup->foup_hours." hours"));
                $followup_up_max = date("Y-m-d H:i", strtotime($followup_up. " -72 hours"));
                foreach ($myrows as $item)
                {
                    $data = unserialize($item->posted_data); 
                    $one_missing = false;
                    for($i=0; $i<count($data["apps"]); $i++)
                       if (   
                              !isset($data["apps"][$i]["followup_sent"]) &&
                              (!isset($data["apps"][$i]["cancelled"]) || $data["apps"][$i]["cancelled"] == '')
                          ) 
                        {
                            $apptime = date("Y-m-d H:i",strtotime($data["apps"][$i]["date"]." ".substr($data["apps"][$i]["slot"],0,strpos($data["apps"][$i]["slot"],"/")) ));
                            if ($apptime < date("Y-m-d H:i:s") && $apptime <= $followup_up && $apptime >= $followup_up_max)
                            {
                                $data["apps"][$i]["followup_sent"] = '1';
                                $wpdb->update ( $wpdb->prefix.$cp_appb_plugin->table_messages, array('posted_data' => serialize($data)), array( 'id' => $item->id ));
                                
                                $appstext = $cp_appb_plugin->get_appointments_text($data["apps"]);
                                // send followup
                                $email_content_customer = $followup->foupemail_notification_to_customer;                                
                                $email_content_customer = str_replace('<'.'%', '%', $email_content_customer);
                                $email_content_customer = str_replace('%'.'>', '%', $email_content_customer);
                                $email_content_customer = str_replace('%INFO%', $item->data, $email_content_customer);
                                $email_content_customer = str_replace('%itemnumber%', $item->id, $email_content_customer);
                                $email_content_customer = str_replace('%apps%', $appstext, $email_content_customer);
                                
                                foreach ($data as $itemnd => $value)
                                    $email_content_customer = str_replace('%'.$itemnd.'%',(is_array($value)?(implode(", ",$value)):($value)),$email_content_customer);                                     
                                for ($kit=0;$kit<500;$kit++)
                                    $email_content_customer = str_replace('%fieldname'.$kit.'%',"",$email_content_customer);                                   

                                // send email to customer
                                $to = $item->notifyto;
                                if ('html' == $followup->foupcustomer_emailformat) $content_type = "Content-Type: text/html; charset=utf-8\n"; else $content_type = "Content-Type: text/plain; charset=utf-8\n";
                                   
                                if ($to != $cp_appb_plugin->blocked_by_admin_indicator)   
                                    wp_mail(trim($to), $followup->foupemail_subject_notification_to_customer, $email_content_customer,
                                            "From: ".$from."\r\n".
                                            $content_type.
                                            "X-Mailer: PHP/" . phpversion());                                
                                
                                // trigger followup action
                                do_action( 'cpahb_followup_sent', array('params' => $data, 'slot' => $data["apps"][$i], formid => $followup->formid) );                                
                            } 
                            else if ($apptime > $followup_up)
                                $one_missing = true;
                        }
                                            
                    if (!$one_missing)
                        $wpdb->update ( $wpdb->prefix.$cp_appb_plugin->table_messages, array('followupstatus' => 1), array( 'id' => $item->id ));
                        
                }
            }

            $cp_appb_plugin->setId($saved_id);             
         
		}


    } // End Class

    // Main add-on code
    $cpappb_FollowUp_obj = new CPAPPB_FollowUp();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $cpappb_FollowUp_obj->get_addon_id() ] = $cpappb_FollowUp_obj;
}

