<?php
/*
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_FrontendLists' ) )
{
    class CPAPPB_FrontendLists extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-FrontendLists-20181221";
		protected $name = "Frontend List: Grouped by Date Add-on";
		protected $description;
        protected $max_image_width = 250;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;
			// Insertion in database			
			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   Sample shortcode:<br /><br />
                   
                   <div style="border:1px dotted black; font-size: 120%;padding: 10px; line-height:1.5em; font-weight: bold; ">
              
                   [CP_APP_HOUR_BOOKING_DATEGROUPED_LIST &nbsp;
<span style="color:#aaaa00">calendar="<?php echo $form_id; ?>"</span> &nbsp;
<span style="color:#aa00aa">datelabel="Date"</span> &nbsp;
<span style="color:#aaaa00">service=""</span> &nbsp;
<span style="color:#aa00aa">columnlabels="time,service,email,other label" </span> &nbsp;
<span style="color:#aaaa00">columns="time,service,email,fieldname1"  </span>                  
]
                    </div>
                   Note: The additional parameter <strong>service=""</strong> can be optionally used to filter by service. The parameter <strong>service=""</strong> means
                   all services. You can filter by service name, example: <strong>service="Service 1"</strong><br />
                   <br />    
                   Note: The additional parameter <strong>groupby="time"</strong> can be optionally used to group by time-slot instead date.<br />
                   <br />                    
                   Note: The additional parameter <strong>status=""</strong> can be optionally used to filter by status. The parameter <strong>status=""</strong> or <strong>status="approved"</strong> means
                   approved items only. You can filter by service name, example: <strong>service="Pending"</strong><br />
                   <br />                   
                   Note: The additional parameters <strong>datefrom="today"</strong> and <strong>dateto="today +30 days"</strong> can be optionally used to limit the booking dates in the list. The additional parameter <strong>onlycurrentuser="yes"</strong>can be added to display only bookings of the current logged in user.<br /><br />
                   You can use the following styles to customize the table:<br />
                   <br /> 
                   Note: The additional parameter <strong>blocked="no"</strong> can be optionally used to exclude blocked times.<br />
                   <br />                    
                   <pre>
     .cpappbtable { 
       /* styles for the whole table */
     }
     
     .cpappbtable th {
         /* styles for the table header cells */
     }
     
     .cpappbtable td{
         /* styles for the table data cells */
     }
     
    .cpappbheadermth,.cpappbheadermtd  {
        /* styles for the table header group cells */
    }        
     
     .cpappbheader1 {
         /* styles for the table header column #1, same exists for column #2, #3, ... */
     }
     
     .cpappbcol1 {
         /* styles for the table data cell column #1, same exists for column #2, #3, ... */
     }
                   </pre>
                   You can add the styles into the <a href="admin.php?page=cp_apphourbooking_settings">CSS customization area</a>.
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/


        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on allows to displays list (schedule) of bookings grouped by date in the frontend", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
                      
            add_shortcode( 'CP_APP_HOUR_BOOKING_DATEGROUPED_LIST', array( &$this, 'pp_FrontendLists' ) );
            add_action( 'init', array( &$this, 'pp_checkDeletion' ), 10 );	

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

	

		/************************ PUBLIC METHODS  *****************************/


        /**
         * check deletion
         */
		public function pp_checkDeletion($atts)
        {
            if (!isset($_GET["cpappb_d_item"]))
                return;
            
            if (!wp_verify_nonce( $_REQUEST['n'], 'cpappb_actions_deleteitem' ))    
                die('AppHourBK: Access not allowed.');
            
            die('AppHourBK: Not implemented yet.');
            
            global $wpdb;
            $id = intval($_GET["cpappb_d_item"]);
            $results = $wpdb->get_results("SELECT * FROM --------  WHERE id=". intval($id) ); // pending implementation
            if (count($results))
            {                       
                // here delete related post too
                $args = array (
                             'post_type'              => array( 'post' ),  
                             'post_status' => array('publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit', 'trash'),
                             'meta_query'             => array(
                                 array(
                                     'key'       => 'cpappb_addon_generated_post_by',  
                                     'value'     => $results[0]->reference,  // THE COUNTRY TO SEARCH
                                     'compare'   => 'LIKE',
                                 ),
                             ),
                         );
                $query = new WP_Query( $args );
				
                if (count($query->posts))
                    wp_delete_post ($query->posts[0]->ID);
				
				// delete the calendar entry
				$wpdb->query("DELETE FROM ------- WHERE id=".intval($id)); // pending implementation
                
                echo 'OK';
            }
            else 
                echo 'Nothing to delete.';
            exit;
        }
        
        
		/**
         * print list
         */
		public function pp_FrontendLists($atts)
		{
            global $wpdb, $cp_appb_plugin;           
            extract( shortcode_atts( array(
	        	'calendar' => '',
	        	'showdelete' => '0',
                'columnlabels' => 'TIME,SERVICE,email,other label',
	        	'columns' => 'TIME,SERVICE,email,fieldname1',
                'datefrom' => 'today -20 years',
                'from' => '',
                'dateto' => 'today +10 years',
                'to' => '',
                'groupby' => '',
                'paidonly' => "",
                'datelabel' => __('Date', 'appointment-hour-booking'),
                'status' => "-1",
                'service' => "",
                'blocked' => "",
                'exclude' => "",  // excludes a specific calendar field from the list in the case of mutiple calendars on the from
                'onlycurrentuser' => ""
	        ), $atts ) ); 
            
            wp_enqueue_script( "jquery" );
            $blocked = strtolower($blocked);
            $groupby = strtolower($groupby);
            $cond = '1=1';            
                
            if (strtolower($status) == 'approved')
                $status = '';
            
            if ($calendar)
            {
                $cond .= " AND formid=".intval($calendar);     
                $cp_appb_plugin->setId(intval($calendar));
            }

            if ($from != '') $datefrom = $from;
            if ($to != '') $dateto = $to;
             
            // calculate dates
            $from = date("Y-m-d",strtotime($datefrom));
            $to = date("Y-m-d",strtotime($dateto));
            
            $exclude = explode(",",$exclude);
            for($j=0; $j<count($exclude); $j++)
                $exclude[$i] = trim($exclude[$i]);
            
            if (strtolower($onlycurrentuser) == 'yes' || strtolower($onlycurrentuser) == 'true')
            {
                $current_user = wp_get_current_user();
                if ($current_user->ID)
                    $user_query = " whoadded='".esc_sql($current_user->ID)."' AND ";
                else
                    $user_query = "(1=0) AND "; // if no logged in user then no current user bookings
            }
            else
                $user_query = '';
        
            $events_query = "SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages.
                           " WHERE ".$user_query.$cond." ORDER BY time DESC";
            
            $events = $wpdb->get_results($events_query);
 // echo'<pre>';print_r($events);
            // pre-select time-slots
            $selection = array();            
            foreach($events as $item)
            {        
                $data = unserialize($item->posted_data);
                if (!$paidonly || $data['paid'])
                {
                    $appindex=0;
                    foreach($data["apps"] as $app)      
                    {
                        $appindex++;
                        if ($app["date"] >= $from && $app["date"] <= $to && ($status == '-1' || $status == $app["cancelled"]) 
						   // && $app["cancelled"] != 'Cancelled' && $app["cancelled"] != 'Cancelled by customer' 
							&& (!isset($app["field"]) || !in_array( $app["field"],$exclude) )
						   )
                        {               
                            if (
                                ($service == '' || $service == $app["service"]) &&
                                ($blocked != 'no' || $item->notifyto != $cp_appb_plugin->blocked_by_admin_indicator) 
                                )                         
                                {
                                    if (@$app["military"] == 0) 
                                    {
                                        $slot = str_replace("/","-",$app["slot"]);
                                        $times = explode("-",$slot);
                                        $times[0] = explode(":",$times[0]);
                                        $times[1] = explode(":",$times[1]);
                                        if ($cp_appb_plugin->get_option('display_emails_endtime', '') != '')
                                            $slot = ($times[0][0]>12?$times[0][0]-12:$times[0][0]).":".$times[0][1].' '.($times[0][0]>=12?'PM':'AM');
                                        else
                                            $slot = ($times[0][0]>12?$times[0][0]-12:$times[0][0]).":".$times[0][1].' '.($times[0][0]>=12?'PM':'AM') ."/".
                                                    ($times[1][0]>12?$times[1][0]-12:$times[1][0]).":".$times[1][1].' '.($times[1][0]>=12?'PM':'AM');
                                        $app["slot"] = $slot;           
                                    }
                                    $selection[] = array( 
                                                    $app["date"]." ".$app["slot"],  // 0
                                                    $app["date"],                   // 1 
                                                    $app["slot"],                   // 2
                                                    $data,                          // 3
                                                    $item->notifyto,                // 4
                                                    $item->data,                    // 5
                                                    $app["cancelled"],              // 6
                                                    $app["service"],                // 7
                                                    $appindex,                      // 8
                                                    $item->formid,                  // 9 
                                                    $item->id,                      // 10     
                                                    $app["quant"]                   // 11
                                                );
                                }
                        }    
                    }
                }
            }
      
            // order time-slots
            if (!function_exists("listgroupd_addon_appbkfastsortfn"))
            {    
                function listgroupd_addon_appbkfastsortfn($a, $b) { $ax = $a[0]; if (strpos($ax,"/")) $ax = substr($ax,0,strpos($ax,"/")); $bx = $b[0]; if (strpos($bx,"/")) $bx = substr($bx,0,strpos($bx,"/")); return (strtotime($ax) > strtotime($bx)); }
            }
            usort($selection, "listgroupd_addon_appbkfastsortfn" );        
           // echo'<pre>';print_r($selection);
            // clean fields IDs
            $fields = explode(",",trim($columns));
            for($j=0; $j<count($fields); $j++)
                $fields[$j] = strtolower(trim($fields[$j]));            
     
            $columnlabels = explode(",", $columnlabels);
            $columns = explode(",", $columns);

            if (!count($events))
                return '<div class="cpahb_nobookings">'.__('No bookings found','appointment-hour-booking').'</div>';
  
            $nonce = wp_create_nonce( 'cpappb_actions_deleteitem' );
            $buffer .= '<script type="text/javascript">function cpappb_deleteitem(id) { '.
            ' jQuery(function ($) {  '.
            ' if (confirm("'.(__('Are you sure you want to delete this item?','appointment-hour-booking')).'")) {'.
            '$("#cpappbrow"+id).hide(); '.
            '$.get( "?cpappb_d_item="+id+"&n='.$nonce.'"); '.
            ' }'.
            '} );'.
            '} </script>';
            $buffer .= '<style>.cpappbtable {  border-collapse: collapse;border-spacing: 0;width: 100%;} .cpappbtable .cpappbth { text-align: left; border: 1px solid #999; background-color:#BDD7EE; } .cpappbtable .cpappbth th, .cpappbtable td {border: 1px solid #999;text-align: left;padding: 8px;word-break: normal; }.cpappbheadermth,.cpappbheadermtd{ text-align: left; border: 1px solid #999 !important; background-color:#F8CBAD ;}</style>';            
            

            // list data rows
            $colnum = 0;
            $lastdate = '';
            for($i=0; $i<count($selection); $i++)
            {
                $colnum++;
                if ($lastdate != ($groupby == 'time'?$selection[$i][0]:$selection[$i][1]))
                {
                    if ($lastdate != '') $buffer .= '</table></div>';
                    $lastdate = ($groupby == 'time'?$selection[$i][0]:$selection[$i][1]);
                    $buffer .= '<div style="overflow-x:auto;"><table class="cpappbtable"><tr>';                    
                    // list header rows
                    $buffer .= '<th class="cpappbheadermth">'.$datelabel.'</th>';
                    $lastdate_trunk = $cp_appb_plugin->format_date($selection[$i][1]).($groupby == 'time'?' '.$selection[$i][2]:'');
                    $buffer .= '<td class="cpappbheadermtd" nowrap>'.$lastdate_trunk.'</td>';
                    $buffer .= '<tr>';
                    $colnum = 0;
                    foreach ($columnlabels as $item)
                    {
                        $colnum++;
                        $buffer .= '<th class="cpappbheader'.$colnum.' cpappbth">'.trim($item).'</th>';
                    }
                    if ($showdelete)
                        $buffer .= '<th class="cpappbheader'.($colnum++).' cpappbth"></th>';
                    $buffer .= '</tr>';                       
                }
                $buffer .= '<tr id="cpappbrow'.$event->id.'" class="'.($selection[$i][6]!=''?' cpappb_cancelled':'').'">';            
                for($j=0; $j<count($fields); $j++)
                {    
                   switch (strtolower($fields[$j])) {
                        case 'rownumber':
                            $value = $i+1;
                            break;
                        case 'weekday':
                            $value =  __(date('l',strtotime($selection[$i][1])),'appointment-hour-booking');
                            break;                       
                        case 'date':
                            $value = $selection[$i][1];
                            break;
                        case 'time':
                            $value = '<nobr>'.$selection[$i][2].'</nobr>';
                            break;
                        case 'email':
                            $value = $selection[$i][4]."&nbsp;";
                            break;  
                        case 'service':
                            $value = $selection[$i][7]."&nbsp;";
                            break;   
                        case 'quantity':
                            $value = $selection[$i][11]."&nbsp;";
                            break;                             
                        case 'cancelled':
                        case 'status':
                            if ($selection[$i][6] == '') 
                                $value = __('Approved','appointment-hour-booking');
                            else
                                $value = __($selection[$i][6],'appointment-hour-booking');
                            //$value = '&nbsp;';
                            break;                         
                        case 'data':
                            $value = substr($selection[$i][5],strpos($selection[$i][5],"\n\n")+2);
                            break;    
                        case 'paid':
                            $value = ($selection[$i][3]['paid']?__('Yes','appointment-hour-booking'):'&nbsp;');
                            break;
                        case 'cancel':
                            if ($selection[$i][6] == '' && apply_filters('cancellation_allowed', true, $selection[$i][0], $selection[$i][9]) )
                                $value =  "<a class=\"ahbcancelbtn\" href=\"javascript:ahbConfirmCancel('".$selection[$i][3]["CANCEL"]."&s=".$selection[$i][8]."');\">".__('Cancel','appointment-hour-booking')."</a>";
                            else
                                $value = "&nbsp";
                            break;     
                        case 'editlink':
                            if ( ($selection[$i][6] == '' || $selection[$i][6] == 'Pending')
                                && apply_filters('ahb_edition_allowed', false, $selection[$i][10]) )
                                $value = "<a class=\"ahbeditbtn\" href=\"".apply_filters('ahb_edition_link','',$selection[$i][10],$selection[$i][9])."\">".__('Edit','appointment-hour-booking')."</a>";
                            else
                                $value = "&nbsp";
                            break;                         
                        default:
                            if (is_array($selection[$i][3][$fields[$j]]))
                                $value = implode(",",$selection[$i][3][$fields[$j]]);
                            else
                                $value = ($selection[$i][3][$fields[$j]]==''?'&nbsp;':$selection[$i][3][$fields[$j]])."&nbsp;";
                    }         
                    $buffer .= '<td class="cpappbcol'.$colnum.'">'.$this->make_links_clickable(trim($value), is_array($params[$item]) ).'</td>';                
                }
                if ($showdelete)
                    $buffer .= '<td class="cpappbcol'.($colnum++).'">[<a href="javascript:cpappb_deleteitem('.$event->id.');">'.__('delete','appointment-hour-booking').'</a>]</td>';
                    $buffer .= '</tr>';               
            }   

            $buffer .= '</table></div>';
            
            return $buffer. '<script>function ahbConfirmCancel(link){if (confirm("'.str_replace('"','\"',__('Are you sure you want to cancel this booking?','appointment-hour-booking')).'"))document.location=link;}</script>';            
  
		} // end pp_FrontendLists


        private function make_links_clickable($text, $is_upload)
        {
            if (strpos('_'.$text,'<a'))
                return $text;
            $link = preg_replace('!(((f|ht)tp(s)?://)[-a-zA-Zа-яА-Я()0-9@:%_+.~#?&;//=]+)!i', '<a href="$1">*LLLK*</a>', $text);
			if ($is_upload)
				$link = str_replace('*LLLK*', basename($text), $link);
			else
				$link = str_replace('*LLLK*', $text, $link);
			return $link;
        }
       
		/**
		 * log
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}


    } // End Class

    // Main add-on code
    $CPAPPB_FrontendLists_obj = new CPAPPB_FrontendLists();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_FrontendLists_obj->get_addon_id() ] = $CPAPPB_FrontendLists_obj;
}


?>