<?php
require_once __DIR__.'/../autoload.php';

session_start();

$client = new Google_Client();
$client->setAuthConfig('client_secrets.json');
$client->addScope(Google_Service_Calendar::CALENDAR);

if (isset($_SESSION['access_token']) && $_SESSION['access_token']) {
  $client->setAccessToken($_SESSION['access_token']);

  // Print the next 10 events on the user's calendar.
  $calendarId = 'primary';
  $optParams = array(
    'maxResults' => 10,
    'orderBy' => 'startTime',
    'singleEvents' => TRUE,
    'timeMin' => date('c'),
  );
  
  $service = new Google_Service_Calendar($client);
  
   /************* INSERT ****************/
$event = new Google_Service_Calendar_Event(array(
 'summary' => 'My Summary',
 'location' => 'My Location',
 'description' => 'My Description',
 'start' => array(
   'dateTime' => '2018-11-25T09:09:00',
   'timeZone' => 'Asia/Singapore',
 ),
 'end' => array(
   'dateTime' => '2018-11-25T17:16:00',
   'timeZone' => 'Asia/Singapore',
 ),
 'attendees' => array(
   array('email' => 'abc@gmail.com'),
   array('email' => 'def@gmail.my'),
 ),
 'reminders' => array(
   'useDefault' => FALSE,
   'overrides' => array(
     array('method' => 'email', 'minutes' => 24 * 60),
     array('method' => 'popup', 'minutes' => 10),
   ),
 ),
));

$events = $service->events->insert($calendarId, $event);
printf('Event created: %s', $events->htmlLink);
echo '<hr>';
/************* END:: INSERT ****************/  
  
  // list events
  $results = $service->events->listEvents($calendarId, $optParams);

  if (count($results->getItems()) == 0) {
    print "No upcoming events found.\n";
  } else {
    print "Upcoming events:\n";
    foreach ($results->getItems() as $event) {
      $start = $event->start->dateTime;
      if (empty($start)) {
        $start = $event->start->date;
      }
      printf("%s (%s)\n", $event->getSummary(), $start);
    }
  }

} else {
  $redirect_uri = 'http://demos.net-factor.com/temporal/c/wp-content/plugins/calculated-fields-form/addons/gapi.addon/tmp/oauth2callback.php';
  header('Location: ' . filter_var($redirect_uri, FILTER_SANITIZE_URL));
}