<?php
require_once __DIR__.'/../autoload.php';

session_start();

$client = new Google_Client();
$client->setAuthConfigFile('client_secrets.json');
$client->setRedirectUri('http://demos.net-factor.com/temporal/c/wp-content/plugins/calculated-fields-form/addons/gapi.addon/tmp/oauth2callback.php');
$client->addScope(Google_Service_Calendar::CALENDAR);

if (! isset($_GET['code'])) {
  $auth_url = $client->createAuthUrl();
  header('Location: ' . filter_var($auth_url, FILTER_SANITIZE_URL));
} else {
  $client->authenticate($_GET['code']);
  $_SESSION['access_token'] = $client->getAccessToken();
  $redirect_uri = 'http://demos.net-factor.com/temporal/c/wp-content/plugins/calculated-fields-form/addons/gapi.addon/tmp/';
  header('Location: ' . filter_var($redirect_uri, FILTER_SANITIZE_URL));
}