<?php
/*
    iCal Import Addon
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_DataLookup' ) )
{
    function CPAPPB_DataLookup_load_cron() { $addon = new CPAPPB_DataLookup(); $addon->DataLookup(); }
    
    class CPAPPB_DataLookup extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-DataLookup-20200102";
		protected $name = "Data Lookup";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_DataLookup_id' ] )
			)
			{
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									
									'datal_enable'	 => $_REQUEST["datal_enable"],
                                    
                                    'dlookupfield'	 => $_REQUEST["dlookupfield"],
                                    
                                    'prefillfields'	 => $_REQUEST["prefillfields"],

								),
								array( '%d', '%d', '%s', '%s' )
							);
                
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["datal_enable"] = 0;
			    $row["dlookupfield"] = 'fieldname1';
                $row["prefillfields"] = 'fieldname2';
			} else {
			    $row["datal_enable"] = $rows[0]->datal_enable;
			    $row["dlookupfield"] = $rows[0]->dlookupfield;
                $row["prefillfields"] = $rows[0]->prefillfields;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_DataLookup_id" value="1" />
                     Enable data lookup for this calendar? :<br />
                        <?php $option = $row['datal_enable']; ?>
                        <select name="datal_enable" id="datal_enable" onchange="abcdatalookup_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
                   
                   <div id="datalookupcontent_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                         <br />
                         <strong>ID of the field that will be used as reference for the data lookup (ex: fieldname1):</strong><br />
                         <input name="dlookupfield" type="text" value="<?php $text = esc_attr($row['dlookupfield']); echo $text; ?>" /><br />
                         <br />
                         <strong>ID of the field that will pre-filled (ex: fieldname2):</strong><br />
                         <input name="prefillfields" type="text" value="<?php $text = esc_attr($row['prefillfields']); echo $text; ?>" /><br />   
                         <em>You can enter more than one field to be prefilled, use comma separated IDs, example: fieldname2,fieldname3,fieldname4</em><br />
                   </div>
                   <script type="text/javascript">
                       function abcdatalookup_display_option(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("datalookupcontent_yes").style.display = '';
                           else
                               document.getElementById("datalookupcontent_yes").style.display = 'none';
                       }
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_datalookup';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on enables data lookup in previous bookings to auto-fill fields", 'appointment-hour-booking' );
            // Check if the plugin is active
                         
			if( !$this->addon_is_active() ) return;

            add_filter( 'init', array( &$this, 'data_lookup' ), 10 );
            
            add_filter( 'cpappb_the_customjs', array( &$this, 'insert_script'), 99, 2 );
            
            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;

			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    datal_enable INT NOT NULL,
                    dlookupfield TEXT,
                    prefillfields TEXT,
					UNIQUE KEY id (id)
				) $charset_collate;";
            
			$wpdb->query($sql);
            
		} // end update_database
      
      

		/**
         * insert lookup script
         */ 
        public function	insert_script( $form_code, $id )
		{
            global $wpdb, $cp_appb_plugin;
            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d ORDER BY formid DESC", $id )
					);
			if (!$rows[0]->datal_enable)
			    return $form_code;		
            
            $fields = explode(",", trim($rows[0]->prefillfields));
            
            ob_start();
?>


var fieldId = "<?php echo esc_attr($rows[0]->dlookupfield); ?>";
jQuery(document).one('showHideDepEvent', function(){
    (function($) {
        $("#"+fieldId+"_1").blur(function(){
<?php foreach ($fields as $fld) { ?>        
   
            $.ajax({
              url: "<?php echo $cp_appb_plugin->get_site_url(); ?>/?CPAHB_datalookup="+$(this).val()+"&field=<?php echo $fld; ?>&form=<?php echo $id; ?>",
            }).done(function(data) {
              $("#<?php echo $fld; ?>_1").val(data);
            });
<?php } ?>
        })
    })(jQuery); 
});
<?php            
            $custom_script = ob_get_contents();
            ob_end_clean();
            
			return $form_code.$custom_script;
		} // End insert_script      
      
		/**
         * generated booking info
         */
        public function data_lookup()
        {
            global $wpdb, $cp_appb_plugin;
            
            if (!isset($_GET["CPAHB_datalookup"]) || $_GET["CPAHB_datalookup"] == '')
                return;
            
            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $_GET["form"] )
					);
			if (!$rows[0]->datal_enable)
			    return;			
      
            $dl = $_GET["CPAHB_datalookup"];
            $org_booking_rows = $wpdb->get_results( "SELECT posted_data FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE formid=".intval($_GET["form"]) . " ORDER BY id DESC" ); 
            foreach ($org_booking_rows as $org_booking_row)
            {
                $params = unserialize($org_booking_row->posted_data);
                if (@$params[$rows[0]->dlookupfield] == $dl)
                {
                    echo $params[sanitize_key($_GET["field"])];
                    exit;
                }
            }
            exit;
		} // End get_form_options      


		/************************ PUBLIC METHODS  *****************************/


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}
        


    } // End Class

    // Main add-on code
    $CPAPPB_DataLookup_obj = new CPAPPB_DataLookup();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_DataLookup_obj->get_addon_id() ] = $CPAPPB_DataLookup_obj;
}
