<?php
/*
Documentation: https://goo.gl/w3kKoH
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_iDealMollie' ) )
{
    class CPAPPB_iDealMollie extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-idealmollie-20151212";
		protected $name = "iDeal Mollie";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_iDealMollie_id' ] )
			)
			{
                $this->add_field_verify("imollie_optionlabel");
                $this->add_field_verify("mollielocale");
                
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									'idealmollie_api_username'	 => $_REQUEST["idealmollie_api_username"],
                                    'imollie_optionlabel'	 => $_REQUEST["imollie_optionlabel"],
									'return_error'	 => $_REQUEST["return_error"],
                                    'mollielocale'	 => $_REQUEST["mollielocale"],
									'enabled'	 => $_REQUEST["mollie_enabled"]
								),
								array( '%d', '%s', '%s', '%s', '%s')
							);
			}


			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["idealmollie_api_username"] = "";
                $row["imollie_optionlabel"] = __('Pay with iDeal/Mollie', 'appointment-hour-booking');                
			    $row["return_error"] = "";
                $row["mollielocale"] = "";
			    $row["enabled"] = "0";
			} else {
			    $row["idealmollie_api_username"] = $rows[0]->idealmollie_api_username;
                $row["imollie_optionlabel"] = $rows[0]->imollie_optionlabel;
			    $row["return_error"] = $rows[0]->return_error;
                $row["mollielocale"] = $rows[0]->mollielocale;
			    $row["enabled"] = $rows[0]->enabled;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_iDealMollie_id" value="1" />
                   <table class="form-table">
                    <tr valign="top">
                    <th scope="row"><?php _e('Enable iDeal-Mollie? (if enabled PayPal Standard is disabled)', 'appointment-hour-booking'); ?></th>
                    <td><select name="mollie_enabled">
                         <option value="0" <?php if (!$row["enabled"]) echo 'selected'; ?>><?php _e('No', 'appointment-hour-booking'); ?></option>
                         <option value="1" <?php if ($row["enabled"] == '1') echo 'selected'; ?>><?php _e('Yes', 'appointment-hour-booking'); ?></option>
                         <option value="2" <?php if ($row["enabled"] == '2') echo 'selected'; ?>><?php _e('Optional: This payment method + Pay Later (submit without payment)', 'appointment-hour-booking'); ?></option>
                         <option value="3" <?php if ($row["enabled"] == '3') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods (enabled)', 'appointment-hour-booking'); ?></option>
                         <option value="4" <?php if ($row["enabled"] == '4') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods  + Pay Later ', 'appointment-hour-booking'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Mollie API Key', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="idealmollie_api_username" size="20" value="<?php echo esc_attr($row["idealmollie_api_username"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('If payment fails return to this page', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="return_error" size="20" value="<?php echo esc_attr($row["return_error"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Payment option label (if multiple payment options are enabled)', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="imollie_optionlabel" size="20" value="<?php echo esc_attr($row["imollie_optionlabel"]); ?>" /></td>
                    </tr>      
                    <tr valign="top">
                    <th scope="row"><?php _e('Language (Locale)', 'appointment-hour-booking'); ?></th>
                    <td><select name="mollielocale">
                         <option value=""      <?php if (!$row["mollielocale"]) echo 'selected'; ?>><?php _e('- Autodetect -', 'appointment-hour-booking'); ?></option>
                         <option value="en_US" <?php if ($row["mollielocale"] == 'en_US') echo 'selected'; ?>>en_US</option>
                         <option value="nl_NL" <?php if ($row["mollielocale"] == 'nl_NL') echo 'selected'; ?>>nl_NL</option>
                         <option value="nl_BE" <?php if ($row["mollielocale"] == 'nl_BE') echo 'selected'; ?>>nl_BE</option>
                         <option value="fr_FR" <?php if ($row["mollielocale"] == 'fr_FR') echo 'selected'; ?>>fr_FR</option>
                         <option value="fr_BE" <?php if ($row["mollielocale"] == 'fr_BE') echo 'selected'; ?>>fr_BE</option>
                         <option value="de_DE" <?php if ($row["mollielocale"] == 'de_DE') echo 'selected'; ?>>de_DE</option>
                         <option value="de_AT" <?php if ($row["mollielocale"] == 'de_AT') echo 'selected'; ?>>de_AT</option>
                         <option value="de_CH" <?php if ($row["mollielocale"] == 'de_CH') echo 'selected'; ?>>de_CH</option>
                         <option value="es_ES" <?php if ($row["mollielocale"] == 'es_ES') echo 'selected'; ?>>es_ES</option>
                         <option value="ca_ES" <?php if ($row["mollielocale"] == 'ca_ES') echo 'selected'; ?>>ca_ES</option>
                         <option value="pt_PT" <?php if ($row["mollielocale"] == 'pt_PT') echo 'selected'; ?>>pt_PT</option>
                         <option value="it_IT" <?php if ($row["mollielocale"] == 'it_IT') echo 'selected'; ?>>it_IT</option>
                         <option value="nb_NO" <?php if ($row["mollielocale"] == 'nb_NO') echo 'selected'; ?>>nb_NO</option>
                         <option value="sv_SE" <?php if ($row["mollielocale"] == 'sv_SE') echo 'selected'; ?>>sv_SE</option>
                         <option value="fi_FI" <?php if ($row["mollielocale"] == 'fi_FI') echo 'selected'; ?>>fi_FI</option>
                         <option value="da_DK" <?php if ($row["mollielocale"] == 'da_DK') echo 'selected'; ?>>da_DK</option>
                         <option value="is_IS" <?php if ($row["mollielocale"] == 'is_IS') echo 'selected'; ?>>is_IS</option>
                         <option value="hu_HU" <?php if ($row["mollielocale"] == 'hu_HU') echo 'selected'; ?>>hu_HU</option>
                         <option value="pl_PL" <?php if ($row["mollielocale"] == 'pl_PL') echo 'selected'; ?>>pl_PL</option>
                         <option value="lv_LV" <?php if ($row["mollielocale"] == 'lv_LV') echo 'selected'; ?>>lv_LV</option>
                         <option value="lt_LT" <?php if ($row["mollielocale"] == 'lt_LT') echo 'selected'; ?>>lt_LT</option>
                        </select>
                    </td>
                    </tr>                      
                   </table>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_idealmollie';
        private $_inserted = false;
		private $_apphbmain;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			
			$this->description = __("The add-on adds support for iDeal via Mollie payments", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            if (!is_admin())
            {
			    add_action( 'cpappb_process_data_before_insert', array( &$this, 'pp_before_insert' ), 10, 1 );
                
			    add_action( 'cpappb_process_data', array( &$this, 'pp_idealmollie' ), 11, 1 );
                
			    add_action( 'init', array( &$this, 'pp_idealmollie_update_status' ), 10, 0 );
			    add_action( 'init', array( &$this, 'pp_idealmollie_return_page' ), 10, 0 );
                
			    add_filter( 'cpappb_the_form', array( &$this, 'insert_payment_fields'), 99, 2 );
            }
			else
			{
				// Delete forms
				add_action( 'apphb_delete_form', array(&$this, 'delete_form') );

				// Clone forms
				add_action( 'apphb_clone_form', array(&$this, 'clone_form'), 10, 2 );

				// Export addon data
				add_action( 'apphb_export_addons', array(&$this, 'export_form'), 10, 2 );

				// Import addon data
				add_action( 'apphb_import_addons', array(&$this, 'import_form'), 10, 2 );
			}

            $this->update_database();
            
        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb, $cp_appb_plugin;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
					enabled varchar(10) DEFAULT '0' NOT NULL ,
					idealmollie_api_username varchar(255) DEFAULT '' NOT NULL ,
					return_error varchar(255) DEFAULT '' NOT NULL ,
                    mollielocale varchar(255) DEFAULT '' NOT NULL ,
                    imollie_optionlabel varchar(255) DEFAULT '' NOT NULL ,
					UNIQUE KEY id (id)
				) $charset_collate;";
				//  idealmollie_api_signature varchar(255) DEFAULT '' NOT NULL ,
				//	currency varchar(255) DEFAULT '' NOT NULL ,

			$wpdb->query($sql);
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
         * process before insert
         */
		public function pp_before_insert(&$params)
		{
            global $wpdb, $cp_appb_plugin;

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID)
			    return;

			$params["payment_option"] = $this->name;

	    }


		/**
         * Check if the Optional is enabled in the form, and inserts radiobutton
         */
        public function	insert_payment_fields( $form_code, $id )
		{
            global $wpdb, $cp_appb_plugin;
            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $id )
					);
			if (empty( $rows ) || $rows[0]->enabled == '0')
			    return $form_code;

			// output radio-buttons here
			$form_code = preg_replace( '/<!--addons-payment-options-->/i', '<div><input type="radio" name="bccf_payment_option_paypal" vt="'.$this->addonID.'" value="'.$this->addonID.'" checked> '.__( (@$rows[0]->imollie_optionlabel==''?'Pay with iDeal/Mollie':$rows[0]->imollie_optionlabel), 'appointment-hour-booking').'</div><!--addons-payment-options-->', $form_code );

            if (($rows[0]->enabled == '2' || $rows[0]->enabled == '4') && !strpos($form_code,'bccf_payment_option_paypal" vt="0') )
			    $form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" vt="0" value="0"> '.__( $cp_appb_plugin->get_option('pay_later_label','Pay later',$id), 'appointment-hour-booking').'</div>', $form_code );

			if (substr_count ($form_code, 'name="bccf_payment_option_paypal"') > 1)
			    $form_code = str_replace( 'id="field-c0" style="display:none">', 'id="field-c0">', $form_code);

            return $form_code;
        }


		/**
         * process payment
         */
		public function pp_idealmollie($params)
		{
            global $wpdb, $cp_appb_plugin;

			// documentation: https://goo.gl/w3kKoH

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);
		    $payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID || floatval($params["final_price"]) == 0)
			    return;

            $pro_item_name = $cp_appb_plugin->get_option('product_name', 'Booking');
            foreach ($params as $item => $value)
                $pro_item_name = str_replace('<%'.$item.'%>',(is_array($value)?(implode(", ",$value)):($value)),$pro_item_name);

            $key = $rows[0]->idealmollie_api_username;
            try
            {
                if( !class_exists( 'Mollie_API_Client' ) )
                    require_once dirname(__FILE__) . "/mollie.addon/src/Mollie/API/Autoloader.php";
                $mollie = new Mollie_API_Client;
                $mollie->setApiKey( $key );
                $order_id = $params["itemnumber"];
                $parameters = array(
		            "amount"       => $params["final_price"],
		            "description"  => $pro_item_name,
		            "webhookUrl"   => $cp_appb_plugin->get_site_url().'/?apphbidealmollie_ipncheck=1&itemnumber='.$params[ 'itemnumber' ].'&d='.$params["formid"],
		            "redirectUrl"  => $cp_appb_plugin->get_site_url().'/?apphbidealmollie_ipnreturn=1&itemnumber='.$params[ 'itemnumber' ].'&d='.$params["formid"]
		            ,
		            "metadata"     => array(
		        	    "order_id" => $order_id,
		            ),
	            );
                if ($rows[0]->mollielocale)
                    $parameters["locale"] = $rows[0]->mollielocale;
                $payment = $mollie->payments->create($parameters);
                header("Location: " . $payment->getPaymentUrl());
            } catch (Exception $e) {
                echo "Error: ".$e->getMessage();
            }
            exit;
		} // end pp_idealmollie


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}

		public function pp_idealmollie_return_page( )
		{
            global $wpdb, $cp_appb_plugin;
            if(
				!isset( $_GET['apphbidealmollie_ipnreturn'] ) ||
				$_GET['apphbidealmollie_ipnreturn'] != '1' ||
				!isset( $_GET["itemnumber"] )
			) return;

            $itemnumber = intval(@$_GET['itemnumber'] );
            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $itemnumber) );
            if (empty( $myrows ))
			   return;
            $params = unserialize($myrows[0]->posted_data);
	    	$cp_appb_plugin->setId(intval($_GET["d"]));
			
			if($params["paid"]  == '1')
			{
				$location = $cp_appb_plugin->get_option('fp_return_page', $cp_appb_plugin->get_site_url());
	            header("Location: ".$location);
			}
			else
			{
				/**
				 * Action called after process the data received by PayPal.
				 * To the function is passed an array with the data collected by the form.
				 */
				//do_action( 'apphb_payment_processed', $submission->paypal_post );   
                
                //$params["paid"] = '1';
                //$params["payment_type"] = "Mollie";
                //$wpdb->query( $wpdb->prepare("UPDATE  ".$wpdb->prefix.$cp_appb_plugin->table_messages." SET posted_data=%s WHERE id=%d", serialize($params), $itemnumber) );
                //
                //$cp_appb_plugin->update_status($itemnumber, $cp_appb_plugin->get_option('defaultpaidstatus', '') );    
                $rowsmollie = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", intval(@$_GET["d"]) )
					);

			    if(empty($rowsmollie)) return;
                $location = $rowsmollie[0]->return_error;
	            header( 'Location: '.$location );
			}
            exit;
		}


		public function pp_idealmollie_update_status( )
		{
            global $wpdb, $cp_appb_plugin;
            if(
				!isset( $_GET['apphbidealmollie_ipncheck'] ) ||
				$_GET['apphbidealmollie_ipncheck'] != '1' ||
				!isset( $_GET["itemnumber"] )
			) return;

            $itemnumber = intval(@$_GET['itemnumber'] );

            $rowsmollie = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", intval(@$_GET["d"]) )
					);

			if(empty($rowsmollie)) return;

			try
			{
                require_once dirname(__FILE__) . "/mollie.addon/src/Mollie/API/Autoloader.php";
                $mollie = new Mollie_API_Client;
                $mollie->setApiKey( $rowsmollie[0]->idealmollie_api_username );
                $payment  = $mollie->payments->get($_POST["id"]);
	            $order_id = $payment->metadata->order_id;
	            if ($payment->isPaid() != TRUE)
	            {
	                $location = $rowsmollie[0]->return_error;
	                header( 'Location: '.$location );
	                exit;
	            }
	        } catch (Exception $e) {
                echo "Error: ".$e->getMessage();
                exit;
            }

            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $itemnumber) );
            if (empty( $myrows ))
			   return;
            $params = unserialize($myrows[0]->posted_data);           

			if ($params["paid"] != '1')
			{
				$params["paid"] = '1';
                $params["payment_type"] = "Mollie/iDeal";
                $wpdb->query( $wpdb->prepare("UPDATE  ".$wpdb->prefix.$cp_appb_plugin->table_messages." SET posted_data=%s WHERE id=%d", serialize($params), $itemnumber) );
                $cp_appb_plugin->update_status($itemnumber, $cp_appb_plugin->get_option('defaultpaidstatus', '') );
				$cp_appb_plugin->ready_to_go_reservation($itemnumber, "", $params);
			}

			$location = $cp_appb_plugin->get_option('fp_return_page', $cp_appb_plugin->get_site_url());
            header("Location: ".$location);
            exit;
		}
        
        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL", $table = '')
        {
            global $wpdb, $cp_appb_plugin;
            if ($table == '')
                $table = $this->form_table;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }        

		/**
		 *	Delete the form from the addon's table
		 */
        public function delete_form( $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$wpdb->delete( $wpdb->prefix.$this->form_table, array('formid' => $formid), '%d' );
		} // delete_form

		/**
		 *	Clone the form's row
		 */
		public function clone_form( $original_form_id, $new_form_id )
		{
			global $wpdb, $cp_appb_plugin;

			$form_rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $original_form_id ), ARRAY_A);

			if(!empty($form_rows))
			{
				foreach($form_rows as $form_row)
				{
					unset($form_row["id"]);
					$form_row["formid"] = $new_form_id;
					$wpdb->insert( $wpdb->prefix.$this->form_table, $form_row);
				}
			}
		} // End clone_form

		/**
		 *	It is called when the form is exported to export the addons data too.
		 *  Receive an array with the other addons data, and the form's id for filtering.
		 */
		public function export_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ), ARRAY_A );
			if(!empty($rows))
			{
				$addons_array[ $this->addonID ] = array();
				foreach($rows as $row)
				{
					unset($row['id']);
					unset($row['formid']);
					$addons_array[ $this->addonID ][] = $row;
				}
			}
			return $addons_array;
		} // End export_form

		/**
		 *	It is called when the form is imported to import the addons data too.
		 *  Receive an array with all the addons data, and the new form's id.
		 */
		public function import_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			if(isset($addons_array[$this->addonID]))
			{
				foreach($addons_array[$this->addonID] as $row)
				{
					if(!empty($row))
					{
						$row['formid'] = $formid;
						$wpdb->insert(
							$wpdb->prefix.$this->form_table,
							$row
						);
					}
				}
			}
		} // End import_form

    } // End Class

    // Main add-on code
    $CPAPPB_iDealMollie_obj = new CPAPPB_iDealMollie();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_iDealMollie_obj->get_addon_id() ] = $CPAPPB_iDealMollie_obj;
}


?>