<?php
/*
Third party plugin: https://wordpress.org/plugins/mycred/
Documentation: https://codex.mycred.me/chapter-v/playing-with-balances/
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_myCred' ) )
{
    class CPAPPB_myCred extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-myCred-20191205";
		protected $name = "myCred: Integration with myCred credit payments";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;

			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_myCred_id' ] )
			)
			{
			    // verify needed fields for update
                
                $this->add_field_verify("myCred_currencies", "TEXT");
                          			    
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
                                    
									'enabled'	 => $_REQUEST["myCred_enabled"],
                                    'myCred_optionlabel'	 => $_REQUEST["myCred_optionlabel"],
                                    'myCred_currencies'	 => $_REQUEST["myCred_currencies"],
								),
								array( '%d', '%s', '%s', '%s' )
							);          
			}


			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
           
			if (!count($rows))
			{
			    $row["enabled"] = "0";
                $row["myCred_optionlabel"] = __('Pay with credits', 'appointment-hour-booking');
                $row["myCred_currencies"] = '';
			} else {			   
			    $row["enabled"] = $rows[0]->enabled;
                $row["myCred_optionlabel"] = ( $rows[0]->myCred_optionlabel ? $rows[0]->myCred_optionlabel : __('Pay with credits', 'appointment-hour-booking') );
                $row["myCred_currencies"] = ( $rows[0]->myCred_currencies ? $rows[0]->myCred_currencies : '' );
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
<?php
            if (!function_exists('mycred'))
            {
                echo '<span style="color:red;font-weight:bold">'.__( 'The plugin myCred has not been detected. The myCred plugin is required for this credits payment addon.', 'appointment-hour-booking').'</span>';
            } 
?>
				   <input type="hidden" name="CPAPPB_myCred_id" value="1" />
                   <table class="form-table">
                    <tr valign="top">
                    <th scope="row"><?php _e('Enable myCred?', 'appointment-hour-booking'); ?></th>
                    <td><select name="myCred_enabled">
                         <option value="0" <?php if (!$row["enabled"]) echo 'selected'; ?>><?php _e('No', 'appointment-hour-booking'); ?></option>
<?php if (function_exists('mycred')) { ?>
                         <option value="1" <?php if ($row["enabled"]) echo 'selected'; ?>><?php _e('Yes', 'appointment-hour-booking'); ?></option>
                         <option value="2" <?php if ($row["enabled"] == '2') echo 'selected'; ?>><?php _e('Optional: This payment method + Pay Later (submit without payment)', 'appointment-hour-booking'); ?></option>
                         <option value="3" <?php if ($row["enabled"] == '3') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods (enabled)', 'appointment-hour-booking'); ?></option>
                         <option value="4" <?php if ($row["enabled"] == '4') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods  + Pay Later ', 'appointment-hour-booking'); ?></option>
<?php } ?>                         
                         </select>
                    </td>
                    </tr>          
                    <tr valign="top">
                    <th scope="row"><?php _e('Point types', 'appointment-hour-booking'); ?></th>
                    <td><textarea name="myCred_currencies" rows="4"><?php echo esc_attr($row["myCred_currencies"]); ?></textarea><br />
                    <em>* <?php echo __( 'Leave empty to use default point type for all. Otherwise enter the point type for each service in the calendar: first line is the point type of the first service, second line is the point type of the second service, etc... Sample point types (meta key): <strong>mycred_default</strong>, <strong>mycred_secondtype</strong>,...', 'appointment-hour-booking'); ?></em></td>
                    </tr>  
                    <tr valign="top">
                    <th scope="row"><?php _e('Option label', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="myCred_optionlabel" size="20" value="<?php echo esc_attr($row["myCred_optionlabel"]); ?>" /><br />
                    <em>* <?php echo __( 'Used if multiple payments are enabled.', 'appointment-hour-booking'); ?></em></td>
                    </tr>                      
                   </table>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_myCred';
        private $_inserted = false;
		private $_apphbmain;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			
			$this->description = __("The add-on adds support for <a href=\"https://wordpress.org/plugins/mycred/\" target=\"_blank\">myCred</a> payments", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
            
			add_action( 'cpappb_update_status', array( &$this, 'pp_update_status' ), 10, 2 );

            if (!is_admin())
            {
			    add_action( 'cpappb_process_data_before_insert', array( &$this, 'pp_myCred' ), 1, 1 );                
                
			    add_action( 'init', array( &$this, 'pp_myCred_check_price' ), 1 );
                
			    add_action( 'cpappb_script_after_validation', array( &$this, 'pp_payments_script' ), 10, 2 );
                
			    add_filter( 'cpappb_the_form', array( &$this, 'insert_payment_fields'), 99, 2 );
            }
			else
			{
				// Delete forms
				add_action( 'apphb_delete_form', array(&$this, 'delete_form') );

				// Clone forms
				add_action( 'apphb_clone_form', array(&$this, 'clone_form'), 10, 2 );

				// Export addon data
				add_action( 'apphb_export_addons', array(&$this, 'export_form'), 10, 2 );

				// Import addon data
				add_action( 'apphb_import_addons', array(&$this, 'import_form'), 10, 2 );
			}

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb, $cp_appb_plugin;
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
					enabled varchar(10) DEFAULT '0' NOT NULL ,
                    myCred_optionlabel varchar(255) DEFAULT '' NOT NULL ,
                    myCred_currencies TEXT,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
            $wpdb->query($sql);


		} // end update_database


		/************************ PUBLIC METHODS  *****************************/

		public function pp_update_status($itemnumber, $status)
		{
            global $wpdb, $cp_appb_plugin; 
            
            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $itemnumber) );
            
            $cp_appb_plugin->setId($myrows[0]->formid);

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $myrows[0]->formid )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return;
            
            if (!function_exists('mycred'))
            {
                return;
            }             
            
            if ( in_array($status,array('Cancelled','Cancelled by customer','Rejected')))
            {
                // give back credits
                // which type of credits
                
                $params = unserialize($myrows[0]->posted_data);
                
                $points = explode("\n",trim($rows[0]->myCred_currencies));
                $point_type = '';
                if (count($points))
                    $point_type = $points[0];
                
                
                $service_id = intval($params["apps"][0]["service"]);
                if ($service_id && isset($points[$service_id]))
                    $point_type = $points[$service_id];
                
                $mycred     = mycred( $point_type );
                $user_id = $myrows[0]->whoadded;
                $price = $params["final_price"];
               
                // Make sure user is not excluded
                if ( ! $mycred->exclude_user( $user_id ) ) {
                
                	// get users balance
                	$balance = $mycred->get_users_balance( $user_id );
                    
                	    // adjust a users balance
                	    $mycred->add_creds(           	   
                            'booking',
                	    	$user_id,
                	    	$price,
                	    	__( 'Points back from cancelled booking ID#', 'appointment-hour-booking') . $itemnumber
                         );
                }
                
            }
                             
        }



		/**
         * Inserts and Check if the Optional is enabled in the form, and inserts radiobutton
         */
        public function	insert_payment_fields( $form_code, $id )
		{
            global $wpdb, $cp_appb_plugin;

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return $form_code;


            $checkscript = '';                
			$code = '<div id="opfield'.$this->addonID.$id.'">'. 
                          '      <script>'.
                          '         var apphbmyCred_handler_paid= false;'.
                          '</script>'.          
                        '<input type="hidden" name="mycredtok" id="mycredtok'.($cp_appb_plugin->print_counter-1).'" value="" />'.
			        '</div>'.$checkscript;
            
			$form_code = preg_replace( '/<!--addons-payment-fields-->/i', '<!--addons-payment-fields-->'.$code, $form_code );

            $myCredlabel = $rows[0]->myCred_optionlabel;
            if (!$myCredlabel) 
                $myCredlabel = __('Pay with credits', 'appointment-hour-booking');
                
			// output radio-buttons here
			$form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" id="apphbaddonidtp'.$id.'" vt="'.$this->addonID.'" value="'.$this->addonID.'" checked> '.__($myCredlabel, 'appointment-hour-booking').'</div>', $form_code );

            if (($rows[0]->enabled == '2' || $rows[0]->enabled == '4') && !strpos($form_code,'bccf_payment_option_paypal" vt="0') )
			    $form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" vt="0" value="0"> '.__( $cp_appb_plugin->get_option('pay_later_label','Pay later',$id), 'appointment-hour-booking').'</div>', $form_code );

			if (substr_count ($form_code, 'name="bccf_payment_option_paypal"') > 1)
			    $form_code = str_replace( 'id="field-c0" style="display:none">', 'id="field-c0">', $form_code);

            return $form_code;
		} // End insert_payment_fields


		/**
         * process payment
         */
		public function pp_myCred(&$params)
		{
            global $wpdb, $cp_appb_plugin;

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID)
			    return;
            
            $amount = round($params["final_price"],0);
            if (!$amount)
                return;
            
            $token = $_POST['mycredtok'];
            
            if ($token != 'OK')
                return;

            $params["payment_type"] = $this->name;
            $params["paid"] = '1';            

		} // end pp_myCred


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}


        /**
         * script process payment
         */
		public function pp_myCred_check_price()
		{
            global $wpdb, $cp_appb_plugin;
            
                
            if (!isset($_POST["apphbmyCred_getprice"]) || !isset($_POST["formid"]))
                return;

            $form_id = intval($_POST["formid"]);

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return;
            
            $price = apply_filters( 'cpappb_calculate_price', $_POST["basecost"], $form_id );
            if ($_POST["coupon"]) 
                $price = apply_filters( 'cpappb_calculate_coupondiscount', $price, $_POST["coupon"], $form_id );
            

			$price = round($price,0); // credits should be an integer value

            if (!function_exists('mycred'))
            {
                echo __( 'The plugin myCred has not been detected. The myCred plugin is required for this credits payment addon.', 'appointment-hour-booking');
                exit;
            }                
            
            $points = explode("\n",trim($rows[0]->myCred_currencies));
            $point_type = '';
            if (count($points))
                $point_type = $points[0];
            
            $services =  explode(";",trim($_REQUEST["s"]));
            $service = explode(" ",trim($services[0]));
            $service_id = intval($service[2]);
            if ($service_id && isset($points[$service_id]))
                $point_type = $points[$service_id];
            
            $mycred     = mycred( $point_type );
            $user_id = get_current_user_id();
            
            // Make sure user is not excluded
            if ( ! $mycred->exclude_user( $user_id ) ) {
            
            	// get users balance
            	$balance = $mycred->get_users_balance( $user_id );
                
                if ($balance < $price)
                {
                    echo __( 'Insufficient number of credits available. ', 'appointment-hour-booking')."\n\n";
                    echo __( 'Available', 'appointment-hour-booking').": ".$balance."\n\n";
                    echo __( 'Needed', 'appointment-hour-booking').": ".$price;
                }
                else
                {
            	    // adjust a users balance
            	    $mycred->add_creds(           	   
                        'booking',
            	    	$user_id,
            	    	-$price,
            	    	__( 'Points used on booking.', 'appointment-hour-booking')
                     );
                    echo 'OK';
                }
            
            }         
            else
            {
                echo __( 'Used is excluded. Payment cannot be processed.', 'appointment-hour-booking');
            }    
            
			exit;

         }


		/**
         * script process payment
         */
		public function pp_payments_script( $form_sequence_id, $form_id )
		{
            global $wpdb, $cp_appb_plugin;

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return;

?>
            if (!apphbmyCred_handler_paid && $dexQuery("input[name='bccf_payment_option_paypal']:checked").val() == '<?php echo $this->addonID; ?>')
            {
                var charge_price = 0;
                var service_id = 0;
                try
                {
                    for(var kn=0; kn!=100; kn++)
                        if (document.getElementById("fieldname"+kn+"_"+<?php echo $cp_appb_plugin->print_counter; ?>))
                        {
                            charge_price += parseFloat(document.getElementById("tcostfieldname"+kn+"_<?php echo $cp_appb_plugin->print_counter; ?>").value);
                            service_id += document.getElementById("fieldname"+kn+"_<?php echo $cp_appb_plugin->print_counter; ?>").value+";";
                        }
                } 
                catch (e) { }
                if (charge_price > 0)
                {
                    var acccode = '';
                    try { acccode  = document.getElementById("couponcode_<?php echo $cp_appb_plugin->print_counter; ?>").value; } catch (e) {}
                    $dexQuery.ajax({
                        type: "POST",
                        url: '<?php echo $cp_appb_plugin->get_site_url(); ?>/',
                        data: "apphbmyCred_getprice=1&formid=<?php echo $form_id; ?>&basecost="+charge_price+"&coupon="+acccode+"&s="+service_id,
                        success: function(data)
                        {
                            if (data.trim() != 'OK')
                            {
                                alert(data);
                            }
                            else
                            {
                                apphbmyCred_handler_paid = true;
                                apphbblink_<?php echo $cp_appb_plugin->print_counter; ?>(".pbSubmit:visible");
                                $dexQuery=jQuery.noConflict();
                                $dexQuery(".pbSubmit:visible").off("click");
                                document.getElementById("mycredtok<?php echo $cp_appb_plugin->print_counter; ?>").value = 'OK';
                                document.getElementById("<?php echo $cp_appb_plugin->prefix; ?>_pform_<?php echo $cp_appb_plugin->print_counter; ?>").submit();
                            }
                        }
                    });                  
                    return false;
                }
            }
<?php
        }


        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL", $table = '')
        {
            global $wpdb, $cp_appb_plugin;
            if ($table == '')
                $table = $this->form_table;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }

		/**
		 *	Delete the form from the addon's table
		 */
        public function delete_form( $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$wpdb->delete( $wpdb->prefix.$this->form_table, array('formid' => $formid), '%d' );
		} // delete_form


   		/**
		 *	Clone the form's row
		 */
		public function clone_form( $original_form_id, $new_form_id )
		{
			global $wpdb, $cp_appb_plugin;

			$form_rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $original_form_id ), ARRAY_A);

			if(!empty($form_rows))
			{
				foreach($form_rows as $form_row)
				{
					unset($form_row["id"]);
					$form_row["formid"] = $new_form_id;
					$wpdb->insert( $wpdb->prefix.$this->form_table, $form_row);
				}
			}
		} // End clone_form
        

		/**
		 *	It is called when the form is exported to export the addons data too.
		 *  Receive an array with the other addons data, and the form's id for filtering.
		 */
		public function export_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ), ARRAY_A );
			if(!empty($rows))
			{
				$addons_array[ $this->addonID ] = array();
				foreach($rows as $row)
				{
					unset($row['id']);
					unset($row['formid']);
					$addons_array[ $this->addonID ][] = $row;
				}
			}
			return $addons_array;
		} // End export_form


		/**
		 *	It is called when the form is imported to import the addons data too.
		 *  Receive an array with all the addons data, and the new form's id.
		 */
		public function import_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			if(isset($addons_array[$this->addonID]))
			{
				foreach($addons_array[$this->addonID] as $row)
				{
					if(!empty($row))
					{
						$row['formid'] = $formid;
						$wpdb->insert(
							$wpdb->prefix.$this->form_table,
							$row
						);
					}
				}
			}
		} // End import_form


    } // End Class

    // Main add-on code
    $CPAPPB_myCred_obj = new CPAPPB_myCred();

    global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_myCred_obj->get_addon_id() ] = $CPAPPB_myCred_obj;
}
?>