<?php
/*
Documentation: https://apphourbooking.dwbooster.com/documentation
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_Passwordaddon' ) )
{
    class CPAPPB_Passwordaddon extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-Passwordaddon-20151212";
		protected $name = "Password for making bookings";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
           <div id="cpabc_passwd_nocodes_availmsg">Loading...</div>
          
           <br />               
           <strong>Add new password:</strong>
           <br />
           <table border="0" cellpadding="0" cellspacing="0" style="margin-top:5px;">
            <tr>
             <td style="padding:0px;">Password:</td>
             <td style="padding:0px;">Can be used:</td>
             <td style="padding:0px;">Valid until:</td>             
             <td style="padding:0px;"></td>
            </tr> 
            <tr>
             <td style="padding:0px;" nowrap><input type="text" name="cpabc_dc_codepw" id="cpabc_dc_codepw" size="4" value="" /></td>       
             <td style="padding:0px;" nowrap><select name="dex_dc_times" id="dex_dc_times">
                   <option value="0">Unlimited</option>
                   <?php for ($i=1;$i<20;$i++) { ?><option value="<?php echo $i; ?>"><?php echo $i; ?> times</option><?php } ?>
                   <?php for ($i=20;$i<50;$i+=5) { ?><option value="<?php echo $i; ?>"><?php echo $i; ?> times</option><?php } ?>
                   <?php for ($i=50;$i<500;$i+=10) { ?><option value="<?php echo $i; ?>"><?php echo $i; ?> times</option><?php } ?>
                   <?php for ($i=500;$i<10000;$i+=50) { ?><option value="<?php echo $i; ?>"><?php echo $i; ?></option><?php } ?>
                 </select></td>
             <td style="padding:0px;" nowrap><input type="text"  size="10" name="cpabc_dc_expires" id="cpabc_dc_expires" value="" /></td>             
             <td style="padding:0px;"><input type="button" name="cpabc_passwd_dc_subccode" id="cpabc_passwd_dc_subccode" value="Add" /></td>
            </tr>             
           </table>   
           <em>Note: Expiration date based in server time. Server time now is <?php echo date("Y-m-d H:i"); ?></em>
<script type="text/javascript">
 var $j = jQuery.noConflict();
 $j(function() {
 	$j("#cpabc_dc_expires").datepicker({     	                
                    dateFormat: 'yy-mm-dd'
                 }); 	
 });
 $j('#cpabc_passwd_nocodes_availmsg').load('<?php echo $cp_appb_plugin->get_site_url(true); ?>/?apphbPasswordaddon=1&inAdmin=1&item=<?php echo $form_id; ?>');
 $j('#cpabc_passwd_dc_subccode').click (function() {
                               var code = $j('#cpabc_dc_codepw').val();
                               var expires = $j('#cpabc_dc_expires').val();
                               var dc_times = $j('#dex_dc_times').val();          
                               if (code == '') { alert('Please enter a code'); return; }                               
                               if (expires == '') { alert('Please enter an expiration date for the code'); return; }
                               var params = '&add=1&expires='+encodeURI(expires)+'&code='+encodeURI(code)+'&tm='+encodeURI(dc_times);                               
                               $j('#cpabc_passwd_nocodes_availmsg').load('<?php echo $cp_appb_plugin->get_site_url(true); ?>/?apphbPasswordaddon=1&inAdmin=1&item=<?php echo $form_id; ?>'+params);
                               $j('#cpabc_dc_codepw').val();
                             });
                             
  function cpabc_delete_password(id)                             
  {
     $j('#cpabc_passwd_nocodes_availmsg').load('<?php echo $cp_appb_plugin->get_site_url(true); ?>/?apphbPasswordaddon=1&inAdmin=1&item=<?php echo $form_id; ?>&delete=1&code='+id);
  }
</script>  
                   </div>
                 </div>  
<?php

		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_Passwordaddon';
        private $form_table_plans = 'cpappbk_Passwordaddonplans';
        private $form_table_customers = 'cpappbk_Passwordaddoncustomers';
        private $_inserted = false;
		private $_apphbmain;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			
			$this->description = __("The add-on is for requiring a password to make a booking.", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            add_action( 'init', array( &$this, 'pp_Passwordaddon_process_admin' ), 1 );

            if( !is_admin() )
            {
                
			    add_action( 'cpappb_process_data_before_insert', array( &$this, 'pp_Passwordaddon' ), 1, 1 );            

			    add_action( 'cpappb_script_after_validation', array( &$this, 'validate_form_script' ), 10, 2 );

			    add_filter( 'cpappb_the_form', array( &$this, 'insert_payment_fields'), 99, 2 );           
            }

			if( is_admin() )
			{
				// Delete forms
				add_action( 'apphb_delete_form', array(&$this, 'delete_form') );

				// Clone forms
				add_action( 'apphb_clone_form', array(&$this, 'clone_form'), 10, 2 );

				// Export addon data
				add_action( 'apphb_export_addons', array(&$this, 'export_form'), 10, 2 );

				// Import addon data
				add_action( 'apphb_import_addons', array(&$this, 'import_form'), 10, 2 );
			}

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb, $cp_appb_plugin;
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
                    cal_id mediumint(9) NOT NULL DEFAULT 1,
                    code VARCHAR(250) DEFAULT '' NOT NULL,
                    expires datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
                    dc_times varchar(10) DEFAULT '0' NOT NULL,
                    availability int(10) unsigned NOT NULL DEFAULT 0,
                    used int(10) unsigned NOT NULL DEFAULT 0,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
            $wpdb->query($sql);

		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
         * Inserts banks and Check if the Optional is enabled in the form, and inserts radiobutton
         */
        public function	insert_payment_fields( $form_code, $id )
		{
            global $wpdb, $cp_appb_plugin;

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE cal_id=%d", $id )
					);

			if (empty( $rows ))
			    return $form_code;
            
            $buffer = '<div class="fields" id="field-c0">'.
                      '   <label>'.__('Password','appointment-hour-booking').'</label>'.
                      '   <div class="dfield">'.
                      '     <input type="password" name="passcode" id="passcode_'.($cp_appb_plugin->print_counter-1).'" value="">'.
                      '   </div>'.
                      '   <div class="clearer"></div>'.
                      '</div>';           
     
            return str_replace( '<!--addons-payment-fields-->', $buffer.'<!--addons-payment-fields-->', $form_code );

            return $form_code;
		} // End insert_payment_fields


		/**
         * process payment
         */
		public function pp_Passwordaddon(&$params)
		{
            global $wpdb, $cp_appb_plugin;
            
            $codes = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE ((dc_times>used) OR dc_times='0') AND code='".esc_sql(@$_POST["passcode"])."' AND expires>='".date("Y-m-d")." 00:00:00' AND `cal_id`=".$params["formid"]);
            if (count($codes))  // calculation partially duplicated in the function pp_Passwordaddon_calculate_action
            {
                $coupon = $codes[0];                
                $params["password"] = $coupon->code;                
                $wpdb->query("UPDATE ".$wpdb->prefix.$this->form_table." SET used=used+1 WHERE id=".intval($codes[0]->id));
            }                

		} // end pp_Passwordaddon
        
            

		/**
         * Insert the JS code into the doValidate function for checking the reCAPTCHA code with AJAX
         */ 
        public function validate_form_script( $sequence, $formid )
		{
		    global $wpdb, $cp_appb_plugin;
            
			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE cal_id=%d", $formid )
					);
            if (empty( $rows ))
                return;
					
			
		?>
			var ahbpassword = $dexQuery( "#passcode_<?php print $sequence; ?>" );
            console.log(ahbpassword);
			if( 
				ahbpassword.length == 0 ||
				/^\s*$/.test( ahbpassword.val() )
			)
			{
				alert('<?php echo( _e('Please enter a valid password.','appointment-hour-booking') ); ?>');
				return false;
			}
			else
			{
				var result = $dexQuery.ajax({
					type: "GET",
					url:  "<?php echo $cp_appb_plugin->fixurl($cp_appb_plugin->get_site_url(),'ahbpasscheck=1'); ?>",
					data: {
						ps: "<?php echo $sequence; ?>",
						ahbpassword_response: ahbpassword.val(),
                        ahbformid: <?php echo intval($formid); ?>,
					},
					async: false
				}).responseText;
				if (result.indexOf("passfailed") != -1)
				{
					alert('<?php echo( _e('Please enter a valid password.','appointment-hour-booking') ); ?>');
					return false;
				}	
			}	
		<?php
			
		} // End validate_form_script
        
		/**
		 * logs
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}


        /**
         * script process
         */
		public function pp_Passwordaddon_process_admin()
		{
            global $wpdb, $cp_appb_plugin;
            
            if (isset($_REQUEST["ahbpassword_response"]) && isset($_REQUEST["ahbformid"]))
            {
                $codes = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE ((dc_times>used) OR dc_times='0') AND code='".esc_sql(@$_REQUEST["ahbpassword_response"])."' AND expires>='".date("Y-m-d")." 00:00:00' AND `cal_id`=".intval($_REQUEST["ahbformid"]));
				if( count($codes) )
				{
					print 'ok';
				}	
				else
				{
					print 'passfailed';
				}	
				exit;                
            }
            
            $form_id = intval($_GET["item"]);

            if (!isset($_GET["apphbPasswordaddon"]) || !isset($_GET["item"]) || !is_admin() || !$cp_appb_plugin->check_current_user_access($form_id))
                return;
	       
            if (isset($_GET["add"]) && $_GET["add"] == "1")
                $wpdb->insert( $wpdb->prefix.$this->form_table, array(   'cal_id' => $form_id,
                                                                         'code' => $_GET["code"],
                                                                         'dc_times' => $_GET["tm"],
                                                                         'expires' => $_GET["expires"],
                                                                      ));
            if (isset($_GET["delete"]) && $_GET["delete"] == "1")
                $wpdb->query( $wpdb->prepare( "DELETE FROM ".$wpdb->prefix.$this->form_table." WHERE id = %d", $_GET["code"] ));
            
            $codes = $wpdb->get_results( 'SELECT * FROM '.$wpdb->prefix.$this->form_table.' WHERE `cal_id`='.$form_id);
            if (count ($codes))
            {
                echo '<table cellpadding="5">';
                echo '<tr>';
                echo '  <th style="background-color: #cccccc;">Password</th>';
                echo '  <th style="background-color: #cccccc;" nowrap>Can be used?</th>';
                echo '  <th style="background-color: #cccccc;" nowrap>Used so far</th>';
                echo '  <th style="background-color: #cccccc;">Valid until</th>';
                echo '  <th style="background-color: #cccccc;">Options</th>';
                echo '</tr>';
                foreach ($codes as $value)
                {
                   echo '<tr>';
                   echo '<td>'.$value->code.'</td>';
                   echo '<td nowrap>'.($value->dc_times=='0'?'Unlimited':$value->dc_times.' times').'</td>';
                   echo '<td nowrap>'.$value->used.' times</td>';
                   echo '<td>'.substr($value->expires,0,10).'</td>';
                   echo '<td>[<a href="javascript:cpabc_delete_password('.$value->id.')">Delete</a>]</td>';
                   echo '</tr>';
                }
                echo '</table>';
            }
            else
                echo 'No passwords listed for this calendar yet.';
    
			exit;

         }


        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL", $table = '')
        {
            global $wpdb, $cp_appb_plugin;
            if ($table == '')
                $table = $this->form_table;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }

		/**
		 *	Delete the form from the addon's table
		 */
        public function delete_form( $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$wpdb->delete( $wpdb->prefix.$this->form_table, array('formid' => $formid), '%d' );
		} // delete_form

        		/**
		 *	Clone the form's row
		 */
		public function clone_form( $original_form_id, $new_form_id )
		{
			global $wpdb, $cp_appb_plugin;

			$form_rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $original_form_id ), ARRAY_A);

			if(!empty($form_rows))
			{
				foreach($form_rows as $form_row)
				{
					unset($form_row["id"]);
					$form_row["formid"] = $new_form_id;
					$wpdb->insert( $wpdb->prefix.$this->form_table, $form_row);
				}
			}
		} // End clone_form

		/**
		 *	It is called when the form is exported to export the addons data too.
		 *  Receive an array with the other addons data, and the form's id for filtering.
		 */
		public function export_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ), ARRAY_A );
			if(!empty($rows))
			{
				$addons_array[ $this->addonID ] = array();
				foreach($rows as $row)
				{
					unset($row['id']);
					unset($row['formid']);
					$addons_array[ $this->addonID ][] = $row;
				}
			}
			return $addons_array;
		} // End export_form

		/**
		 *	It is called when the form is imported to import the addons data too.
		 *  Receive an array with all the addons data, and the new form's id.
		 */
		public function import_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			if(isset($addons_array[$this->addonID]))
			{
				foreach($addons_array[$this->addonID] as $row)
				{
					if(!empty($row))
					{
						$row['formid'] = $formid;
						$wpdb->insert(
							$wpdb->prefix.$this->form_table,
							$row
						);
					}
				}
			}
		} // End import_form


    } // End Class

    // Main add-on code
    $CPAPPB_Passwordaddon_obj = new CPAPPB_Passwordaddon();

    global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_Passwordaddon_obj->get_addon_id() ] = $CPAPPB_Passwordaddon_obj;
}
?>