<?php
/*

*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_PayPalStandard' ) )
{
    class CPAPPB_PayPalStandard extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-PayPalStandard-20170903";
		protected $name = "PayPal Standard Payments Integration";
		protected $description;
        protected $default_label = 'Pay with PayPal';

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_paypalstandard_id' ] )
			)
			{
                $this->add_field_verify("paypal_optionlabel");
                $this->add_field_verify("tax");
                $this->add_field_verify("lockedperiod");
                
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,

									'PayPalStandard_api_username'	 => $_REQUEST["PayPalStandard_api_username"],									
									'x_cancel_url'	 => $_REQUEST["PayPalStandard_cancel_url"],
									'currency'	 => $_REQUEST["PayPalStandard_currency"],
                                    'mode'	 => $_REQUEST["PayPalStandard_mode"],
                                    'language'	 => $_REQUEST["PayPalStandard_language"],
                                    'paypal_optionlabel'	 => $_REQUEST["paypal_optionlabel"],
                                    'tax'	 => $_REQUEST["PayPalStandard_tax"],
                                    'lockedperiod'	 => $_REQUEST["PayPalStandard_lockedperiod"],
									'enabled'	 => $_REQUEST["PayPalStandard_enabled"]

								),
								array( '%d', '%s', '%s', '%s', 
								             '%s', '%s', '%s',
                                             '%s', '%s', '%s'
								              )
							);
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["PayPalStandard_api_username"] = "";
			    $row["enabled"] = "0";
                $row["x_cancel_url"] = '';
                $row["currency"] = 'USD';
                $row["language"] = 'EN';
                $row["paypal_optionlabel"] = $this->default_label;
                $row["tax"] = 0;
                $row["lockedperiod"] = 0;
                $row["mode"] = '1';
			} else {
			    $row["enabled"] = $rows[0]->enabled;
			    $row["PayPalStandard_api_username"] = $rows[0]->PayPalStandard_api_username;
                $row["x_cancel_url"] = $rows[0]->x_cancel_url;
                $row["currency"] = $rows[0]->currency;
                $row["language"] = $rows[0]->language;
                $row["tax"] = $rows[0]->tax;
                $row["lockedperiod"] = $rows[0]->lockedperiod;
                $row["paypal_optionlabel"] = ( $rows[0]->paypal_optionlabel ? $rows[0]->paypal_optionlabel : __($this->default_label, 'appointment-hour-booking') );
                $row["mode"] = $rows[0]->mode;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_paypalstandard_id" value="1" />
                   <table class="form-table">
                    <tr valign="top">
                    <th scope="row"><?php _e('Enable PayPal Standard Payments?', 'appointment-hour-booking'); ?></th>
                    <td><select name="PayPalStandard_enabled">
                         <option value="0" <?php if (!$row["enabled"]) echo 'selected'; ?>><?php _e('No', 'appointment-hour-booking'); ?></option>
                         <option value="1" <?php if ($row["enabled"] == '1') echo 'selected'; ?>><?php _e('Yes', 'appointment-hour-booking'); ?></option>
                         <option value="2" <?php if ($row["enabled"] == '2') echo 'selected'; ?>><?php _e('Optional: This payment method + Pay Later (submit without payment)', 'appointment-hour-booking'); ?></option>
                         <option value="3" <?php if ($row["enabled"] == '3') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods (enabled)', 'appointment-hour-booking'); ?></option>
                         <option value="4" <?php if ($row["enabled"] == '4') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods  + Pay Later ', 'appointment-hour-booking'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('PayPal Standard Email', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="PayPalStandard_api_username" size="40" value="<?php echo esc_attr($row["PayPalStandard_api_username"]); ?>" /><br />
                    </tr>

                    <tr valign="top">
                    <th scope="row"><?php _e('Cancel URL:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="PayPalStandard_cancel_url" size="70" value="<?php echo esc_attr(@$row["x_cancel_url"]); ?>" /><br />
                        <em>User will return here if payment fails.</em>
                        </td>
                    </tr>
                   <tr valign="top">        
                    <th scope="row"><?php _e('Currency:', 'appointment-hour-booking'); ?></th>
                    <td>
                     <?php $currency = @$row["currency"]; ?>
                     <select name="PayPalStandard_currency">
                     <option value="USD"<?php if ($currency == 'USD' || $currency == '') echo ' selected'; ?>>USD - U.S. Dollar</option>
                     <option value="EUR"<?php if ($currency == 'EUR') echo ' selected'; ?>>EUR - Euro</option>
                     <option value="GBP"<?php if ($currency == 'GBP') echo ' selected'; ?>>GBP - Pound Sterling</option>
                     <option value="USD"> - </option>
                     <option value="ARS"<?php if ($currency == 'ARS') echo ' selected'; ?>>ARS - Argentine peso</option>
                     <option value="AUD"<?php if ($currency == 'AUD') echo ' selected'; ?>>AUD - Australian Dollar</option>
                     <option value="BRL"<?php if ($currency == 'BRL') echo ' selected'; ?>>BRL - Brazilian Real</option>
                     <option value="CAD"<?php if ($currency == 'CAD') echo ' selected'; ?>>CAD - Canadian Dollar</option>
                     <option value="CZK"<?php if ($currency == 'CZK') echo ' selected'; ?>>CZK - Czech Koruna</option>
                     <option value="DKK"<?php if ($currency == 'DKK') echo ' selected'; ?>>DKK - Danish Krone</option>
                     <option value="HKD"<?php if ($currency == 'HKD') echo ' selected'; ?>>HKD - Hong Kong Dollar</option>
                     <option value="HUF"<?php if ($currency == 'HUF') echo ' selected'; ?>>HUF - Hungarian Forint</option>
                     <option value="ILS"<?php if ($currency == 'ILS') echo ' selected'; ?>>ILS - Israeli New Sheqel</option>
                     <option value="INR"<?php if ($currency == 'INR') echo ' selected'; ?>>INR - Indian Rupee</option>
                     <option value="JPY"<?php if ($currency == 'JPY') echo ' selected'; ?>>JPY - Japanese Yen</option>
                     <option value="MYR"<?php if ($currency == 'MYR') echo ' selected'; ?>>MYR - Malaysian Ringgit</option>
                     <option value="MXN"<?php if ($currency == 'MXN') echo ' selected'; ?>>MXN - Mexican Peso</option>	
                     <option value="NOK"<?php if ($currency == 'NOK') echo ' selected'; ?>>NOK - Norwegian Krone</option>	
                     <option value="NZD"<?php if ($currency == 'NZD') echo ' selected'; ?>>NZD - New Zealand Dollar</option>	
                     <option value="PHP"<?php if ($currency == 'PHP') echo ' selected'; ?>>PHP - Philippine Peso</option>	
                     <option value="PLN"<?php if ($currency == 'PLN') echo ' selected'; ?>>PLN - Polish Zloty</option>		
                     <option value="RUB"<?php if ($currency == 'RUB') echo ' selected'; ?>>RUB - Russian Ruble</option>
                     <option value="SGD"<?php if ($currency == 'SGD') echo ' selected'; ?>>SGD - Singapore Dollar</option>	
                     <option value="SEK"<?php if ($currency == 'SEK') echo ' selected'; ?>>SEK - Swedish Krona</option>
                     <option value="CHF"<?php if ($currency == 'CHF') echo ' selected'; ?>>CHF - Swiss Franc</option>
                     <option value="TWD"<?php if ($currency == 'TWD') echo ' selected'; ?>>TWD - Taiwan New Dollar</option>
                     <option value="THB"<?php if ($currency == 'THB') echo ' selected'; ?>>THB - Thai Baht</option>
                     </select>
                    </td>
                    </tr>   
                    <tr valign="top">
                    <th scope="row"><?php _e('Paypal language', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="PayPalStandard_language" value="<?php echo esc_attr($row["language"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Paypal tax', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="PayPalStandard_tax" value="<?php echo esc_attr($row["tax"]); ?>" /><br />
                     <em> * Applied only into the PayPal payment page.</em></td>
                    </tr>     
                    <tr valign="top">
                    <th scope="row"><?php _e('Time-slot locked period', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="PayPalStandard_lockedperiod" value="<?php echo esc_attr($row["lockedperiod"]); ?>" /><br />
                     <em> * Optional: Number of minutes the time-slot will be kept blocked waiting for the payment completion. Keep this field in 0 if you are not sure or don't want to use this feature.</em></td>
                    </tr>                     
                    <tr valign="top">        
                    <th scope="row"><?php _e('Paypal Mode', 'appointment-hour-booking'); ?></th>
                    <td><select name="PayPalStandard_mode">
                         <option value="1" <?php if ($row["mode"] != '0') echo 'selected'; ?>>Production - real payments processed</option> 
                         <option value="0" <?php if ($row["mode"] == '0') echo 'selected'; ?>>SandBox - PayPal testing sandbox area</option> 
                        </select>
                        <br />
                       <em> * Note that if you are testing it in a <strong>localhost</strong> site the PayPal IPN notification won't reach to your website and the appointment won't be processed.</em>
                    </td>
                    </tr>     
                  <tr valign="top">
                    <th scope="row"><?php _e('Option label', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="paypal_optionlabel" size="20" value="<?php echo esc_attr($row["paypal_optionlabel"]); ?>" /><br />
                    <em>* Used if multiple payments are enabled</em></td>
                    </tr> 
                   </table>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_paypalstandard';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on adds support for PayPal Standard payments", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            if (!is_admin())
            {
			    add_action( 'cpappb_process_data', array( &$this, 'pp_PayPalStandard' ), 11, 1 );

			    add_action( 'init', array( &$this, 'pp_PayPalStandard_update_status' ), 10, 1 );

			    add_filter( 'cpappb_the_form', array( &$this, 'insert_payment_fields'), 99, 2 );
            }
            
            add_filter( 'cpappb_the_availability_field', array( &$this, 'availability_field'), 99, 2 );
            
            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
					enabled varchar(10) DEFAULT '0' NOT NULL ,
					PayPalStandard_api_username varchar(255) DEFAULT '' NOT NULL ,
					x_cancel_url varchar(255) DEFAULT '' NOT NULL ,
                    mode varchar(255) DEFAULT '' NOT NULL ,
                    language varchar(255) DEFAULT '' NOT NULL ,
					currency varchar(255) DEFAULT '' NOT NULL ,
					enable_option_yes varchar(255) DEFAULT '' NOT NULL ,
                    enable_option_no varchar(255) DEFAULT '' NOT NULL ,
                    enable_option_paypal varchar(255) DEFAULT '' NOT NULL ,
                    paypal_optionlabel varchar(255) DEFAULT '' NOT NULL ,
                    tax varchar(255) DEFAULT '' NOT NULL ,
					UNIQUE KEY id (id)
				) $charset_collate;";

			$wpdb->query($sql);
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/

		/**
         * Check if the Optional is enabled in the form, and inserts radiobutton
         */
        public function	insert_payment_fields( $form_code, $id )
		{
            global $wpdb, $cp_appb_plugin;
            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $id )
					);

			if (empty( $rows ) || $rows[0]->enabled == '0')
			    return $form_code;


            $pplabel = $rows[0]->paypal_optionlabel;
            if (!$pplabel) 
                $pplabel = __($this->default_label, 'appointment-hour-booking');
            
			// output radio-buttons here
			$form_code = preg_replace( '/<!--addons-payment-options-->/i', '<div><input type="radio" name="bccf_payment_option_paypal" vt="'.$this->addonID.'" value="'.$this->addonID.'" checked> '.$pplabel.'</div><!--addons-payment-options-->', $form_code );

            if (($rows[0]->enabled == '2' || $rows[0]->enabled == '4') && !strpos($form_code,'bccf_payment_option_paypal" vt="0') )
			    $form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" vt="0" value="0"> '.__( $cp_appb_plugin->get_option('pay_later_label','Pay later',$id), 'appointment-hour-booking').'</div>', $form_code );

			if (substr_count ($form_code, 'name="bccf_payment_option_paypal"') > 1)
			    $form_code = str_replace( 'id="field-c0" style="display:none">', 'id="field-c0">', $form_code);

            return $form_code;
        }

		/**
         * remove lockouts
         */
        public function	availability_field( $field_filter, $id )
		{
            global $wpdb, $cp_appb_plugin;

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $id )
					);
            
            $locked = intval($rows[0]->lockedperiod);
            if (!$rows[0]->enabled || !$locked)
                return;
            $last_updated = get_option('AHB_PAYPAL_LOCKOUT_ID', 0);
            $org_booking_rows = $wpdb->get_results( "SELECT id,posted_data FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id>".$last_updated." AND time<='".date("Y-m-d H:i:s",strtotime(current_time('mysql')." -".$locked." minutes"))."' AND formid=".intval($id) ); 

            foreach ($org_booking_rows as $org_booking_row)
            {
                $params = unserialize($org_booking_row->posted_data);
                if (isset($params["lock"]))
                {
                    unset($params["lock"]);
                    update_option('AHB_PAYPAL_LOCKOUT_ID', $org_booking_row->id);
                    $wpdb->update($wpdb->prefix.$cp_appb_plugin->table_messages, array('posted_data' => serialize($params) ),
                                                                                       array (
                                                                                        'id' => intval($org_booking_row->id)
                                                                                       ) );
                }
            }
            
            return $field_filter;
            
		} // end availability_filter 


		/**
         * process payment
         */
		public function pp_PayPalStandard(&$params)
		{
            global $wpdb, $cp_appb_plugin;

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

            $pro_item_name = $cp_appb_plugin->get_option('product_name', 'Booking');
            foreach ($params as $item => $value)
                $pro_item_name = str_replace('<%'.$item.'%>',(is_array($value)?(implode(", ",$value)):($value)),$pro_item_name);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);

            $final_price = $params["final_price"];
            if (isset($params["oldprice"]) && floatval($params["oldprice"]))
            {
                $final_price = floatval($final_price) - floatval($params["oldprice"]);
                if ($final_price < 0)
                    $final_price = 0;
            }
            
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID || floatval($final_price) == 0)
            {
                if (!empty( $rows ) && $rows[0]->enabled && $payment_option == $this->addonID && floatval($final_price) == 0)
                {
                    $cp_appb_plugin->update_status($params["itemnumber"], $cp_appb_plugin->get_option('defaultpaidstatus', '') );
                    $countapps = count($params["apps"]);
                    for($k=0; $k<$countapps; $k++)
                    {
                         $params["apps"][$k]["cancelled"] = $cp_appb_plugin->get_option('defaultpaidstatus', '');         
                         $params["app_status_".($k+1)] = $cp_appb_plugin->get_option('defaultpaidstatus', '');         
                    }                    
                }
			    return;
            }
            
            $apply_lockout = intval($rows[0]->lockedperiod);
      
            if ($apply_lockout)
                $params["lock"] = time();   

            $wpdb->update($wpdb->prefix.$cp_appb_plugin->table_messages, array('posted_data' => serialize($params) ),
                                                                                       array (
                                                                                        'id' => intval($params[ 'itemnumber' ])
                                                                                       ) );            
            
            $sequence = $params["itemnumber"];
            $timestamp = time();

            if ($rows[0]->mode == '0')
               $ppurl = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
            else
               $ppurl = 'https://www.paypal.com/cgi-bin/webscr';
?>
        <html>
        <head><title>Redirecting to PayPal Standard...</title></head>
        <body>
<form action="<?php echo $ppurl; ?>" name="ppform3" method="post">
<input type="hidden" name="cmd" value="_xclick" />
<input type="hidden" name="business" value="<?php echo $rows[0]->PayPalStandard_api_username; ?>" />
<input type="hidden" name="item_name" value="<?php echo $pro_item_name; ?>" />
<input type="hidden" name="amount" value="<?php echo $final_price; ?>" />
<input type="hidden" name="page_style" value="Primary" />
<input type="hidden" name="no_shipping" value="1" />
<input type="hidden" name="tax_rate" value="<?php echo floatval($rows[0]->tax); ?>" />
<input type="hidden" name="return" value="<?php echo $cp_appb_plugin->replace_tags_base64( $cp_appb_plugin->get_option('fp_return_page', $cp_appb_plugin->get_site_url()), $params, true); ?>">
<input type="hidden" name="cancel_return" value="<?php echo $rows[0]->x_cancel_url; ?>" />
<input type="hidden" name="currency_code" value="<?php echo $rows[0]->currency; ?>" />
<input type="hidden" name="lc" value="<?php echo $rows[0]->language; ?>" />
<input type="hidden" name="bn" value="NetFactorSL_SI_Custom" />
<input type="hidden" name="notify_url" value="<?php echo $cp_appb_plugin->get_site_url().'/?cp_appbpaypalstandard_ipncheck='.$params[ 'itemnumber' ]; ?>" />
<input class="pbutton" type="hidden" value="Buy Now" /></div>
</form>
<script type="text/javascript">
document.ppform3.submit();
</script>
        </body>
        </html>
<?php



            exit;
		} // end pp_PayPalStandard



        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL", $table = '')
        {
            global $wpdb, $cp_appb_plugin;
            if ($table == '')
                $table = $this->form_table;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }
        
        
		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}

		public function pp_PayPalStandard_update_status( )
		{
            global $wpdb, $cp_appb_plugin;


            if (!isset($_GET["cp_appbpaypalstandard_ipncheck"]) || !intval($_GET["cp_appbpaypalstandard_ipncheck"]))
                return;
            
            $itemnumber = intval($_GET["cp_appbpaypalstandard_ipncheck"]);   
            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $itemnumber) );

			if (empty( $myrows ))
			    return;

            
            $payer_email = $_POST['payer_email'];
            $payment_status = $_POST['payment_status'];

         	if  ( 
                  ($payment_status != 'Completed' && $payment_type != 'echeck') || 
                  ($payment_type == 'echeck' && $payment_status == 'Completed')
                )
            {
				if (strtolower($payment_status) == 'refunded')
				{
					 $params = unserialize($myrows[0]->posted_data);
					 $params["paid"] = '1';
                     $params["payment_type"] = "REFUNDED! (from PayPal)";                   
                     $wpdb->query( $wpdb->prepare("UPDATE  ".$wpdb->prefix.$cp_appb_plugin->table_messages." SET posted_data=%s WHERE id=%d", serialize($params), $itemnumber) );
					$cp_appb_plugin->update_status($itemnumber, 'Cancelled' );
				}                
                echo 'Transaction failed.';
                exit();
            }
            
            $params = unserialize($myrows[0]->posted_data);
            $params["paid"] = '1';
            $params["payment_type"] = "PayPal Standard";
            $params["payment_email"] = $payer_email;
            $wpdb->query( $wpdb->prepare("UPDATE  ".$wpdb->prefix.$cp_appb_plugin->table_messages." SET posted_data=%s WHERE id=%d", serialize($params), $itemnumber) );
            $cp_appb_plugin->update_status($itemnumber, $cp_appb_plugin->get_option('defaultpaidstatus', '') );
            
            //if (!count($myrows))
            $cp_appb_plugin->ready_to_go_reservation($itemnumber, "", $params);         

            echo 'OK';
            exit ();

		}


    } // End Class

    // Main add-on code
    $cpappb_PayPalStandard_obj = new CPAPPB_PayPalStandard();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $cpappb_PayPalStandard_obj->get_addon_id() ] = $cpappb_PayPalStandard_obj;
}

