<?php
/*
    Appointment Limits Addon
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_QRCode' ) )
{
    class CPAPPB_QRCode extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-QRCode-20180607";
		protected $name = "QRCode Image - Barcode";
		protected $description;
        

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_QRCode_id' ] )
			)
			{
                $this->add_field_verify('QRCode_attendedlink', 'INT NOT NULL');
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									'QRCode_enable'	 => $_REQUEST["QRCode_enable"],
                                    'QRCode_attendedlink' => $_REQUEST["QRCode_attendedlink"],
                                    'qrcode_size'	 => $_REQUEST["qrcode_size"],
                                    'qrcode_content'	 => $_REQUEST["qrcode_content"]
								),
								array( '%d', '%d', '%d', '%s', '%s' )
							);          
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["QRCode_enable"] = 0;
                $row["QRCode_attendedlink"] = 0;
			    $row["qrcode_size"] = 400;
                $row["qrcode_content"] = '%itemnumber%';
			} else {
			    $row["QRCode_enable"] = $rows[0]->QRCode_enable;
                $row["QRCode_attendedlink"] = $rows[0]->QRCode_attendedlink;
			    $row["qrcode_size"] = $rows[0]->qrcode_size;
                $row["qrcode_content"] = $rows[0]->qrcode_content;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_QRCode_id" value="1" />
                     Enable QRCodes this calendar?:<br />
                        <?php $option = $row['QRCode_enable']; ?>
                        <select name="QRCode_enable" id="QRCode_enable" onchange="ahbqrcode_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
                   
                   <div id="QRCodecontent_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                         <br /><strong>Note:</strong> QRCodes will be sent attached to the notification emails.  The tag <span style="color:red;font-weight:bold;">%qrcode%</span> can be added to the emails to include a link to the QRCode image.
                         <br /><br />
                         <strong>QRCode size in pixels:</strong><br />
                         <input type="text" size="10" name="qrcode_size" value="<?php echo esc_attr( intval($row["qrcode_size"])); ?>" /> 
                         <br /><br />
                         
                        Will the QRCode point to a link to mark the booking as attended?:<br />
                        <?php $option = $row['QRCode_attendedlink']; ?>
                        <select name="QRCode_attendedlink" id="QRCode_attendedlink" onchange="ahbqrcode_display_option_qrcodelink(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
                         
                         <div id="QRCodecontent_yeslink" <?php if (intval($option) == 1) echo ' style="display:none"'; ?>>
                             <br /><strong>QRCode contents:</strong><br />
                             <input type="text" size="80" name="qrcode_content" value="<?php echo esc_attr( ($row["qrcode_content"])); ?>" /> 
                             <br />                          
                             <em>Check the <a href="https://apphourbooking.dwbooster.com/faq#q81" target="_blank">list of tags available for the contents</a>.</em>
                         </div>
                   </div>
                   <script type="text/javascript">
                       function ahbqrcode_display_option(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("QRCodecontent_yes").style.display = '';
                           else
                               document.getElementById("QRCodecontent_yes").style.display = 'none';
                       }
                       function ahbqrcode_display_option_qrcodelink(item) 
                       {                         
                           if (item.selectedIndex != 1) 
                               document.getElementById("QRCodecontent_yeslink").style.display = '';
                           else
                               document.getElementById("QRCodecontent_yeslink").style.display = 'none';
                       }
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_QRCode';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("Generates a QRCode image for each booking.", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;             
 
            add_filter( 'cpappb_email_attachments', array( &$this, 'attach_qrcode_file' ), 10, 3 );    

            add_action( 'cpappb_process_data_second_round', array( &$this, 'create_qrcode_file' ), 10, 1 ); 

			add_action( 'init', array( &$this, 'pp_attended_update_status' ), 10, 1 );            

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;

			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    QRCode_enable INT NOT NULL,
                    QRCode_attendedlink INT NOT NULL,
                    qrcode_size TEXT,
                    qrcode_content TEXT, 
					UNIQUE KEY id (id)
				) $charset_collate;";
            
			$wpdb->query($sql);
            
		} // end update_database
        
        
       

		/************************ PUBLIC METHODS  *****************************/

        
		public function attach_qrcode_file( $attachments, $params, $form_id) 
		{
            if (isset($params["qrcode_filename"]))
                $attachments[] = $params["qrcode_filename"];
            return $attachments;
        }
        
        
		public function create_qrcode_file(&$params) 
		{        
            global $wpdb, $cp_appb_plugin;
            global	$qrcode_data_string, 
				$qrcode_error_correct, 
				$qrcode_module_size, 
				$qrcode_version, 
				$qrcode_image_type, 
				$qrcode_image_size, 
				$qrcode_structureappend_n, 
				$qrcode_structureappend_m, 
				$qrcode_structureappend_parity,
				$qrcode_structureappend_originaldata,
				$mib,
				$image_path,
				$path;
            $rows = $wpdb->get_results( 
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] ) 
					);       
			if (!$rows[0]->QRCode_enable)		
			    return;            
 
            $passcode = get_option('CPAHB_QRPASSCODE',"");
            if ($passcode == '')
            {
                $passcode = openssl_random_pseudo_bytes(10);
                update_option( 'CPAHB_QRPASSCODE', base64_encode($passcode));
            }
 
            $path			= dirname( __FILE__ ) . '/qrcode.addon/data';
            $image_path	= dirname( __FILE__ ) . '/qrcode.addon/image';
            $qrcode_image_size   = $rows[0]->qrcode_size;
            $qrcode_data_string  = $cp_appb_plugin->replace_tags ($rows[0]->qrcode_content, $params);

            if ($rows[0]->QRCode_attendedlink)		
            {                
                $qrcode_data_string = $cp_appb_plugin->get_site_url().'?cpahb_attend=1&i='.($params[ 'itemnumber' ]).'&v='.substr(md5($params[ 'itemnumber' ].get_option('CPAHB_QRPASSCODE',"")),0,10);
                $params["qrcode_link"] = $qrcode_data_string;
            }

            require_once dirname( __FILE__ ) . '/qrcode.addon/qrcode.php';
            //echo "---".$image_contents."---";exit;
            if (strlen($image_contents) > 0)
            {
                $filename = sanitize_file_name('qrcode_'.substr(md5($params["itemnumber"]),0,10).'.png');
                $filename1 = WP_CONTENT_DIR . '/uploads/'.$filename;
                $handle = fopen($filename1, 'w');
                fwrite($handle,$image_contents);
                fclose($handle);
                $attachments[] = $filename1;
                
            
                $uploads = wp_upload_dir();
                $upload_path = $uploads['baseurl']."/"; 
                $params["qrcode"] = $upload_path.$filename;
                $params["qrcode_filename"] = $filename1;
                $wpdb->update( $wpdb->prefix.$cp_appb_plugin->table_messages,
                       array( 'posted_data' => serialize($params) ),
                       array ( 'id' => $params[ 'itemnumber' ]),
                       array( '%s' ),
	                   array( '%d' )
                       );                      
            }      

            // return $attachments; 
		}        
        
        
		public function pp_attended_update_status( )
		{
            global $wpdb, $cp_appb_plugin;


            if (!isset($_GET["cpahb_attend"]) || !intval($_GET["cpahb_attend"]))
                return;

            $itemnumber = intval($_GET["i"]);

            if (substr(md5($itemnumber.get_option('CPAHB_QRPASSCODE',"")),0,10) != $_GET["v"])
            {
                echo 'Access denied - verify value is not correct. Be sure to paste the complete link.';
                exit ();
            }

            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $itemnumber) );

            if (!count($myrows))
            {
                return;
            }
                        
            $cp_appb_plugin->setId($myrows[0]->formid);                      

            $settings = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $myrows[0]->formid )
					);                     
                        
            if ($settings[0]->QRCode_enable)
            {
                if (!$cp_appb_plugin->check_current_user_access($myrows[0]->formid))
                {
                    header('Location: '.wp_login_url( get_permalink() ).'?redirect_to='.urlencode($_SERVER["REQUEST_URI"]));
                    exit;
                }
                $cp_appb_plugin->update_status($itemnumber, 'Attended');
                echo '<html><head><title>'.__('Attended', 'appointment-hour-booking').'</title><link rel="stylesheet" type="text/css" href="?cp_cpappb_resources=css" /></head><body id="ahb_cancel_body" style="text-align:center;">';
                echo '<div id="attend_cancel_header"></div>';
                echo '<div id="attend_cancel_content" style="border: 1px dotted #444444; width: 350px; margin: auto;padding:20px;">';
                echo '<p>'.__('Booking marked as', 'appointment-hour-booking'). " <strong>".__('Attended', 'appointment-hour-booking').'</strong>.</p>';
             
                echo '</div>';                    
                echo '<div id="attend_cancel_footer"></div>';
                do_action('cpappb_attend_footer');
                echo '</body></html>';
                exit;
            }

		}        
    
       
		/**
		 *	Add field if not exists
		 */
        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL")
        {
            global $wpdb, $cp_appb_plugin;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$this->form_table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }
        

		/**
		 * mark the item as paid
		 */
		private function _log($message, $adarray = array())
		{
            try { 
			    $h = fopen( __DIR__.'/logs.txt', 'a' );
			    $log = $message;
			    foreach( $_REQUEST as $KEY => $VAL )
			    {
			    	$log .= $KEY.": ".$VAL."\n";
			    }
			    foreach( $adarray as $KEY => $VAL )
			    {
			    	$log .= $KEY.": ".$VAL."\n";
			    }
			    $log .= "================================================\n";
			    fwrite( $h, $log );
			    fclose( $h );
            } catch (Exception $e) {}
		}
        


    } // End Class

    // Main add-on code
    $CPAPPB_QRCode_obj = new CPAPPB_QRCode();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_QRCode_obj->get_addon_id() ] = $CPAPPB_QRCode_obj;
}


?>