<?php
/*
....
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_reCAPTCHA' ) )
{
    class CPAPPB_reCAPTCHA extends CPAPPB_BaseAddon
    {
        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-recaptcha-20151106";
		protected $name = "reCAPTCHA";
		protected $description;
		
		public function get_addon_settings()
		{
			if( isset( $_REQUEST[ 'cpappb_recaptcha' ] ) )
			{	
				check_admin_referer( 'session_id_'.session_id(), '_cpappb_nonce' );
				update_option( 'cpappb_recaptcha_sitekey', trim( $_REQUEST[ 'cpappb_recaptcha_sitekey' ] ) );
				update_option( 'cpappb_recaptcha_secretkey', trim( $_REQUEST[ 'cpappb_recaptcha_secretkey' ] ) );
                update_option( 'cpappb_recaptcha_invisible', isset($_REQUEST[ 'cpappb_recaptcha_invisible' ] ) ? 1 : 0 );
			}	
			?>
			<form method="post">
				<div id="metabox_basic_settings" class="postbox" >
					<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
					<div class="inside"> 
						<table cellspacing="0" style="width:100%;">
							<tr>
								<td style="white-space:nowrap;width:200px;"><?php _e('Site Key', 'appointment-hour-booking');?>:</td>
								<td>
									<input type="text" name="cpappb_recaptcha_sitekey" value="<?php echo ( ( $key = get_option( 'cpappb_recaptcha_sitekey' ) ) !== false ) ? $key : ''; ?>"  style="width:80%;" />
								</td>
							</tr>
							<tr>
								<td style="white-space:nowrap;width:200px;"><?php _e('Secret Key', 'appointment-hour-booking');?>:</td>
								<td>
									<input type="text" name="cpappb_recaptcha_secretkey" value="<?php echo ( ( $key = get_option( 'cpappb_recaptcha_secretkey' ) ) !== false ) ? $key : ''; ?>" style="width:80%;" />
								</td>
							</tr>
							<tr>
								<td>
								</td>
								<td>
									<input type="checkbox" name="cpappb_recaptcha_invisible" <?php echo ( get_option( 'cpappb_recaptcha_invisible' ) ) ? 'CHECKED' : ''; ?> />
									<?php _e('Is it a key for invisible reCAPTCHA?','appointment-hour-booking');?>
								</td>
							</tr>                            
						</table>
						<input type="submit" name="Save settings" />
					</div>
					<input type="hidden" name="cpappb_recaptcha" value="1" />
					<input type="hidden" name="_cpappb_nonce" value="<?php echo wp_create_nonce( 'session_id_'.session_id() ); ?>" />
				</div>
			</form>
			<?php
		}
		
		/************************ ADDON CODE *****************************/
        /************************ ATTRIBUTES *****************************/
        
		private $_recaptcha_inserted = false;
		private $_recaptcha_callback = false;
        private $_invisible = false;
		private $im_flag    = false; // I'm
		private $_sitekey 	= '';
		private $_secretkey = '';
		
        /************************ CONSTRUCT *****************************/
		
        function __construct()
        {
			$this->description = __("The add-on allows to protect the forms with reCAPTCHA service of Google", 'appointment-hour-booking');
			
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
			
			// TO-DO
			// Insert action or filter for checking the captcha in the submitted information
			
			// If reCAPTCHA is enabled do not include the common captcha in the form
			add_filter( 'cpappb_get_option', array( &$this, 'get_form_options' ), 10, 3 );
			
			if( !is_admin() )
			{	
				if( $this->apply_addon() !== false )
				{	
                    
                    // check captcha validation
					add_action( 'init', array( &$this, 'check_requested_validation' ), 1 );
                    
					// Inserts the SCRIPT tag to import the reCAPTCHA on webpage
					add_action( 'wp_footer', array( &$this, 'insert_script' ), 99 );
                    add_action( 'cpappb_captcha_footer', array( &$this, 'insert_cancel_script' ), 99 );
					
					// Inserts the reCAPTCHA field in the form
					add_filter( 'cpappb_the_form', array( &$this, 'insert_recaptcha'), 99, 2 );
                    add_filter( 'cpappb_cancel_captcha', array( &$this, 'insert_cancel_recaptcha'), 99, 2 );
					
					// Validate the form's submission
					add_filter( 'cpappb_valid_submission', array( &$this, 'validate_form' ) );
                    add_filter( 'cpappb_valid_cancel_submission', array( &$this, 'validate_cancel_form' ) );
					
					// Insert the JS code to validate the recaptcha code through AJAX
					add_action( 'cpappb_script_after_validation', array( &$this, 'validate_form_script'), 1, 2 );
				}	
			}	
        } // End __construct
        
        /************************ PRIVATE METHODS *****************************/
		
		/**
		 * Check if the API keys have been defined and return the pair of keys or false 
		 */
        private function apply_addon()
		{
			if( 
				( $sitekey   = get_option( 'cpappb_recaptcha_sitekey' ) ) !== false && !empty( $sitekey ) &&
				( $secretkey = get_option( 'cpappb_recaptcha_secretkey' ) ) !== false && !empty( $secretkey )
			)
			{
				$this->_sitekey   = $sitekey;
				$this->_secretkey = $secretkey;
				$this->_invisible = get_option( 'cpappb_recaptcha_invisible' );
                
				return true;
			}
			return false;
		
		} // End apply_addon
		
		/************************ PUBLIC METHODS  *****************************/
        
        public function	check_requested_validation ()
        {
            global $cp_appb_plugin;
            if( isset( $_REQUEST[ 'cpappb_recaptcha_response' ] ) )
			{
				if( $this->validate_form( trim( $_REQUEST[ 'cpappb_recaptcha_response' ] ) ) )
				{
					print 'ok';
				}	
				else
				{
					print 'captchafailed';
				}	
				exit;
			}	            
        }
        
		/**
         * Check if the reCAPTCHA is used in the form, and inserts the SCRIPT tag that includes its code
         */ 
        public function	insert_script( $params )
		{
			if( $this->_recaptcha_inserted )
			{
				if( !$this->_recaptcha_callback )
				{
					print '
					<script type="text/javascript">
						var cff_reCAPTCHA_callback = function(){
							jQuery( ".g-recaptcha" ).each(
								function()
								{
									grecaptcha.render( this, {"sitekey" : "'.$this->_sitekey.'"'.(($this->_invisible) ? ', "size":"invisible"':'').'});
								}
							);	
						};
					</script>';
					$this->_recaptcha_callback = true;
				}	
				print '<script src="//www.google.com/recaptcha/api.js?onload=cff_reCAPTCHA_callback&render=explicit" async defer></script>';	
			}	
		} // End insert_script


		/**
         * Check if the reCAPTCHA is used in the form, and inserts the SCRIPT tag that includes its code
         */ 
        public function	insert_cancel_script( $params )
		{
			print '<script
  src="https://code.jquery.com/jquery-3.5.1.min.js"
  integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0="
  crossorigin="anonymous"></script>
					<script type="text/javascript">
						var cff_reCAPTCHA_callback = function(){
							jQuery( ".g-recaptcha" ).each(
								function()
								{
									grecaptcha.render( this, {"sitekey" : "'.$this->_sitekey.'"});
								}
							);	
						};
					</script>';
			
			print '<script src="//www.google.com/recaptcha/api.js?onload=cff_reCAPTCHA_callback&render=explicit" async defer></script>';	
			
		} // End insert_cancel_script
		
		
		/**
         * Check if the reCAPTCHA is used in the form, and inserts the reCAPTCHA tag
         */ 
        public function	insert_recaptcha( $form_code, $id )
		{
            global $cp_appb_plugin;
            //$cp_appb_plugin->setId($id);
            
			$this->im_flag = true;
			$is_captcha_enabled = $cp_appb_plugin->get_option('cv_enable_captcha', true);
			$this->im_flag = false;

			if( $is_captcha_enabled == false || $is_captcha_enabled == 'false' )
			{	
				return $form_code;
			}
			$this->_recaptcha_inserted = true;
			return preg_replace( '/<!-- rcadon -->/i', '<div style="margin-top:20px;" class="g-recaptcha" data-sitekey="'.$this->_sitekey.'" '.(($this->_invisible)?'data-size="invisible"':'').'></div><div style="clear:both">&nbsp;</div><!-- rcadon -->', $form_code );	
		} // End insert_recaptcha


		/**
         * reCAPTCHA for other features
         */ 
        public function	insert_cancel_recaptcha( $form_code )
		{
            global $cp_appb_plugin;
            
			return '<div style="margin-left:25px;margin-top:20px;margin-bottom:10px;" class="g-recaptcha" data-sitekey="'.$this->_sitekey.'"></div>';	
		} // End insert_cancel_recaptcha        
        
		
		/**
         * Insert the JS code into the doValidate function for checking the reCAPTCHA code with AJAX
         */ 
        public function validate_form_script( $sequence, $formid )
		{
		    global $cp_appb_plugin;
            //$cp_appb_plugin->setId($formid);
            
			$this->im_flag = true;
			$is_captcha_enabled = $cp_appb_plugin->get_option('cv_enable_captcha', true);
			$this->im_flag = false;
			if( $is_captcha_enabled == false || $is_captcha_enabled == 'false' )
			{
				return;
			}
			
			global $cpappb_default_texts_array;
			$cpappb_texts_array = $cp_appb_plugin->get_option( 'vs_all_texts', $cpappb_default_texts_array );
			$cpappb_texts_array = array_replace_recursive( 
				$cpappb_default_texts_array, 
				is_string( $cpappb_texts_array ) ? unserialize( $cpappb_texts_array ) : $cpappb_texts_array
			);           
			
		?>
			var recaptcha = $dexQuery( '[name="cp_appbooking_pform_<?php print $sequence; ?>"] [name="g-recaptcha-response"]' );
			if( 
				recaptcha.length == 0 ||
				/^\s*$/.test( recaptcha.val() )
			)
			{
                var grecaptcha_e = $dexQuery( '[name="cp_appbooking_pform_<?php print $sequence; ?>"] [class="g-recaptcha"]' );
				if(grecaptcha_e.length && grecaptcha_e.attr( 'data-size' ) == 'invisible')
				{
					grecaptcha.execute();
				}
				else
                {
				    alert('<?php echo( _e('Captcha verification is missing.', 'appointment-hour-booking') ); ?>');
				    return false;
                }
			}
			else
			{
				var result = $dexQuery.ajax({
					type: "GET",
					url:  "<?php echo $cp_appb_plugin->fixurl($cp_appb_plugin->get_site_url(),'ahbcap=1'); ?>",
					data: {
						ps: "<?php echo $sequence; ?>",
						cpappb_recaptcha_response: recaptcha.val()
					},
					async: false
				}).responseText;
				if (result.indexOf("captchafailed") != -1)
				{
					alert('<?php echo( _e('Captcha verification failed. Please try again.') ); ?>');
					return false;
				}	
			}	
		<?php
			
		} // End validate_form_script
		
		/**
         * Check if the reCAPTCHA is valid and return a boolean
         */ 
        public function	validate_form( $recaptcha_response = '' )
		{
			global $cp_appb_plugin;
            //$cp_appb_plugin->setId($id);
            
			if( session_id() == "" ) @session_start();
			
			$this->im_flag = true;
			// $id
			$is_captcha_enabled = $cp_appb_plugin->get_option('cv_enable_captcha', true );
			$this->im_flag = false;
			if( $is_captcha_enabled == false || $is_captcha_enabled == 'false' )
			{
				return true;
			}
			
			if( !empty( $_SESSION[ 'cpappb_recaptcha_i_am_human' ]) ) return true;
			
			if( isset( $_POST[ 'g-recaptcha-response' ] ) )
			{
				$recaptcha_response = $_POST[ 'g-recaptcha-response' ];
			}	

			if( !empty( $recaptcha_response ) )
			{	
				$response = wp_remote_post( 
					'https://www.google.com/recaptcha/api/siteverify', 
					array(
						'body' => array(
							'secret' 	=> $this->_secretkey,
							'response' 	=> $recaptcha_response
						)	
					) 
				);

				if( !is_wp_error( $response ) )
				{
					$response = json_decode( $response[ 'body' ] );
					if( !is_null( $response ) && isset( $response->success ) && $response->success )
					{
						$_SESSION[ 'cpappb_recaptcha_i_am_human' ] = 1;
						return true;
					}	
						
				}	
					
			}
			return false;	
			
		} // End cpappb_valid_submission
        
        
		/**
         * Check if the reCAPTCHA is valid and return a boolean
         */ 
        public function	validate_cancel_form( $recaptcha_response = '' )
		{
			global $cp_appb_plugin;
            
			if( session_id() == "" ) @session_start();
			
			//if( !empty( $_SESSION[ 'cpappb_recaptcha_i_am_human' ]) ) return true;
			
			if( isset( $_POST[ 'g-recaptcha-response' ] ) )
			{
				$recaptcha_response = $_POST[ 'g-recaptcha-response' ];
			}	

			if( !empty( $recaptcha_response ) )
			{	
				$response = wp_remote_post( 
					'https://www.google.com/recaptcha/api/siteverify', 
					array(
						'body' => array(
							'secret' 	=> $this->_secretkey,
							'response' 	=> $recaptcha_response
						)	
					) 
				);
				if( !is_wp_error( $response ) )
				{                    
					$response = json_decode( $response[ 'body' ] );      
					if( !is_null( $response ) && isset( $response->success ) && $response->success )
					{
						$_SESSION[ 'cpappb_recaptcha_i_am_human' ] = 1;
						return true;
					}	
						
				}	
					
			}
			return false;	
			
		} // End cpappb_valid_submission
        
		
		/**
         * Corrects the form options
         */
        public function get_form_options( $value, $field, $id )
        {
	
			if(!is_admin() && !$this->im_flag && $field == 'cv_enable_captcha' && $this->apply_addon() !== false ){
				return 0;
			}	
            return $value;    
		} // End get_form_options
		
    } // End Class
    
    // Main add-on code
    $cpappb_recaptcha_obj = new CPAPPB_reCAPTCHA();
    
	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $cpappb_recaptcha_obj->get_addon_id() ] = $cpappb_recaptcha_obj;
}
?>