<?php
/*

*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_Reminder' ) )
{
    class CPAPPB_Reminder extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-Reminder-20170903";
		protected $name = "Reminder notifications for bookings";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_Reminderlinks_id' ] )
			)
			{
                $cp_appb_plugin->add_field_verify($wpdb->prefix.$this->form_table, 'sndrem_enable', 'INT NOT NULL');
                $cp_appb_plugin->add_field_verify($wpdb->prefix.$this->form_table, 'sndrem_hours', 'INT NOT NULL');
                $cp_appb_plugin->add_field_verify($wpdb->prefix.$this->form_table, 'sndrememail_subject_notification_to_customer', 'mediumtext');
                $cp_appb_plugin->add_field_verify($wpdb->prefix.$this->form_table, 'sndremcustomer_emailformat', 'varchar(255) DEFAULT \'\' NOT NULL');
                $cp_appb_plugin->add_field_verify($wpdb->prefix.$this->form_table, 'sndrememail_notification_to_customer', 'mediumtext');
                
                $wpdb->query('ALTER TABLE `'.$wpdb->prefix.$this->form_table.'` CHANGE `rem_hours` `rem_hours` FLOAT DEFAULT 0 NOT NULL;');
                $wpdb->query('ALTER TABLE `'.$wpdb->prefix.$this->form_table.'` CHANGE `sndrem_hours` `sndrem_hours` FLOAT DEFAULT 0 NOT NULL;');
                $_REQUEST["rememail_subject_notification_to_customer"] = stripcslashes($_REQUEST["rememail_subject_notification_to_customer"]);
                $_REQUEST["rememail_notification_to_customer"] = stripcslashes($_REQUEST["rememail_notification_to_customer"]);
                $_REQUEST["sndrememail_subject_notification_to_customer"] = stripcslashes($_REQUEST["sndrememail_subject_notification_to_customer"]);
                $_REQUEST["sndrememail_notification_to_customer"] = stripcslashes($_REQUEST["sndrememail_notification_to_customer"]);
              
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									
									'rem_enable'	 => $_REQUEST["rem_enable"],
                                    'rem_hours'	 => $_REQUEST["rem_hours"],
                                    
                                    'rememail_subject_notification_to_customer'	 => $_REQUEST["rememail_subject_notification_to_customer"],
                                    'remcustomer_emailformat'	 => $_REQUEST["remcustomer_emailformat"],
                                    'rememail_notification_to_customer'	 => $_REQUEST["rememail_notification_to_customer"],
                                    
                                    'sndrem_enable'	 => $_REQUEST["sndrem_enable"],
                                    'sndrem_hours'	 => $_REQUEST["sndrem_hours"],
                                    
                                    'sndrememail_subject_notification_to_customer'	 => $_REQUEST["sndrememail_subject_notification_to_customer"],
                                    'sndremcustomer_emailformat'	 => $_REQUEST["sndremcustomer_emailformat"],
                                    'sndrememail_notification_to_customer'	 => $_REQUEST["sndrememail_notification_to_customer"]

								),
								array( '%d', '%d', '%f',  
                                             '%s', '%s', '%s',
                                             '%d', '%f',  
                                             '%s', '%s', '%s'
								              )
							);
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["rem_enable"] = 0;
			    $row["rem_hours"] = 24;
                $row["rememail_subject_notification_to_customer"] = 'Appointment reminder...';
                $row["remcustomer_emailformat"] = 'text';
                $row["rememail_notification_to_customer"] = "Reminder for the following appointment:\n\n<"."%INFO%".">\n\nBest regards.";
                
                $row["sndrem_enable"] = 0;
			    $row["sndrem_hours"] = 24;
                $row["sndrememail_subject_notification_to_customer"] = 'Appointment reminder...';
                $row["sndremcustomer_emailformat"] = 'text';
                $row["sndrememail_notification_to_customer"] = "Reminder for the following appointment:\n\n<"."%INFO%".">\n\nBest regards.";
			} else {
			    $row["rem_enable"] = $rows[0]->rem_enable;
			    $row["rem_hours"] = $rows[0]->rem_hours;
                $row["rememail_subject_notification_to_customer"] = $rows[0]->rememail_subject_notification_to_customer;
                $row["remcustomer_emailformat"] = $rows[0]->remcustomer_emailformat;
                $row["rememail_notification_to_customer"] = $rows[0]->rememail_notification_to_customer;
                
                $row["sndrem_enable"] = $rows[0]->sndrem_enable;
			    $row["sndrem_hours"] = $rows[0]->sndrem_hours;
                $row["sndrememail_subject_notification_to_customer"] = $rows[0]->sndrememail_subject_notification_to_customer;
                $row["sndremcustomer_emailformat"] = $rows[0]->sndremcustomer_emailformat;
                $row["sndrememail_notification_to_customer"] = $rows[0]->sndrememail_notification_to_customer;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_Reminderlinks_id" value="1" />
                     Enable reminders? :<br />
                        <?php $option = $row['rem_enable']; ?>
                        <select name="rem_enable" id="rem_enable" onchange="rem_display_emails(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
                   
                   
                   <div id="rememailcontent_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                        <br /><br />
                        <strong>Send email
                        <input type="text" name="rem_hours" value="<?php echo esc_attr($row['rem_hours']); ?>"> hours before the booking</strong>
                        <br /><em>*Note: Calculation based in server time. Current server time is <?php echo date("Y-m-d H:i");?></em>
                        <br /><br />
                                                 
                         <strong>Reminder Email subject (to customer):</strong><br />
                         <input type="text" name="rememail_subject_notification_to_customer" size="70" value="<?php $text = esc_attr($row['rememail_subject_notification_to_customer']); echo $text; ?>" /><br />
                         <strong>Reminder Email format?:</strong><br />
                         <?php $option = $row['remcustomer_emailformat']; ?>
                         <select name="remcustomer_emailformat">
                          <option value="text"<?php if ($option != 'html') echo ' selected'; ?>>Plain Text (default)</option>
                          <option value="html"<?php if ($option == 'html') echo ' selected'; ?>>HTML (use html in the textarea below)</option>
                         </select><br />
                         <strong>Reminder Email content (to customer):</strong><br />
                         <textarea cols="70" rows="5" name="rememail_notification_to_customer"><?php $text = $row['rememail_notification_to_customer']; echo $text; ?></textarea><br />
                         
                         <hr />
                         
                        Enable second reminder? :<br />
                        <?php $option = $row['sndrem_enable']; ?>
                        <select name="sndrem_enable" id="sndrem_enable" onchange="sndrem_display_emails(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
                         
                      <div id="sndrememailcontent_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                        <br /><br />
                        <strong>Send email
                        <input type="text" name="sndrem_hours" value="<?php echo esc_attr($row['sndrem_hours']); ?>"> hours before the booking</strong>
                        <br /><em>*Note: Calculation based in server time. Current server time is <?php echo date("Y-m-d H:i");?></em>
                        <br /><br />
                                                 
                         <strong>Reminder Email subject (to customer):</strong><br />
                         <input type="text" name="sndrememail_subject_notification_to_customer" size="70" value="<?php $text = esc_attr($row['sndrememail_subject_notification_to_customer']); echo $text; ?>" /><br />
                         <strong>Reminder Email format?:</strong><br />
                         <?php $option = $row['sndremcustomer_emailformat']; ?>
                         <select name="sndremcustomer_emailformat">
                          <option value="text"<?php if ($option != 'html') echo ' selected'; ?>>Plain Text (default)</option>
                          <option value="html"<?php if ($option == 'html') echo ' selected'; ?>>HTML (use html in the textarea below)</option>
                         </select><br />
                         <strong>Reminder Email content (to customer):</strong><br />
                         <textarea cols="70" rows="5" name="sndrememail_notification_to_customer"><?php $text = $row['sndrememail_notification_to_customer']; echo $text; ?></textarea><br />
                         <hr />
                       </div>  
                         
                                                
                   </div>
                   <script type="text/javascript">
                       function rem_display_emails(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("rememailcontent_yes").style.display = '';
                           else
                               document.getElementById("rememailcontent_yes").style.display = 'none';
                       }
                       function sndrem_display_emails(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("sndrememailcontent_yes").style.display = '';
                           else
                               document.getElementById("sndrememailcontent_yes").style.display = 'none';
                       }
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_reminderlinks';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on adds support for reminder notifications", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
            
			add_action( 'init', array( &$this, 'pp_Reminder_update_status' ), 10, 1 );

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb, $cp_appb_plugin;

			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    rem_enable INT NOT NULL,
                    rem_hours INT NOT NULL,
                    rememail_subject_notification_to_customer mediumtext,
                    remcustomer_emailformat varchar(255) DEFAULT '' NOT NULL, 
                    rememail_notification_to_customer mediumtext,
                    sndrem_enable INT NOT NULL,
                    sndrem_hours INT NOT NULL,
                    sndrememail_subject_notification_to_customer mediumtext,
                    sndremcustomer_emailformat varchar(255) DEFAULT '' NOT NULL, 
                    sndrememail_notification_to_customer mediumtext,
					UNIQUE KEY id (id)
				) $charset_collate;";
            
			$wpdb->query($sql);
            
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}    
        
		public function pp_Reminder_update_status( )
		{
            global $wpdb, $cp_appb_plugin;
            
            if (!is_object($cp_appb_plugin)) return;
            
            $last_checked = get_option('CPAHB_REM_LASTCHECKED',0);
            if ($last_checked != 0 && $last_checked > date("Y-m-d H:i:s", strtotime("-3 minutes")))
                return;
            update_option('CPAHB_REM_LASTCHECKED',date("Y-m-d H:i:s"));
            
            if (get_option('CPAHB_REM_UPDATE_QUERIES','0') != '2')
            {
                $cp_appb_plugin->add_field_verify($wpdb->prefix.$cp_appb_plugin->table_messages, 'reminderstatus', 'int(11) NOT NULL DEFAULT 0');
                $cp_appb_plugin->add_field_verify($wpdb->prefix.$cp_appb_plugin->table_messages, 'reminderstatussnd', 'int(11) NOT NULL DEFAULT 0');
                update_option('CPAHB_REM_UPDATE_QUERIES','2');
            }    
            
            $saved_id = $cp_appb_plugin->getId();
            $reminders = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE rem_enable=1" );        
            foreach ($reminders as $reminder)
            {
                $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE reminderstatus=0 AND formid=%d", $reminder->formid) );
                $cp_appb_plugin->setId($reminder->formid);
                $from = $cp_appb_plugin->get_option('fp_from_email', @CP_APPBOOK_DEFAULT_fp_from_email);                               
                if (!strpos($from,">"))
                    $from = '"'.$from.'" <'.$from.'>';            
                
                $remhours = floatval($reminder->rem_hours);
                if ($remhours > 0 && $remhours < 1)
                    $modifier = "+".round($remhours*60,0)." minutes";
                else
                    $modifier = "+".$reminder->rem_hours." hours";
                $reminder_up = date("Y-m-d H:i", strtotime($modifier));
       
                // ***********************************************************************************************
                // first reminder block
                // ***********************************************************************************************
                foreach ($myrows as $item)
                {
                    $data = unserialize($item->posted_data); 
                    $one_missing = false;
                    for($i=0; $i<count($data["apps"]); $i++)
                       if (   
                              !isset($data["apps"][$i]["reminder_sent"]) &&
                              (!isset($data["apps"][$i]["cancelled"]) || $data["apps"][$i]["cancelled"] == '')
                          ) 
                        {
                            $apptime = date("Y-m-d H:i",strtotime($data["apps"][$i]["date"]." ".substr($data["apps"][$i]["slot"],0,strpos($data["apps"][$i]["slot"],"/")) ));
                           if ($apptime > date("Y-m-d H:i:s") && $apptime <= $reminder_up)
                            {
                                $data["apps"][$i]["reminder_sent"] = '1';
                                $wpdb->update ( $wpdb->prefix.$cp_appb_plugin->table_messages, array('posted_data' => serialize($data)), array( 'id' => $item->id ));
                                
                                $appstext = $cp_appb_plugin->get_appointments_text($data["apps"]);
                                // send reminder
                                $email_content_customer = $reminder->rememail_notification_to_customer;     
                                
                                $email_content_customer = $cp_appb_plugin->replace_tags($email_content_customer, $data);
                              
                                $email_content_customer = str_replace('<'.'%', '%', $email_content_customer);
                                $email_content_customer = str_replace('%'.'>', '%', $email_content_customer);
                                $email_content_customer = str_replace('%INFO%', $item->data, $email_content_customer);
                                $email_content_customer = str_replace('%itemnumber%', $item->id, $email_content_customer);
                                $email_content_customer = str_replace('%apps%', $appstext, $email_content_customer);
                                
                                foreach ($data as $itemnd => $value)
                                    $email_content_customer = str_replace('%'.$itemnd.'%',(is_array($value)?(implode(", ",$value)):($value)),$email_content_customer);                                     
                                for ($kit=0;$kit<500;$kit++)
                                    $email_content_customer = str_replace('%fieldname'.$kit.'%',"",$email_content_customer);  

                                // send email to customer
                                $to = $item->notifyto;
                                if ('html' == $reminder->remcustomer_emailformat) $content_type = "Content-Type: text/html; charset=utf-8\n"; else $content_type = "Content-Type: text/plain; charset=utf-8\n";
                                
                                if ($to != $cp_appb_plugin->blocked_by_admin_indicator)                                 
                                    wp_mail(trim($to), $reminder->rememail_subject_notification_to_customer, $email_content_customer,
                                            "From: ".$from."\r\n".
                                            $content_type.
                                            "X-Mailer: PHP/" . phpversion());                                
                                
                                // trigger reminder action
                                do_action( 'cpahb_reminder_sent', array('params' => $data, 'slot' => $data["apps"][$i], formid => $reminder->formid) );                                
                            } 
                            else if ($apptime > $reminder_up)
                                $one_missing = true;
                        }
                                            
                    if (!$one_missing)
                        $wpdb->update ( $wpdb->prefix.$cp_appb_plugin->table_messages, array('reminderstatus' => 1), array( 'id' => $item->id ));
                        
                }
                // ***********************************************************************************************
                // END:: first reminder block
                // ***********************************************************************************************                                
                
                
                // ***********************************************************************************************
                // second reminder block
                // ***********************************************************************************************
                if ($reminder->sndrem_enable == 1)
                {                    
                    $sndmyrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE reminderstatussnd=0 AND formid=%d", $reminder->formid) );
                    
                    $remhours = floatval($reminder->sndrem_hours);
                    if ($remhours > 0 && $remhours < 1)
                        $modifier = "+".round($remhours*60,0)." minutes";
                    else
                        $modifier = "+".$remhours." hours";
                    $reminder_up = date("Y-m-d H:i", strtotime($modifier));
 
                    foreach ($sndmyrows as $item)
                    {
                        $data = unserialize($item->posted_data); 
                        $one_missing = false;                    
                        for($i=0; $i<count($data["apps"]); $i++)
                           if (   
                                  !isset($data["apps"][$i]["sndreminder_sent"]) &&
                                  (!isset($data["apps"][$i]["cancelled"]) || $data["apps"][$i]["cancelled"] == '')
                              ) 
                            {
                                $apptime = date("Y-m-d H:i",strtotime($data["apps"][$i]["date"]." ".substr($data["apps"][$i]["slot"],0,strpos($data["apps"][$i]["slot"],"/")) ));
                                if ($apptime > date("Y-m-d H:i:s") && $apptime <= $reminder_up)
                                {
                                    $data["apps"][$i]["sndreminder_sent"] = '1';
                                    $wpdb->update ( $wpdb->prefix.$cp_appb_plugin->table_messages, array('posted_data' => serialize($data)), array( 'id' => $item->id ));
                                    
                                    $appstext = $cp_appb_plugin->get_appointments_text($data["apps"]);
                                    // send reminder
                                    $email_content_customer = $reminder->sndrememail_notification_to_customer;    

                                    $email_content_customer = $cp_appb_plugin->replace_tags($email_content_customer, $data);
                                    
                                    $email_content_customer = str_replace('<'.'%', '%', $email_content_customer);
                                    $email_content_customer = str_replace('%'.'>', '%', $email_content_customer);
                                    $email_content_customer = str_replace('%INFO%', $item->data, $email_content_customer);
                                    $email_content_customer = str_replace('%itemnumber%', $item->id, $email_content_customer);
                                    $email_content_customer = str_replace('%apps%', $appstext, $email_content_customer);
                                    
                                    foreach ($data as $itemnd => $value)
                                        $email_content_customer = str_replace('%'.$itemnd.'%',(is_array($value)?(implode(", ",$value)):($value)),$email_content_customer);                                     
                                    for ($kit=0;$kit<500;$kit++)
                                        $email_content_customer = str_replace('%fieldname'.$kit.'%',"",$email_content_customer);
                        
                                    // send email to customer
                                    $to = $item->notifyto;
                                    if ('html' == $reminder->sndremcustomer_emailformat) $content_type = "Content-Type: text/html; charset=utf-8\n"; else $content_type = "Content-Type: text/plain; charset=utf-8\n";
                                    
                                    if ($to != $cp_appb_plugin->blocked_by_admin_indicator)                                 
                                        wp_mail(trim($to), $reminder->sndrememail_subject_notification_to_customer, $email_content_customer,
                                                "From: ".$from."\r\n".
                                                $content_type.
                                                "X-Mailer: PHP/" . phpversion());                                
                                    
                                    // trigger reminder action
                                    do_action( 'cpahb_reminder_sent', array('params' => $data, 'slot' => $data["apps"][$i], formid => $reminder->formid) );                                        
                                } 
                                else if ($apptime > $reminder_up)
                                    $one_missing = true;
                            }
                                                
                        if (!$one_missing)
                            $wpdb->update ( $wpdb->prefix.$cp_appb_plugin->table_messages, array('reminderstatussnd' => 1), array( 'id' => $item->id ));
                    }
                }
                // ***********************************************************************************************
                // END:: second reminder block
                // ***********************************************************************************************                
                
            }

            $cp_appb_plugin->setId($saved_id);             
         
		}


    } // End Class

    // Main add-on code
    $cpappb_Reminder_obj = new CPAPPB_Reminder();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $cpappb_Reminder_obj->get_addon_id() ] = $cpappb_Reminder_obj;
}

