<?php
/*
    Shared Availability Addon
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_RemoveIgnoreOld' ) )
{
    class CPAPPB_RemoveIgnoreOld extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-RemoveIgnoreOld-20180607";
		protected $name = "Remove or Ignore Old Bookings";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;            
            
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_RemoveIgnoreOld_id' ] )
			)
			{
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									
                                    'remig_enable'	 => $_REQUEST["remig_enable"],
                                    
									'remig_days'	 => $_REQUEST["remig_days"],
                                    
                                    'remig_option'	 => $_REQUEST["remig_option"],

								),
								array( '%d', '%d', '%d', '%d' )
							);           
                $this->check_old_items();            
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
                $row["remig_enable"] = 0;
			    $row["remig_days"] = 30;
			    $row["remig_option"] = 0;
			} else {
                $row["remig_enable"] = $rows[0]->remig_enable;
			    $row["remig_days"] = $rows[0]->remig_days;
                $row["remig_option"] = $rows[0]->remig_option;
            }
			    

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_RemoveIgnoreOld_id" value="1" />
                     Enable deletion or ignore for this calendar? :<br />
                        <?php $option = $row['remig_enable']; ?>
                        <select name="remig_enable" id="remig_enable" onchange="remig_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br /><br />                   
                   
                     <div id="remigcontent_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                     
                         # of days to consider a booking as "old":<br />
                        <input type="text" name="remig_days" id="remig_days" value="<?php echo intval($row['remig_days']); ?>" />
                        <em>Past days after the booked time.</em> <br /><br />                    
                     
                         Delete or ignore old bookings?:<br />
                        <?php $option = $row['remig_option']; ?>
                        <select name="remig_option" id="remig_option">
                          <option value="0"<?php if ($option != 1) echo ' selected'; ?>>Ignore</option>
                          <option value="1"<?php if ($option == 1) echo ' selected'; ?>>Delete (cannot be undone)</option>
                         </select><br />
                         <em>Ignored items will be ignored from the booking form and schedule calendar. Deleted items will be completely deleted from all the lists.</em>
                     </div>
                     
                    <script type="text/javascript">
                       function remig_display_option(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("remigcontent_yes").style.display = '';
                           else
                               document.getElementById("remigcontent_yes").style.display = 'none';
                       }
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_RemoveIgnoreOld';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {            
			$this->description = __("The add-on allows to automatically remove or ignore old bookings to increase the booking form speed", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;      
           
            add_filter( 'cpappb_the_availability_filter', array( &$this, 'availability_filter'), 99, 2 );

            //add_action( 'init', array( &$this, 'check_old_items' ), 10, 1 );
            
            // aqui un action de init o lo que sea para el cron
            if ( ! wp_next_scheduled( 'cpappb_deleteignore_ahb_messages_hook' ) ) {
                wp_schedule_event( time(), 'daily', 'cpappb_deleteignore_ahb_messages_hook' );
            }

            add_action( 'cpappb_deleteignore_ahb_messages_hook', array( &$this, 'check_old_items' ) );
            
            $this->update_database();

        } // End __construct


        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;

			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
                    formid INT NOT NULL,
					remig_enable INT NOT NULL,
                    remig_days INT NOT NULL,
                    remig_option INT NOT NULL,
					UNIQUE KEY id (id)
				) $charset_collate;";
            
			$wpdb->query($sql);
            
		} // end update_database
      
               



		/************************ PUBLIC METHODS  *****************************/


		/**
         * Modify availability filter
         */
        public function	availability_filter( $query_filter, $id )
		{
            global $wpdb, $cp_appb_plugin;
            
            $is_enable = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=".intval($id)." AND remig_enable=1" );
            if (!count($is_enable))
                return $query_filter;
            
            if (get_option('cp_cpappb_isold_updateb','') == '')
            {
                $cp_appb_plugin->add_field_verify($wpdb->prefix.$cp_appb_plugin->table_messages, 'isold', 'int(10) DEFAULT 0 NOT NULL');
                update_option('cp_cpappb_isold_updateb', '1');
            }
            return $query_filter." AND isold<>1";            
		} // end availability_filter  
        
        
		/**
		 * check old items
		 */
		public function check_old_items( )
		{
            global $wpdb, $cp_appb_plugin;       

            if (!is_object($cp_appb_plugin))
                return;
                
            if (get_option('cp_cpappb_isold_updateb','') == '')
            {
                $cp_appb_plugin->add_field_verify($wpdb->prefix.$cp_appb_plugin->table_messages, 'isold', 'int(10) DEFAULT 0 NOT NULL');
                update_option('cp_cpappb_isold_updateb', '1');
            }
            
            $verifications = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE remig_enable=1" );        
            foreach ($verifications as $verification)
            {
                $rows = $wpdb->get_results( "SELECT id,posted_data FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE formid=".intval($verification->formid).($verification->remig_option == 1?"":" AND isold=0") );
                foreach($rows as $item)
                {
                    $data = unserialize($item->posted_data);
                    $ct = 0;
                    $somenew = false;
                    foreach($data["apps"] as $app) 
                    {
                        $time = explode("/", $app["slot"]);                        
                        $datetime = $app["date"]." ".trim($time[0]);                         
                        if (strtotime($datetime) > strtotime("-".$verification->remig_days." days"))
                        {
                            $somenew = true;
                            break;
                        }                            
                    }
                    if (!$somenew)
                    {
                        if ($verification->remig_option == 1)
                            $wpdb->query("DELETE FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=".intval($item->id));
                        else
                            $wpdb->query("UPDATE ".$wpdb->prefix.$cp_appb_plugin->table_messages." SET isold=1 WHERE id=".intval($item->id));
                    }
                }
            }
        }         


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}
        


    } // End Class

    // Main add-on code
    $CPAPPB_RemoveIgnoreOld_obj = new CPAPPB_RemoveIgnoreOld();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_RemoveIgnoreOld_obj->get_addon_id() ] = $CPAPPB_RemoveIgnoreOld_obj;
}

