<?php
/*

*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_SagePayments' ) )
{
    class CPAPPB_SagePayments extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-SagePayments-20160706";
		protected $name = "SagePayments Payment Gateway";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'cpabc_SagePayments_id' ] )
			)
			{
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									'SagePayments_api_username'	 => $_REQUEST["SagePayments_api_username"],
									'T_shipping'	 => $_REQUEST["T_shipping"],
                                    'T_tax'	 => $_REQUEST["T_tax"],
                                    'C_fname'	 => $_REQUEST["C_fname"],
                                    'C_lname'	 => $_REQUEST["C_lname"],
                                    'C_address'	 => $_REQUEST["C_address"],
                                    'C_city'	 => $_REQUEST["C_city"],
                                    'C_state'	 => $_REQUEST["C_state"],
                                    'C_zip'	 => $_REQUEST["C_zip"],
                                    'C_email'	 => $_REQUEST["C_email"],
                                    'C_telephone'	 => $_REQUEST["C_telephone"],
									'enabled'	 => $_REQUEST["SagePayments_enabled"]

								),
								array( '%d', '%s', '%s', '%s',
								             '%s', '%s', '%s',
								             '%s', '%s', '%s',
								             '%s', '%s', '%s' )
							);
			}


			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["SagePayments_api_username"] = "";
			    $row["enabled"] = "0";
			} else {
			    $row["SagePayments_api_username"] = $rows[0]->SagePayments_api_username;
			    $row["enabled"] = $rows[0]->enabled;
                $row["T_shipping"] = $rows[0]->T_shipping;
                $row["T_tax"] = $rows[0]->T_tax;
                $row["C_fname"] = $rows[0]->C_fname;
                $row["C_lname"] = $rows[0]->C_lname;
                $row["C_address"] = $rows[0]->C_address;
                $row["C_city"] = $rows[0]->C_city;
                $row["C_state"] = $rows[0]->C_state;
                $row["C_zip"] = $rows[0]->C_zip;
                $row["C_email"] = $rows[0]->C_email;
                $row["C_telephone"] = $rows[0]->C_telephone			    ;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="cpabc_SagePayments_id" value="1" />
                   <table class="form-table">
                    <tr valign="top">
                    <th scope="row"><?php _e('Enable SagePayments? (if enabled PayPal Standard is disabled)', 'appointment-hour-booking'); ?></th>
                    <td><select name="SagePayments_enabled">
                         <option value="0" <?php if (!$row["enabled"]) echo 'selected'; ?>><?php _e('No', 'appointment-hour-booking'); ?></option>
                         <option value="1" <?php if ($row["enabled"] == '1') echo 'selected'; ?>><?php _e('Yes', 'appointment-hour-booking'); ?></option>
                         <option value="2" <?php if ($row["enabled"] == '2') echo 'selected'; ?>><?php _e('Optional: This payment method + Pay Later (submit without payment)', 'appointment-hour-booking'); ?></option>
                         <option value="3" <?php if ($row["enabled"] == '3') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods (enabled)', 'appointment-hour-booking'); ?></option>
                         <option value="4" <?php if ($row["enabled"] == '4') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods  + Pay Later ', 'appointment-hour-booking'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Merchant ID (M_id)', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="SagePayments_api_username" size="20" value="<?php echo esc_attr($row["SagePayments_api_username"]); ?>" /><br />
                        <em>Change this value with M_id received from SagePayments<em></td>
                    </tr>

                   </table>
                   <hr />
                   Optional fields (indicate the fieldname for the related information, ex: fieldname1, fieldname2, ...)
                   <table class="form-table">
                    <tr valign="top">
                    <th scope="row"><?php _e('Shipping/Freight:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="T_shipping" size="20" value="<?php echo esc_attr($row["T_shipping"]); ?>" /><br />
                        <em>ID of the field of the form that contains this info. Sample values: fieldname1, fieldname2, ...<em></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Tax:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="T_tax" size="20" value="<?php echo esc_attr(@$row["T_tax"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('First Name:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="C_fname" size="20" value="<?php echo esc_attr(@$row["C_fname"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Last Name:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="C_lname" size="20" value="<?php echo esc_attr(@$row["C_lname"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Address:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="C_address" size="20" value="<?php echo esc_attr(@$row["C_address"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('City:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="C_city" size="20" value="<?php echo esc_attr(@$row["C_city"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('State:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="C_state" size="20" value="<?php echo esc_attr(@$row["C_state"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('ZIP:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="C_zip" size="20" value="<?php echo esc_attr(@$row["C_zip"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Email:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="C_email" size="20" value="<?php echo esc_attr(@$row["C_email"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Telephone:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="C_telephone" size="20" value="<?php echo esc_attr(@$row["C_telephone"]); ?>" /></td>
                    </tr>
                   </table>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_SagePayments';
        private $_inserted = false;
		private $_apphbmain;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			
			$this->description = __("The add-on adds support for SagePayments payments", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            if (!is_admin())
            {
			    add_action( 'cpappb_process_data_before_insert', array( &$this, 'pp_before_insert' ), 10, 1 );

			    add_action( 'cpappb_process_data', array( &$this, 'pp_SagePayments' ), 11, 1 );

			    add_action( 'init', array( &$this, 'pp_SagePayments_update_status' ), 10, 0 );

			    add_filter( 'cpappb_the_form', array( &$this, 'insert_payment_fields'), 99, 2 );
            } 
            else 
            {
				// Delete forms
				add_action( 'apphb_delete_form', array(&$this, 'delete_form') );

				// Clone forms
				add_action( 'apphb_clone_form', array(&$this, 'clone_form'), 10, 2 );

				// Export addon data
				add_action( 'apphb_export_addons', array(&$this, 'export_form'), 10, 2 );

				// Import addon data
				add_action( 'apphb_import_addons', array(&$this, 'import_form'), 10, 2 );
			}

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb, $cp_appb_plugin;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
					enabled varchar(10) DEFAULT '0' NOT NULL ,
					SagePayments_api_username varchar(255) DEFAULT '' NOT NULL ,
					T_shipping varchar(255) DEFAULT '' NOT NULL ,
                    T_tax varchar(255) DEFAULT '' NOT NULL ,
                    C_fname varchar(255) DEFAULT '' NOT NULL ,
                    C_lname varchar(255) DEFAULT '' NOT NULL ,
                    C_address varchar(255) DEFAULT '' NOT NULL ,
                    C_city varchar(255) DEFAULT '' NOT NULL ,
                    C_state varchar(255) DEFAULT '' NOT NULL ,
                    C_zip varchar(255) DEFAULT '' NOT NULL ,
                    C_email varchar(255) DEFAULT '' NOT NULL ,
                    C_telephone varchar(255) DEFAULT '' NOT NULL ,
					UNIQUE KEY id (id)
				) $charset_collate;";

			$wpdb->query($sql);
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
         * process before insert
         */
		public function pp_before_insert(&$params)
		{
            global $wpdb, $cp_appb_plugin;

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID)
			    return;

			$params["payment_option"] = $this->name;

	    }


		/**
         * Check if the Optional is enabled in the form, and inserts radiobutton
         */
        public function	insert_payment_fields( $form_code, $id )
		{
            global $wpdb, $cp_appb_plugin;
            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $id )
					);

			if (empty( $rows ) || $rows[0]->enabled == '0')
			    return $form_code;

			// output radio-buttons here
			$form_code = preg_replace( '/<!--addons-payment-options-->/i', '<div><input type="radio" name="bccf_payment_option_paypal" vt="'.$this->addonID.'" value="'.$this->addonID.'" checked> '.__('Pay with SagePayments', 'appointment-hour-booking').'</div><!--addons-payment-options-->', $form_code );

            if (($rows[0]->enabled == '2' || $rows[0]->enabled == '4') && !strpos($form_code,'bccf_payment_option_paypal" vt="0') )
			    $form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" vt="0" value="0"> '.__( $cp_appb_plugin->get_option('pay_later_label','Pay later',$id), 'appointment-hour-booking').'</div>', $form_code );

			if (substr_count ($form_code, 'name="bccf_payment_option_paypal"') > 1)
			    $form_code = str_replace( 'id="field-c0" style="display:none">', 'id="field-c0">', $form_code);

            return $form_code;
        }


		/**
         * process payment
         */
		public function pp_SagePayments($params)
		{
            global $wpdb, $cp_appb_plugin;

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID || floatval($params["final_price"]) == 0)
			    return;

            $pro_item_name = $cp_appb_plugin->get_option('product_name', 'Booking');
            foreach ($params as $item => $value)
                $pro_item_name = str_replace('<%'.$item.'%>',(is_array($value)?(implode(", ",$value)):($value)),$pro_item_name);

            $urlok = $cp_appb_plugin->get_site_url().'/?apphbSagePayments_ipncheck=1&itemnumber='.$params["itemnumber"];
            $urlerror = $_POST["cp_ref_page"] ;

            $ppurl = 'https://www.sagepayments.net/eftcart/forms/order.asp';

?>
        <html>
        <head><title>Redirecting to SagePayments...</title></head>
        <body>
        <form method="POST" name="SagePaymentsForm" id="SagePaymentsForm" action="<?php echo $ppurl; ?>">
         <input type="hidden" name="M_id" value="<?php echo $rows[0]->SagePayments_api_username; ?>">
         <input type="hidden" name="P_count" value="1">
         <input type="hidden" name="P_part1" value="<?php echo "REQUEST".$params["itemnumber"]; ?>">
         <input type="hidden" name="P_desc1" value="<?php echo $pro_item_name; ?>">
         <input type="hidden" name="P_qty1" value="1">
         <input type="hidden" name="P_price1" value="<?php echo $params["final_price"]; ?>">
         <input type="hidden" name="Approved_url" value="<?php echo $urlok; ?>">
         <input type="hidden" name="Declined_url" value="<?php echo $urlerror; ?>">
         <input type="hidden" name="T_ordernum" value="<?php echo $params["itemnumber"]; ?>">
         <?php if ($rows[0]->T_shipping) { ?><input type="hidden" name="T_shipping" value="<?php echo $params[$rows[0]->T_shipping]; ?>"><?php } ?>
         <?php if ($rows[0]->T_tax) { ?><input type="hidden" name="T_tax" value="<?php echo $params[$rows[0]->T_tax]; ?>"><?php } ?>
         <?php if ($rows[0]->C_fname) { ?><input type="hidden" name="C_fname" value="<?php echo $params[$rows[0]->C_fname]; ?>"><?php } ?>
         <?php if ($rows[0]->C_lname) { ?><input type="hidden" name="C_lname" value="<?php echo $params[$rows[0]->C_lname]; ?>"><?php } ?>
         <?php if ($rows[0]->C_address) { ?><input type="hidden" name="C_address" value="<?php echo $params[$rows[0]->C_address]; ?>"><?php } ?>
         <?php if ($rows[0]->C_city) { ?><input type="hidden" name="C_city" value="<?php echo $params[$rows[0]->C_city]; ?>"><?php } ?>
         <?php if ($rows[0]->C_state) { ?><input type="hidden" name="C_state" value="<?php echo $params[$rows[0]->C_state]; ?>"><?php } ?>
         <?php if ($rows[0]->C_zip) { ?><input type="hidden" name="C_zip" value="<?php echo $params[$rows[0]->C_zip]; ?>"><?php } ?>
         <?php if ($rows[0]->C_email) { ?><input type="hidden" name="C_email" value="<?php echo $params[$rows[0]->C_email]; ?>"><?php } ?>
         <?php if ($rows[0]->C_telephone) { ?><input type="hidden" name="C_telephone" value="<?php echo $params[$rows[0]->C_telephone]; ?>"><?php } ?>
        </form>
        <script type="text/javascript">document.SagePaymentsForm.submit();</script>
        </body>
        </html>
<?php



            exit;
		} // end pp_SagePayments


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}

		public function pp_SagePayments_update_status( )
		{
            global $wpdb, $cp_appb_plugin;
            if (
				!isset( $_GET['apphbSagePayments_ipncheck'] ) ||
				$_GET['apphbSagePayments_ipncheck'] != '1' ||
				!isset( $_GET["itemnumber"] )
			) return;

			$itemnumber = intval(@$_GET["itemnumber"]);

            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $itemnumber) );
            if (empty( $myrows ))
			   return;
            $params = unserialize($myrows->posted_data);

            if($params["paid"] != '1')
            {
                $params["paid"] = '1';
                $params["payment_type"] = "SagePayments";
                $wpdb->query( $wpdb->prepare("UPDATE  ".$wpdb->prefix.$cp_appb_plugin->table_messages." SET posted_data=%s WHERE id=%d", serialize($params), $itemnumber) );
                $cp_appb_plugin->update_status($itemnumber, $cp_appb_plugin->get_option('defaultpaidstatus', '') );
				$cp_appb_plugin->ready_to_go_reservation($itemnumber, "", $params);
                // do_action( 'apphb_payment_processed', $submission->paypal_post );
            }

            header("Location: ".$cp_appb_plugin->get_option('fp_return_page', $cp_appb_plugin->get_site_url()));
            exit();
		}

		/**
		 *	Delete the form from the addon's table
		 */
        public function delete_form( $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$wpdb->delete( $wpdb->prefix.$this->form_table, array('formid' => $formid), '%d' );
		} // delete_form

		/**
		 *	Clone the form's row
		 */
		public function clone_form( $original_form_id, $new_form_id )
		{
			global $wpdb, $cp_appb_plugin;

			$form_rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $original_form_id ), ARRAY_A);

			if(!empty($form_rows))
			{
				foreach($form_rows as $form_row)
				{
					unset($form_row["id"]);
					$form_row["formid"] = $new_form_id;
					$wpdb->insert( $wpdb->prefix.$this->form_table, $form_row);
				}
			}
		} // End clone_form

		/**
		 *	It is called when the form is exported to export the addons data too.
		 *  Receive an array with the other addons data, and the form's id for filtering.
		 */
		public function export_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ), ARRAY_A );
			if(!empty($rows))
			{
				$addons_array[ $this->addonID ] = array();
				foreach($rows as $row)
				{
					unset($row['id']);
					unset($row['formid']);
					$addons_array[ $this->addonID ][] = $row;
				}
			}
			return $addons_array;
		} // End export_form

		/**
		 *	It is called when the form is imported to import the addons data too.
		 *  Receive an array with all the addons data, and the new form's id.
		 */
		public function import_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			if(isset($addons_array[$this->addonID]))
			{
				foreach($addons_array[$this->addonID] as $row)
				{
					if(!empty($row))
					{
						$row['formid'] = $formid;
						$wpdb->insert(
							$wpdb->prefix.$this->form_table,
							$row
						);
					}
				}
			}
		} // End import_form

    } // End Class

    // Main add-on code
    $CPAPPB_SagePayments_obj = new CPAPPB_SagePayments();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_SagePayments_obj->get_addon_id() ] = $CPAPPB_SagePayments_obj;
}

