<?php
/*

*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_SchedudeCalContents' ) )
{
    class CPAPPB_SchedudeCalContents extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-SchedudeCalContents-20200121";
		protected $name = "Schedude Calendar Contents Customization";
		protected $description;
        

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_SchedudeCalContentslinks_id' ] )
			)
			{

			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,

									'scontents_enable'	 => $_REQUEST["scontents_enable"],
                                    
									't_content_admin'	 => stripslashes($_REQUEST["t_content_admin"]),
                                    't_title_admin'	 => stripslashes($_REQUEST["t_title_admin"]),
                                    't_title_public'	 => stripslashes($_REQUEST["t_title_public"]),
									't_content_public'	 => stripslashes($_REQUEST["t_content_public"])

								),
								array( 
                                       '%d', '%d', 
                                       '%s', '%s', '%s', '%s'
								     )
							);
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["scontents_enable"] = 0;
                $row["t_title_admin"] = get_option('cp_cpappb_schcaltitle_admin',CP_CPAPPB_SCHCALTITLE_ADMIN);   
                $row["t_content_admin"] = get_option('cp_cpappb_schcalcontent_admin',CP_CPAPPB_SCHCALCONTENT_ADMIN);
                $row["t_title_public"] = get_option('cp_cpappb_schcaltitle_public',CP_CPAPPB_SCHCALTITLE_PUBLIC);
                $row["t_content_public"] = get_option('cp_cpappb_schcalcontent_public',CP_CPAPPB_SCHCALCONTENT_PUBLIC);
			} else {
			    $row["scontents_enable"] = $rows[0]->scontents_enable;
                $row["t_title_admin"] = $rows[0]->t_title_admin;
			    $row["t_content_admin"] = $rows[0]->t_content_admin;
                $row["t_title_public"] = $rows[0]->t_title_public;
                $row["t_content_public"] = $rows[0]->t_content_public;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_SchedudeCalContentslinks_id" value="1" />
                        Customize schedule contents for this calendar? :<br />
                        <?php $option = $row['scontents_enable']; ?>
                        <select name="scontents_enable" id="scontents_enable" onchange="abcical_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />

                         <strong>Admin area: Event Title:</strong><br />
                         <input type="text" name="t_title_admin" size="70" value="<?php $text = esc_attr($row['t_title_admin']); echo $text; ?>" /><br />
                         <strong>Admin area: Event Contents:</strong><br />
                         <textarea cols="70" rows="5" name="t_content_admin"><?php $text = $row['t_content_admin']; echo $text; ?></textarea><br />

                         <br /><br />

                         <strong>Public website: Event Title:</strong><br />
                         <input type="text" name="t_title_public" size="70" value="<?php $text = esc_attr($row['t_title_public']); echo $text; ?>" /><br />
                         <strong>Public website: Event Contents:</strong><br />
                         <textarea cols="70" rows="5" name="t_content_public"><?php $text = $row['t_content_public']; echo $text; ?></textarea><br />
                         
                         <em><br />Check the <a href="https://apphourbooking.dwbooster.com/faq#q81" target="_blank">list of tags available for the contents</a>.</em>
                        <em><br />The following additional tags are available for the specific time listed: <b>%app_service% - %app_date% - %app_slot% - %app_quantity% - %app_status%</b> </em>

				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_SchedudeCalContents';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on allow to customize the content displayed on the schedule calendar for each form.", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            add_filter( 'cpappb_mv_title_admin_filter', array( &$this, 'cpappb_mv_title_admin_filter' ), 10, 2 );
            add_filter( 'cpappb_mv_content_admin_filter', array( &$this, 'cpappb_mv_content_admin_filter' ), 10, 2 );
            add_filter( 'cpappb_mv_content_public_filter', array( &$this, 'cpappb_mv_content_public_filter' ), 10, 2 );
            add_filter( 'cpappb_mv_title_public_filter', array( &$this, 'cpappb_mv_title_public_filter' ), 10, 2 );

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id int(10) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    scontents_enable INT NOT NULL,
                    t_title_admin text,                    
                    t_content_admin text,                    
                    t_title_public text,
                    t_content_public text,
					UNIQUE KEY id (id)
				) $charset_collate;";

			$wpdb->query($sql);
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/
        
        
       public function cpappb_mv_title_admin_filter ($content, $form_id) 
       {
           global $wpdb; 
           $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
		   if (empty( $rows ) || !$rows[0]->scontents_enable)
		       return $content;
           else
               return $rows[0]->t_title_admin;
       }
       
       
       public function cpappb_mv_content_admin_filter ($content, $form_id) 
       {
           global $wpdb; 
           $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
		   if (empty( $rows ) || !$rows[0]->scontents_enable)
		       return $content;
           else
               return $rows[0]->t_content_admin;
       }


       public function  cpappb_mv_title_public_filter ($content, $form_id) 
       {
           global $wpdb; 
           $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
		   if (empty( $rows ) || !$rows[0]->scontents_enable)
		       return $content;
           else
               return $rows[0]->t_title_public;       
       }
       
       
       public function cpappb_mv_content_public_filter ($content, $form_id) 
       {
           global $wpdb; 
           $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
		   if (empty( $rows ) || !$rows[0]->scontents_enable)
		       return $content;
           else
               return $rows[0]->t_content_public;
       }       


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}


    } // End Class

    // Main add-on code
    $cpappb_SchedudeCalContents_obj = new CPAPPB_SchedudeCalContents();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $cpappb_SchedudeCalContents_obj->get_addon_id() ] = $cpappb_SchedudeCalContents_obj;
}

