<?php
/*
    Shared Availability Addon
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_SharedAvailability' ) )
{
    class CPAPPB_SharedAvailability extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-SharedAvailability-20180607";
		protected $name = "Shared Availability between Calendars";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;            
            
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_SharedAvailability_id' ] )
			)
			{
                update_option('ahb_shared_addon_mv',(isset($_POST["shareaddon_mv"]) ? intval($_POST["shareaddon_mv"]) : 0));
			    $wpdb->query( "DELETE FROM ".$wpdb->prefix.$this->form_table." WHERE formid1=".intval($form_id)." OR formid2=".intval($form_id) );
                foreach ($_POST["sharevavail"] as $item)
                {
				    $wpdb->insert(
				    				$wpdb->prefix.$this->form_table,
				    				array(
				    					'formid1' => $form_id,									
				    					'formid2' => $item
				    				),
				    				array( '%d', '%d' )
				    			);
                }
                        
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid1=%d OR formid2=%d", $form_id, $form_id )
					);
			$selected = array();
            foreach ($rows as $item)
            {
                $selected[] = $item->formid1;
                $selected[] = $item->formid2;
            }

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_SharedAvailability_id" value="1" />
                     Share booked times of this calendar with the following calendars (two-way sharing):<br />                        
                        <select multiple name="sharevavail[]" id="sharevavail[]">
<?php
  $myrows = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_items );                                                                     
  foreach ($myrows as $item)     
      if ($item->id != $form_id )  
      {
          echo '<option value="'.$item->id.'"'.(in_array($item->id,$selected)?' selected':'').'>'.esc_html($item->form_name).'</option>';
      }
?>                          
                        </select><br />
                   
                   <br />
                   &nbsp;<input type="checkbox" value="1" name="shareaddon_mv" <?php if (get_option('ahb_shared_addon_mv',0)) echo ' checked '; ?>>  Share booked times also for the Schedule Calendar view? 
                   <br /><br />
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_sharedavailability';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on allow to share the booked times between calendars (for blocking booked times)", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
            
		
            add_filter( 'cpappb_the_availability_filter', array( &$this, 'availability_filter'), 99, 2 );
            add_filter( 'cpappb_the_availability_field', array( &$this, 'availability_field'), 99, 2 );
            

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;

			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid1 INT NOT NULL,
                    formid2 INT NOT NULL,
					UNIQUE KEY id (id)
				) $charset_collate;";
            
			$wpdb->query($sql);
            
		} // end update_database
      
               

		/**
         * Modify availability filter
         */
        public function	availability_filter( $query_filter, $id )
		{
            global $wpdb, $cp_appb_plugin;

            $rows = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid1=".intval($id) ." OR formid2=".intval($id) );
            foreach ($rows as $item)
            {
                if ($id == $item->formid1)
                    $the_other_id = $item->formid2;
                else
                    $the_other_id = $item->formid1;
                $query_filter .= " OR formid=".$the_other_id;
            }
            
            $query_filter = " (".$query_filter.") ";
            return $query_filter;
            
		} // end availability_filter        
        
        
		/**
         * Modify availability filter
         */
        public function	availability_field( $field_filter, $id )
		{
            global $wpdb, $cp_appb_plugin;

            $rows = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid1=".intval($id) ." OR formid2=".intval($id) );
            if (count($rows))  
                $field_filter = '';   // share the times between all calendar fields, even into the same calendar
            return $field_filter;
            
		} // end availability_filter          


		/************************ PUBLIC METHODS  *****************************/


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}
        


    } // End Class

    // Main add-on code
    $CPAPPB_SharedAvailability_obj = new CPAPPB_SharedAvailability();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_SharedAvailability_obj->get_addon_id() ] = $CPAPPB_SharedAvailability_obj;
}

