<?php
/*

*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_Skrill' ) )
{
    class CPAPPB_Skrill extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-Skrill-20170903";
		protected $name = "Skrill Payments Integration";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_skrill_id' ] )
			)
			{
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,

									'Skrill_api_username'	 => $_REQUEST["Skrill_api_username"],									
									'x_cancel_url'	 => $_REQUEST["x_cancel_url"],
									'currency'	 => $_REQUEST["currency"],
									'enabled'	 => $_REQUEST["Skrill_enabled"]

								),
								array( '%d', '%s', '%s', 
								             '%s', '%s'
								              )
							);
			}


			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["Skrill_api_username"] = "";
			    $row["enabled"] = "0";
                $row["x_cancel_url"] = '';
                $row["currency"] = $rows[0]->currency;
			} else {
			    $row["enabled"] = $rows[0]->enabled;
			    $row["Skrill_api_username"] = $rows[0]->Skrill_api_username;
                $row["x_cancel_url"] = $rows[0]->x_cancel_url;
                $row["currency"] = $rows[0]->currency;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_skrill_id" value="1" />
                   <table class="form-table">
                    <tr valign="top">
                    <th scope="row"><?php _e('Enable Skrill Payments?', 'appointment-hour-booking'); ?></th>
                    <td><select name="Skrill_enabled">
                         <option value="0" <?php if (!$row["enabled"]) echo 'selected'; ?>><?php _e('No', 'appointment-hour-booking'); ?></option>
                         <option value="1" <?php if ($row["enabled"] == '1') echo 'selected'; ?>><?php _e('Yes', 'appointment-hour-booking'); ?></option>
                         <option value="2" <?php if ($row["enabled"] == '2') echo 'selected'; ?>><?php _e('Optional: This payment method + Pay Later (submit without payment)', 'appointment-hour-booking'); ?></option>
                         <option value="3" <?php if ($row["enabled"] == '3') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods (enabled)', 'appointment-hour-booking'); ?></option>
                         <option value="4" <?php if ($row["enabled"] == '4') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods  + Pay Later ', 'appointment-hour-booking'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Skrill Email', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="Skrill_api_username" size="40" value="<?php echo esc_attr($row["Skrill_api_username"]); ?>" /><br />
                    </tr>

                    <tr valign="top">
                    <th scope="row"><?php _e('Cancel URL:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="x_cancel_url" size="70" value="<?php echo esc_attr(@$row["x_cancel_url"]); ?>" /><br />
                        <em>User will return here if payment fails.</em>
                        </td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Currency:', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="currency" size="70" value="<?php echo esc_attr(@$row["currency"]); ?>" /><br />
                        <em>Currency code. example: USD, EUR, CAD, GBP ...</em>
                        </td>
                    </tr>
                   </table>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_skrill';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on adds support for Skrill payments", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            if (!is_admin())
            {    
			    add_action( 'cpappb_process_data', array( &$this, 'pp_Skrill' ), 11, 1 );

		    	add_action( 'init', array( &$this, 'pp_Skrill_update_status' ), 10, 1 );

			    add_filter( 'cpappb_the_form', array( &$this, 'insert_payment_fields'), 99, 2 );
            }
            
            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
					enabled varchar(10) DEFAULT '0' NOT NULL ,
					Skrill_api_username varchar(255) DEFAULT '' NOT NULL ,
					x_cancel_url varchar(255) DEFAULT '' NOT NULL ,
					currency varchar(255) DEFAULT '' NOT NULL ,
					enable_option_yes varchar(255) DEFAULT '' NOT NULL ,
                    enable_option_no varchar(255) DEFAULT '' NOT NULL ,
                    enable_option_paypal varchar(255) DEFAULT '' NOT NULL ,
					UNIQUE KEY id (id)
				) $charset_collate;";

			$wpdb->query($sql);
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/

		/**
         * Check if the Optional is enabled in the form, and inserts radiobutton
         */
        public function	insert_payment_fields( $form_code, $id )
		{
            global $wpdb, $cp_appb_plugin;
            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $id )
					);

			if (empty( $rows ) || $rows[0]->enabled == '0')
			    return $form_code;

			// output radio-buttons here
			$form_code = preg_replace( '/<!--addons-payment-options-->/i', '<div><input type="radio" name="bccf_payment_option_paypal" vt="'.$this->addonID.'" value="'.$this->addonID.'" checked> '.__('Pay with Skrill', 'appointment-hour-booking').'</div><!--addons-payment-options-->', $form_code );

            if (($rows[0]->enabled == '2' || $rows[0]->enabled == '4') && !strpos($form_code,'bccf_payment_option_paypal" vt="0') )
			    $form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" vt="0" value="0"> '.__( $cp_appb_plugin->get_option('pay_later_label','Pay later',$id), 'appointment-hour-booking').'</div>', $form_code );

			if (substr_count ($form_code, 'name="bccf_payment_option_paypal"') > 1)
			    $form_code = str_replace( 'id="field-c0" style="display:none">', 'id="field-c0">', $form_code);

            return $form_code;
        }


		/**
         * process payment
         */
		public function pp_Skrill(&$params)
		{
            global $wpdb, $cp_appb_plugin;

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

            $pro_item_name = $cp_appb_plugin->get_option('product_name', 'Booking');
            foreach ($params as $item => $value)
                $pro_item_name = str_replace('<%'.$item.'%>',(is_array($value)?(implode(", ",$value)):($value)),$pro_item_name);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID || floatval($params["final_price"]) == 0)
			    return;
            $sequence = $params["itemnumber"];
            $timestamp = time();

?>
        <html>
        <head><title>Redirecting to Skrill...</title></head>
        <body>
<form name="ppform3" action="https://pay.skrill.com" method="post">
 <input type="hidden" name="pay_to_email" value="<?php echo $rows[0]->Skrill_api_username; ?>">
 <input type="hidden" name="recipient_description" value="<?php echo $pro_item_name; ?>">
 <input type="hidden" name="return_url" value="<?php echo $cp_appb_plugin->get_option('fp_return_page', $cp_appb_plugin->get_site_url()); ?>">
 <input type="hidden" name="cancel_url" value="<?php echo $rows[0]->x_cancel_url; ?>">
 <input type="hidden" name="status_url" value="<?php echo $cp_appb_plugin->get_site_url().'/?cp_appbskrill_ipncheck='.$params[ 'itemnumber' ]; ?>">
 <input type="hidden" name="language" value="EN">
 <input type="hidden" name="transaction_id" value="APPB-<?php echo $params["itemnumber"]; ?>">
 <input type="hidden" name="merchant_fields" value="customer_number,item_id,item_name">
 <input type="hidden" name="customer_number" value="<?php echo $user; ?>">
 <input type="hidden" name="item_id" value="<?php echo $params["itemnumber"]; ?>" />
 <input type="hidden" name="item_name" value="<?php echo $cp_appb_plugin->get_option('product_name', 'Booking'); ?>">
 <input type="hidden" name="amount" value="<?php echo $params["final_price"]; ?>">
 <input type="hidden" name="currency" value="<?php echo $rows[0]->currency; ?>">
 <input type="hidden" name="detail1_description" value="<?php echo $cp_appb_plugin->get_option('product_name', 'Booking'); ?>">
 <input type="hidden" name="detail1_text" value="">
 <!--<input type="hidden" name="payment_methods" value="<?php if (@$_GET["c"] == '1') echo "ACC,GLU"; else echo "GLU,ACC"; ?>">-->
</form>
<script type="text/javascript">
document.ppform3.submit();
</script>
        </body>
        </html>
<?php



            exit;
		} // end pp_Skrill


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}

		public function pp_Skrill_update_status( )
		{
            global $wpdb, $cp_appb_plugin;


            if (!isset($_GET["cp_appbskrill_ipncheck"]) || !intval($_GET["cp_appbskrill_ipncheck"]))
                return;
            
            $itemnumber = intval($_GET["cp_appbskrill_ipncheck"]);   
            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $itemnumber) );

			if (empty( $myrows ))
			    return;

            if ($_POST['status'] != "2")
            {
                echo 'Transaction failed.';
                exit();
            }
            
            $params = unserialize($myrows->posted_data);
            $params["paid"] = '1';
            $params["payment_type"] = "Skrill";
            $wpdb->query( $wpdb->prepare("UPDATE  ".$wpdb->prefix.$cp_appb_plugin->table_messages." SET posted_data=%s WHERE id=%d", serialize($params), $itemnumber) );
            $cp_appb_plugin->update_status($itemnumber, $cp_appb_plugin->get_option('defaultpaidstatus', '') );
            
            if (!count($myrows))
                $cp_appb_plugin->ready_to_go_reservation($itemnumber, "", $params);         

            echo 'OK';
            exit ();

		}


    } // End Class

    // Main add-on code
    $cpappb_Skrill_obj = new CPAPPB_Skrill();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $cpappb_Skrill_obj->get_addon_id() ] = $cpappb_Skrill_obj;
}

