<?php
/*
....
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_SMSBroadcast' ) )
{
    class CPAPPB_SMSBroadcast extends CPAPPB_BaseAddon
    {
        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-SMSBroadcast-20170403";
		protected $name = "SMSBroadcast.com.au";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;

			// Insertion in database
			if( isset( $_REQUEST[ 'apphbSMSBroadcast' ] ) )
			{
				$wpdb->delete( $wpdb->prefix.$this->form_SMSBroadcast_table, array( 'formid' => $form_id ), array( '%d' ) );

				$active = ($_REQUEST['apphbSMSBroadcast_active']) ? 1 : 0;

				$settings = array();
                if(isset($_REQUEST['apphbSMSBroadcast_stripfirstzero'])) $settings['stripfirstzero'] = trim($_REQUEST['apphbSMSBroadcast_stripfirstzero']);
				if(isset($_REQUEST['apphbSMSBroadcast_sid'])) $settings['sid'] = trim($_REQUEST['apphbSMSBroadcast_sid']);
				if(isset($_REQUEST['apphbSMSBroadcast_auth'])) $settings['auth'] = trim($_REQUEST['apphbSMSBroadcast_auth']);
				if(isset($_REQUEST['apphbSMSBroadcast_from'])) $settings['from'] = trim($_REQUEST['apphbSMSBroadcast_from']);
				if(isset($_REQUEST['apphbSMSBroadcast_to_website'])) $settings['to_website'] = trim($_REQUEST['apphbSMSBroadcast_to_website']);
				if(isset($_REQUEST['apphbSMSBroadcast_to_users'])) $settings['to_users'] = trim($_REQUEST['apphbSMSBroadcast_to_users']);
                if(isset($_REQUEST['apphbSMSBroadcast_to_usersprefix'])) $settings['to_usersprefix'] = trim($_REQUEST['apphbSMSBroadcast_to_usersprefix']);                
				if(isset($_REQUEST['apphbSMSBroadcast_mssg_website'])) $settings['mssg_website'] = trim($_REQUEST['apphbSMSBroadcast_mssg_website']);
				if(isset($_REQUEST['apphbSMSBroadcast_mssg_users'])) $settings['mssg_users'] = trim($_REQUEST['apphbSMSBroadcast_mssg_users']);

				$wpdb->insert(
					$wpdb->prefix.$this->form_SMSBroadcast_table,
					array(
						'formid' => $form_id,
						'active' => $active,
						'data'	 => serialize($settings)
					),
					array( '%d', '%d', '%s' )
				);
			}

			$row = $wpdb->get_row(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_SMSBroadcast_table." WHERE formid=%d", $form_id )
					);

			if(!empty($row))
			{
				$active = $row->active;
				$settings = unserialize($row->data);
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
					<table style="width:100%;" cellspacing="3">
						<tr>
							<td style="white-space:nowrap;width:100px;"><?php _e('SMSBroadcast enabled','appointment-hour-booking'); ?>:</td>
							<td><input type="checkbox" name="apphbSMSBroadcast_active" <?php print (isset($settings) && !empty($active)) ? 'CHECKED' : ''; ?> /></td>
						</tr>
						<tr>
							<td style="white-space:nowrap;width:100px;"><a href="https://www.smsbroadcast.com.au/" target="_blank">SMSBroadcast</a> <?php _e('Account username','appointment-hour-booking'); ?>:</td>
							<td><input type="text" name="apphbSMSBroadcast_sid" value="<?php print esc_attr((isset($settings) && !empty($settings['sid'])) ? trim($settings['sid']) : ''); ?>" size="70" /></td>
						</tr>
						<tr>
							<td style="white-space:nowrap;width:100px;"><a href="https://www.smsbroadcast.com.au/" target="_blank">SMSBroadcast</a> <?php _e('Account password','appointment-hour-booking'); ?>:</td>
							<td><input type="text" name="apphbSMSBroadcast_auth" value="<?php print esc_attr((isset($settings) && !empty($settings['auth'])) ? trim($settings['auth']) : ''); ?>" size="70" /></td>
						</tr>
						<tr>
							<td style="white-space:nowrap;width:100px;"><?php _e('From (source) Name or Phone Number','appointment-hour-booking'); ?>:</td>
							<td><input type="text" name="apphbSMSBroadcast_from" value="<?php print esc_attr((isset($settings) && !empty($settings['from'])) ? trim($settings['from']) : ''); ?>" size="70" /></td>
						</tr>
						<tr><td colspan="2"><hr /></td></tr>
						<tr>
							<td style="white-space:nowrap;width:100px;"><?php _e('To Phone Number','appointment-hour-booking'); ?>:</td>
							<td>
								<input type="text" name="apphbSMSBroadcast_to_website" value="<?php print esc_attr((isset($settings) && !empty($settings['to_website'])) ? trim($settings['to_website']) : ''); ?>" size="70" /><br />
								<i><?php _e('For sending multiple messages, separate the phone numbers by comma symbols.'); ?></i>
							</td>
						</tr>
						<tr>
							<td style="white-space:nowrap;width:100px;" valign="top"><?php _e('Message','appointment-hour-booking'); ?>:</td>
							<td>
								<textarea name="apphbSMSBroadcast_mssg_website" cols="80" rows="6" style="resize:both;"><?php print esc_textarea((isset($settings) && !empty($settings['mssg_website'])) ? trim($settings['mssg_website']) : ''); ?></textarea><br />
								<i><?php _e('It is possible to use the same <a href="https://apphourbooking.dwbooster.com/faq#q507" target="_blank">special tags</a> than in notifications emails.', 'appointment-hour-booking'); ?></i>
							</td>
						</tr>
						<tr><td colspan="2"><hr /></td></tr>
						<tr><td colspan="2"><h2><?php _e('Copy to the users', 'appointment-hour-booking'); ?></h2></td></tr>
						<tr>
							<td style="white-space:nowrap;width:100px;"><?php _e('To Phone fields','appointment-hour-booking'); ?>:</td>
							<td>
								<input type="text" name="apphbSMSBroadcast_to_users" value="<?php print esc_attr((isset($settings) && !empty($settings['to_users'])) ? trim($settings['to_users']) : ''); ?>" placeholder="fieldname#" size="70" /><br />
								<i><?php _e('For sending multiple messages, separate the phone fields by comma symbols.'); ?></i>
							</td>
						</tr>
						<tr>
							<td style="white-space:nowrap;width:100px;"><?php _e('Add the following country code to all customer phone numbers','appointment-hour-booking'); ?>:</td>
							<td>
								<input type="text" name="apphbSMSBroadcast_to_usersprefix" value="<?php print esc_attr((isset($settings) && !empty($settings['to_usersprefix'])) ? trim($settings['to_usersprefix']) : ''); ?>" size="10" /><br />
								<i><?php _e('Use this <strong>only</strong> if all your customers are from the same country and you don\'t request the country code in the phone number field.'); ?></i>
							</td>
						</tr>            
						<tr>
							<td style="white-space:nowrap;width:100px;"><?php _e('Strip first zero from the phone number?','appointment-hour-booking'); ?>:</td>
							<td>
                            <?php $stripzero = ((isset($settings) && !empty($settings['stripfirstzero'])) ? trim($settings['stripfirstzero']) : ''); ?>
								<select name="apphbSMSBroadcast_stripfirstzero">
                                  <option <?php if ($stripzero) echo ' selected '; ?> value="yes">Yes</option>
                                  <option <?php if (!$stripzero) echo ' selected '; ?> value="">No</option>
                                </select>								
							</td>
						</tr>                          
						<tr>
							<td style="white-space:nowrap;width:100px;" valign="top"><?php _e('Message','appointment-hour-booking'); ?>:</td>
							<td>
								<textarea name="apphbSMSBroadcast_mssg_users" cols="80" rows="6" style="resize:both;"><?php print esc_textarea((isset($settings) && !empty($settings['mssg_users'])) ? trim($settings['mssg_users']) : ''); ?></textarea><br />
								<i><?php _e('It is possible to use the same <a href="https://apphourbooking.dwbooster.com/faq#q507" target="_blank">special tags</a> than in notifications emails.', 'appointment-hour-booking'); ?></i>
							</td>
						</tr>
					</table>
				</div>
				<input type="hidden" name="apphbSMSBroadcast" value="1" />
			</div>
			<?php
		}

		/************************ ADDON CODE *****************************/
        /************************ ATTRIBUTES *****************************/

		private $form_SMSBroadcast_table = 'cpappbk_SMSBroadcast';
		private $_sid;
		private $_auth;
		private $_from;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on allows to send notification messages (SMS) via SMSBroadcast.com.au after submitting the form", 'appointment-hour-booking');

            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

			// Export the lead
			add_action( 'cpappb_process_data', array( &$this, 'put_data' ) );
            
            add_action( 'cpahb_reminder_sent', array( &$this, 'pp_SMSBroadcast_send' ), 10, 1 );
            
            $this->update_database();

        } // End __construct

        /************************ PROTECTED METHODS *****************************/

		/**
         * Creates the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_SMSBroadcast_table." (
					formid INT NOT NULL,
					active INT NOT NULL DEFAULT 0,
					data TEXT,
					UNIQUE KEY formid (formid)
				) $charset_collate;";

			$wpdb->query($sql);
		} // End update_database

        /************************ PRIVATE METHODS *****************************/

		/**
		 * Checks the format of phone's number and transform it is needed
		 */
		private function _phone_number($phone)
		{
			$phone = preg_replace('/[^\d\+]/', '', $phone); 
			$phone = preg_replace('/^00/', '+', $phone);
			if(preg_match('/^\+?[0-9]\d{1,14}$/', $phone)) return $phone;
			return false;
		} // End _validate_phone_number

		/**
		 * Cuts the message to 160 characters
		 */
		private function _message($mssg)
		{
			return substr($mssg, 0, 160);
		} // End _message

		/**
		 * Sends the SMS using SMSBroadcast
		 */
		private function _send_sms($to, $mssg)
		{
			$to = explode(',', $to);
			$mssg = $this->_message($mssg);       
			foreach($to as $phone)
			{
				$phone = $this->_phone_number($phone);             
				if(!empty($phone))
				{
					$content =  'username='.rawurlencode($this->_sid).
                                '&password='.rawurlencode($this->_auth).
                                '&to='.rawurlencode($phone).
                                '&from='.rawurlencode($this->_from).
                                '&message='.rawurlencode($mssg).
                                '&ref='.rawurlencode($params["itemnumber"]."sms".mt_rand(100000,999999));

                    $ch = curl_init('https://api.smsbroadcast.com.au/api-adv.php');
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $content);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    $output = curl_exec ($ch);
                    curl_close ($ch);

					if(false)
					{
                        $response_lines = explode("\n", $output);
						foreach( $response_lines as $data_line){
                            $message_data = "";
                            $message_data = explode(':',$data_line);
                            if($message_data[0] == "OK"){
                                echo "The message to ".$message_data[1]." was successful, with reference ".$message_data[2]."\n";
                            }elseif( $message_data[0] == "BAD" ){
                                echo "The message to ".$message_data[1]." was NOT successful. Reason: ".$message_data[2]."\n";
                            }elseif( $message_data[0] == "ERROR" ){
                                echo "There was an error with this request. Reason: ".$message_data[1]."\n";
                            }                            
                        }
                        exit;
					}
				}
			}
		} // End send_sms

		/************************ PUBLIC METHODS  *****************************/

        
		/**
         * Send SMS Reminder
         */
		public function pp_SMSBroadcast_send( $params  )
		{
            global $wpdb, $cp_appb_plugin;
 
            $formid = $params["formid"];
            $slot = $params["slot"];
            $params = $params["params"];
        
            $row = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_SMSBroadcast_table." WHERE formid=%d", $formid ) ); 
            if (empty($row->data))
                return;
            $data = unserialize($row->data);
            $this->_sid   = (isset($data['sid']))  ? trim($data['sid'])  : '';
		    $this->_auth  = (isset($data['auth'])) ? trim($data['auth']) : '';
		    $this->_from  = (isset($data['from'])) ? trim($data['from']) : '';
            
            $email_content_customer = $data['mssg_users'];          
            $email_content_customer = str_replace('<'.'%', '%', $email_content_customer);
            $email_content_customer = str_replace('%'.'>', '%', $email_content_customer);
            $email_content_customer = str_replace('%SMSDATE%', $slot["date"]." ".$slot["slot"], $email_content_customer);
            $email_content_customer = str_replace('%itemnumber%', $params["itemnumber"], $email_content_customer);
            
            $to_users   = (isset($data['to_users'])) 	? trim($data['to_users']) 	: '';
            
            foreach ($params as $item=> $value)
            {
                $to_users = str_replace('<%'.$item.'%>', $value, $to_users);
                $to_users = str_replace('%'.$item.'%', $value, $to_users);
                $email_content_customer = str_replace('%'.$item.'%',(is_array($value)?(implode(", ",$value)):($value)),$email_content_customer); 
            }
            for ($kit=0;$kit<500;$kit++)
                $email_content_customer = str_replace('%fieldname'.$kit.'%',"",$email_content_customer);                                                           
            $to_users = trim($to_users);            
            // Step 3: instantiate a new Client
            $this->_send_sms ($data['to_usersprefix'].($data["stripfirstzero"]?ltrim($to_users,'0'):$to_users), $email_content_customer);
               
         
		}        
        
		/**
         * Send message to SMSBroadcast
         */
        public function	put_data( $params )
		{
			global $wpdb;

			$form_id = @intval( $params[ 'formid' ] );
			$itemnumber = @intval( $params[ 'itemnumber' ] );

			if( $form_id && $itemnumber )
			{
				$row = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_SMSBroadcast_table." WHERE formid=%d", $form_id ) );

				if(!empty($row) && ($row->active == '1' || $row->active == 1))
				{
					// Clean data
					foreach( $params as $key => $val )
					{
						try
						{
							$tmp = @json_decode( $val );
							if( !empty($tmp) ) $params[ $key ] = $tmp;
						}
						catch( Exception $err )
						{

						}
					}

					if(
						!empty($row->data) &&
						($data = unserialize($row->data)) !== false
					)
					{
						$this->_sid   = (isset($data['sid']))  ? trim($data['sid'])  : '';
						$this->_auth  = (isset($data['auth'])) ? trim($data['auth']) : '';
						$this->_from  = (isset($data['from'])) ? trim($data['from']) : '';

						if(!empty($this->_sid))
						{

							$to_website = (isset($data['to_website'])) ? trim($data['to_website']) : '';
							$mssg_website   = (isset($data['mssg_website'])) ? trim($data['mssg_website']) : '';

							if(!empty($to_website) && !empty($mssg_website))
							{
                                foreach ($params as $item => $value)
                                {
                                    $to_website = str_replace('<%'.$item.'%>', $value, $to_website);
                                    $mssg_website = str_replace('<%'.$item.'%>', $value, $mssg_website);
                                    $to_website = str_replace('%'.$item.'%', $value, $to_website);
                                    $mssg_website = str_replace('%'.$item.'%', $value, $mssg_website);
                                    $to_website = str_replace(''.$item.'', $value, $to_website);
                                    $mssg_website = str_replace(''.$item.'', $value, $mssg_website);
                                }

								$this->_send_sms(
									$to_website,
									$mssg_website
								);
							}

							$to_users   = (isset($data['to_users'])) 	? trim($data['to_users']) 	: '';
							$mssg_users = (isset($data['mssg_users'])) 	? trim($data['mssg_users']) : '';

							if(!empty($to_users) && !empty($mssg_users))
							{
                                foreach ($params as $item => $value)
                                {
                                    $to_users = str_replace('%'.$item.'%', $value, $to_users);
                                    $mssg_users = str_replace('%'.$item.'%', $value, $mssg_users);
                                    $to_users = str_replace(''.$item.'', $value, $to_users);
                                    $mssg_users = str_replace(''.$item.'', $value, $mssg_users);
                                }
								$this->_send_sms(
									$data['to_usersprefix'].($data["stripfirstzero"]?ltrim($to_users,'0'):$to_users),
									$mssg_users
								);
							}
						}
					}
				}
			}
		} // End export_lead



    } // End Class

    // Main add-on code
    $apphbSMSBroadcast_obj = new CPAPPB_SMSBroadcast();

    global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $apphbSMSBroadcast_obj->get_addon_id() ] = $apphbSMSBroadcast_obj;
}
?>