<?php
/*

*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_StatusUpdateEmails' ) )
{
    class CPAPPB_StatusUpdateEmails extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-StatusUpdateEmails-20170903";
		protected $name = "Status Modification Emails";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_statusupemails_id' ] )
			)
			{
                $emails = array();
                $counter = 0;
                while (isset($_POST["stupemail_c".$counter]))
                {
                    $emails[$_POST["stupemail_c".$counter]] = array (
                                               'adminformat' => $_POST["stupemail_admin_emailformat".$counter],
                                               'adminsubject' => $_POST["stupemail_subject_to_admin".$counter],
                                               'admincontent' => $_POST["stupemail_content_to_admin".$counter],
                                               'customerformat' => $_POST["stupemail_customer_emailformat".$counter],
                                               'customersubject' => $_POST["stupemail_subject_to_customer".$counter],
                                               'customercontent' => $_POST["stupemail_content_to_customer".$counter],
                                             );
                    $counter++;
                }
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,             
                                    'stupemail_emails'	 => serialize($emails)
								),
								array( '%d', '%s' )
							);
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
                    
			if (!count($rows))
			{
                // generate base emails
                $emails = array();
                $statuses = $cp_appb_plugin->get_status_list();                
                foreach ($statuses as $status)
                {
                    $emails[$status] = array (
                                               'adminformat' => '',
                                               'adminsubject' => 'Booking status changed to: '. $status,
                                               'admincontent' => 'The booking #%itemnumber% status has been changed to: '. $status,
                                               'customerformat' => '',
                                               'customersubject' => 'Booking status changed to: '. $status,
                                               'customercontent' => 'The booking #%itemnumber% status has been changed to: '. $status,
                                             );
                }
                $wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,             
                                    'stupemail_emails'	 => serialize($emails)
								),
								array( '%d', '%s' )
							);
			} else {
                $emails = unserialize($rows[0]->stupemail_emails);
                $statuses = $cp_appb_plugin->get_status_list(); 
                foreach ($statuses as $status)
                    if (!isset($emails[$status]))
                    {
                        $emails[$status] = array (
                                                   'adminformat' => '',
                                                   'adminsubject' => 'Booking status changed to: '. $status,
                                                   'admincontent' => 'The booking #%itemnumber% status has been changed to: '. $status,
                                                   'customerformat' => '',
                                                   'customersubject' => 'Booking status changed to: '. $status,
                                                   'customercontent' => 'The booking #%itemnumber% status has been changed to: '. $status,
                                                 );
                    }
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_statusupemails_id" value="1" />
                   <div id="stupemailcontent_no"style="display:none">
                         &raquo; <a href="javascript:appbk_stupdate_display_emails(true);">Display Email Contents</a>
                   </div>
                   <div id="stupemailcontent_yes">
                        <!-- &raquo; <a href="javascript:appbk_stupdate_display_emails(false);">Hide Email Contents</a> -->
                     <p>These emails are sent when the status is changed from the <a href="?page=cp_apphourbooking&cal=<?php echo $form_id; ?>&list=1">booking orders list</a>.<p>
                     <p>You can use the <a target="_blank" href="https://apphourbooking.dwbooster.com/faq#q507">supported tags for emails</a> into the email content.</p> 
                     <p>To don't send one of the following emails leave the subject line empty, this way the email notification will be ignored.</p> 
                     
                     <?php 
                        $counter = -1;
                        foreach ($emails as $status => $email)  { 
                            $counter++;
                     ?>    
                       <table width="100%" cellspacing="5" cellpadding="5">
                        <tr>
                         <th colspan="2" style="background-color:#dddddd;">On Status changed to: <span style="color:#4444ff"><?php echo $status?></span></th>            
                        </tr> 
                        <tr>
                         <th style="background-color:#eeeeee;">Email to administrator</th>
                         <th style="background-color:#eeeeee;">Email to customer</th>
                        </tr> 
                        <tr>
                         <td>
                           <strong>Email format?:</strong><br />
                           <?php $option = $email['adminformat']; ?>
                           <select name="stupemail_admin_emailformat<?php echo $counter; ?>">
                            <option value="text"<?php if ($option != 'html') echo ' selected'; ?>>Plain Text (default)</option>
                            <option value="html"<?php if ($option == 'html') echo ' selected'; ?>>HTML (use html in the textarea below)</option>
                           </select><br />
                           <input type="hidden" name="stupemail_c<?php echo $counter; ?>" value="<?php echo esc_attr($status); ?>">
                           <strong>Email subject (to admin):</strong><br />
                           <input style="width:100%" type="text" name="stupemail_subject_to_admin<?php echo $counter; ?>"   value="<?php $text = esc_attr($email['adminsubject']); echo $text; ?>" /><br />                         
                           <strong>Email content (to admin):</strong><br />
                           <textarea style="width:100%" rows="3" name="stupemail_content_to_admin<?php echo $counter; ?>"><?php $text = $email['admincontent']; echo $text; ?></textarea><br />
                         </td>
                         <td>
                          <strong>Email format?:</strong><br />
                          <?php $option = $email['customerformat']; ?>
                          <select name="stupemail_customer_emailformat<?php echo $counter; ?>">
                           <option value="text"<?php if ($option != 'html') echo ' selected'; ?>>Plain Text (default)</option>
                           <option value="html"<?php if ($option == 'html') echo ' selected'; ?>>HTML (use html in the textarea below)</option>
                          </select><br />
                          <strong>Email subject (to customer):</strong><br />
                          <input style="width:100%" type="text" name="stupemail_subject_to_customer<?php echo $counter; ?>" value="<?php $text = esc_attr($email['customersubject']); echo $text; ?>" /><br />                         
                          <strong>Email content (to customer):</strong><br />
                          <textarea style="width:100%" rows="3" name="stupemail_content_to_customer<?php echo $counter; ?>"><?php $text = $email['customercontent']; echo $text; ?></textarea><br />
                         </td> 
                        </tr> 
                       </table> 
                     <?php } ?>  
                         
                   </div>
                   <script type="text/javascript">
                       function appbk_stupdate_display_emails(dodisplay) 
                       {
                           document.getElementById("stupemailcontent_no").style.display = 'none';
                           document.getElementById("stupemailcontent_yes").style.display = 'none';
                           if (dodisplay) 
                               document.getElementById("stupemailcontent_yes").style.display = '';
                           else
                               document.getElementById("stupemailcontent_no").style.display = '';
                       }
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_statusupemails';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on allows to define emails to be sent when the booking status is changed from the bookings list", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
             
			add_action( 'cpappb_update_status', array( &$this, 'pp_StatusUpdateEmails_update_status' ), 10, 2 );

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    stupemail_emails mediumtext,
					UNIQUE KEY id (id)
				) $charset_collate;";

			$wpdb->query($sql);
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}

        
		public function pp_StatusUpdateEmails_update_status($itemnumber, $status)
		{
            global $wpdb, $cp_appb_plugin; 
            
            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $itemnumber) );
            
            $cp_appb_plugin->setId($myrows[0]->formid);
            
            $settings = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $myrows[0]->formid )
					);
            $emails = unserialize($settings[0]->stupemail_emails);
            
            if ($status == '')
                $status = 'Approved';
            if (!isset($emails[$status]))
                return;
            $email = $emails[$status];
            

            $email_content_admin = $email["admincontent"];
            $email_content_customer = $email["customercontent"];           
            $email_subject_admin = $email["adminsubject"];
            $email_subject_customer = $email["customersubject"];

            $email_content_admin = str_replace('<'.'%', '%', $email_content_admin);
            $email_content_customer = str_replace('<'.'%', '%', $email_content_customer);
            $email_content_admin = str_replace('%'.'>', '%', $email_content_admin);
            $email_content_customer = str_replace('%'.'>', '%', $email_content_customer);
            
            $email_subject_admin = str_replace('<'.'%', '%', $email_subject_admin);
            $email_subject_customer = str_replace('<'.'%', '%', $email_subject_customer);
            $email_subject_admin = str_replace('%'.'>', '%', $email_subject_admin);
            $email_subject_customer = str_replace('%'.'>', '%', $email_subject_customer);
            
            $email_content_admin = str_replace('%INFO%', $myrows[0]->data, $email_content_admin);
            $email_content_customer = str_replace('%INFO%', $myrows[0]->data, $email_content_customer);
            $email_content_admin = str_replace('%itemnumber%', $itemnumber, $email_content_admin);
            $email_content_customer = str_replace('%itemnumber%', $itemnumber, $email_content_customer);
            
            $email_subject_admin = str_replace('%INFO%', $myrows[0]->data, $email_subject_admin);
            $email_subject_customer = str_replace('%INFO%', $myrows[0]->data, $email_subject_customer);
            $email_subject_admin = str_replace('%itemnumber%', $itemnumber, $email_subject_admin);
            $email_subject_customer = str_replace('%itemnumber%', $itemnumber, $email_subject_customer);
               
            $data = unserialize($myrows[0]->posted_data);   
            foreach ($data as $item => $value)
            {
                $email_content_admin = str_replace('%'.$item.'%',(is_array($value)?(implode(", ",$value)):($value)),$email_content_admin);
                $email_content_customer = str_replace('%'.$item.'%',(is_array($value)?(implode(", ",$value)):($value)),$email_content_customer);
                $email_subject_admin = str_replace('%'.$item.'%',(is_array($value)?(implode(", ",$value)):($value)),$email_subject_admin);
                $email_subject_customer = str_replace('%'.$item.'%',(is_array($value)?(implode(", ",$value)):($value)),$email_subject_customer);
            }
        
            for ($i=0;$i<500;$i++)
            {
                $email_content_admin = str_replace('%fieldname'.$i.'%',"",$email_content_admin);   
                $email_content_customer = str_replace('%fieldname'.$i.'%',"",$email_content_customer);  
                $email_subject_admin = str_replace('%fieldname'.$i.'%',"",$email_subject_admin);   
                $email_subject_customer = str_replace('%fieldname'.$i.'%',"",$email_subject_customer);  
            }  
            
            $email_content_customer = $cp_appb_plugin->replace_tags($email_content_customer, $data);
            $email_content_admin = $cp_appb_plugin->replace_tags($email_content_admin, $data);
            $email_subject_customer = $cp_appb_plugin->replace_tags($email_subject_customer, $data);
            $email_subject_admin = $cp_appb_plugin->replace_tags($email_subject_admin, $data);
            
            $attachments = array();
            $attachments = apply_filters( 'cpappb_email_attachments',  $attachments, $data, $cp_appb_plugin->getId());            
              
            $from = $cp_appb_plugin->get_option('fp_from_email', @CP_APPBOOK_DEFAULT_fp_from_email);
            $to = explode(",",$cp_appb_plugin->get_option('fp_destination_emails', @CP_APPBOOK_DEFAULT_fp_destination_emails));
            $to = array_unique ($to);
            if (!strpos($from,">"))
                $from = '"'.$from.'" <'.$from.'>';  
            
            if ('html' == $email["adminformat"]) $content_type = "Content-Type: text/html; charset=utf-8\n"; else $content_type = "Content-Type: text/plain; charset=utf-8\n";
            if ($email_subject_admin)
                foreach ($to as $item)
                    if (trim($item) != '')              
                        wp_mail(trim($item), $email_subject_admin, $email_content_admin,
                            "From: ".$from."\r\n". 
                           $content_type.
                           "X-Mailer: PHP/" . phpversion(),$attachments);
            
            // send email to customer
            $to = $myrows[0]->notifyto;
            if ('html' == $email["customerformat"]) $content_type = "Content-Type: text/html; charset=utf-8\n"; else $content_type = "Content-Type: text/plain; charset=utf-8\n";
      
            if ( 
                 $email_subject_customer && 
                 $to != $cp_appb_plugin->blocked_by_admin_indicator &&
                 apply_filters( 'cpappb_status_update_email_customer', true, $to, $email_subject_customer, $email_content_customer, $myrows[0]->whoadded, $data ) 
               )
                wp_mail(trim($to), $email_subject_customer, $email_content_customer,
                    "From: ".$from."\r\n".
                    $content_type.
                    "X-Mailer: PHP/" . phpversion(),$attachments);
                                   
            do_action( 'cpappb_update_status_email_addon', $itemnumber, $status );                        
        }


    } // End Class

    // Main add-on code
    $cpappb_StatusUpdateEmails_obj = new CPAPPB_StatusUpdateEmails();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $cpappb_StatusUpdateEmails_obj->get_addon_id() ] = $cpappb_StatusUpdateEmails_obj;
}

