<?php
/*
Documentation: https://www.targetpay.com/docs/TargetPay_iDEAL_V3.0_en.pdf
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_iDealTargetPay' ) )
{
    class CPAPPB_iDealTargetPay extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-idealtargetpay-20151212";
		protected $name = "iDeal TargetPay";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_iDealTargetPay_id' ] )
			)
			{
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									'idealtargetpay_api_username'	 => $_REQUEST["idealtargetpay_api_username"],
									'mode'	 => $_REQUEST["mode"],
									'return_error'	 => $_REQUEST["return_error"],
									'enabled'	 => $_REQUEST["targetpay_enabled"]
								),
								array( '%d', '%s', '%s', '%s', '%s')
							);
			}


			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["idealtargetpay_api_username"] = "";
			    $row["mode"] = "";
			    $row["return_error"] = "";
			    $row["enabled"] = "0";
			} else {
			    $row["idealtargetpay_api_username"] = $rows[0]->idealtargetpay_api_username;
			    $row["mode"] = $rows[0]->mode;
			    $row["return_error"] = $rows[0]->return_error;
			    $row["enabled"] = $rows[0]->enabled;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_iDealTargetPay_id" value="1" />
                   <table class="form-table">
                    <tr valign="top">
                    <th scope="row"><?php _e('Enable iDeal-TargetPay?', 'appointment-hour-booking'); ?></th>
                    <td><select name="targetpay_enabled">
                         <option value="0" <?php if (!$row["enabled"]) echo 'selected'; ?>><?php _e('No', 'appointment-hour-booking'); ?></option>
                         <option value="1" <?php if ($row["enabled"]) echo 'selected'; ?>><?php _e('Yes', 'appointment-hour-booking'); ?></option>
                         <option value="2" <?php if ($row["enabled"] == '2') echo 'selected'; ?>><?php _e('Optional: This payment method + Pay Later (submit without payment)', 'appointment-hour-booking'); ?></option>
                         <option value="3" <?php if ($row["enabled"] == '3') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods (enabled)', 'appointment-hour-booking'); ?></option>
                         <option value="4" <?php if ($row["enabled"] == '4') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods  + Pay Later ', 'appointment-hour-booking'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('RTLO Subaccount ID', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="idealtargetpay_api_username" size="20" value="<?php echo esc_attr($row["idealtargetpay_api_username"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('If payment fails return to this page', 'appointment-hour-booking'); ?></th>
                    <td><input type="text" name="return_error" size="20" value="<?php echo esc_attr($row["return_error"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Payments Mode', 'appointment-hour-booking'); ?></th>
                    <td><select name="mode">
                         <option value="1" <?php if ($row["mode"]) echo 'selected'; ?>><?php _e('Test Mode', 'appointment-hour-booking'); ?></option>
                         <option value="0" <?php if (!$row["mode"]) echo 'selected'; ?>><?php _e('Production - Real Payments', 'appointment-hour-booking'); ?></option>
                         </select>
                    </td>
                    </tr>
                   </table>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_idealtargetpay';
        private $_inserted = false;
		private $_apphbmain;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on adds support for iDeal via TargetPay payments", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            if (!is_admin())
            {
			    add_action( 'cpappb_process_data_before_insert', array( &$this, 'pp_before_insert' ), 10, 1 );

			    add_action( 'cpappb_process_data', array( &$this, 'pp_idealtargetpay' ), 11, 1 );

			    add_action( 'init', array( &$this, 'pp_idealtargetpay_update_status' ), 10, 0 );
			    add_action( 'init', array( &$this, 'pp_idealtargetpay_return_page' ), 10, 0 );

			    add_filter( 'cpappb_the_form', array( &$this, 'insert_payment_fields'), 99, 2 );
            }
			else
			{
				// Delete forms
				add_action( 'apphb_delete_form', array(&$this, 'delete_form') );

				// Clone forms
				add_action( 'apphb_clone_form', array(&$this, 'clone_form'), 10, 2 );

				// Export addon data
				add_action( 'apphb_export_addons', array(&$this, 'export_form'), 10, 2 );

				// Import addon data
				add_action( 'apphb_import_addons', array(&$this, 'import_form'), 10, 2 );
			}
            
            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb, $cp_appb_plugin;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
					enabled varchar(10) DEFAULT '0' NOT NULL ,
					idealtargetpay_api_username varchar(255) DEFAULT '' NOT NULL ,
					mode varchar(10) DEFAULT '' NOT NULL ,
					return_error varchar(250) DEFAULT '' NOT NULL ,
					enable_option_yes varchar(255) DEFAULT '' NOT NULL ,
                    enable_option_no varchar(255) DEFAULT '' NOT NULL ,
                    enable_option_paypal varchar(255) DEFAULT '' NOT NULL ,
					UNIQUE KEY id (id)
				) $charset_collate;";
				//  idealtargetpay_api_signature varchar(255) DEFAULT '' NOT NULL ,
				//	currency varchar(255) DEFAULT '' NOT NULL ,

			$wpdb->query($sql);
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/

		/**
         * process before insert
         */
		public function pp_before_insert(&$params )
		{
            global $wpdb, $cp_appb_plugin;

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID)
			    return;

			$params["payment_option"] = $this->name;

	    }


		/**
         * Inserts banks and Check if the Optional is enabled in the form, and inserts radiobutton
         */
        public function	insert_payment_fields( $form_code, $id )
		{
            global $wpdb, $cp_appb_plugin;

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return $form_code;

			$url="https://www.targetpay.com/ideal/getissuers?ver=3&format=html";
            $strResponse = $this->httpGetRequest($url);
			//$strResponse = '<option selected value="">Kies uw bank...</option><option value="ABNANL2A">ABN AMRO</option><option value="ASNBNL21">ASN Bank</option><option value="BUNQNL2A">bunq</option><option value="INGBNL2A">ING</option><option value="KNABNL2H">Knab</option><option value="RABONL2U">Rabobank</option><option value="RBRBNL21">RegioBank</option><option value="SNSBNL2A">SNS Bank</option><option value="TRIONL2U">Triodos Bank</option><option value="FVLBNL22">van Lanschot</option>';
            $strResponse = str_replace('<option selected value="">Kies uw bank...</option>','',$strResponse);

            $checkscript = '<script type="text/javascript">function apphbaddonidealtargetpay'.$id.'(){ try { if(document.getElementById("apphbaddonidtp'.$id.'").checked) document.getElementById("opfield'.$this->addonID.$id.'").style.display=""; else document.getElementById("opfield'.$this->addonID.$id.'").style.display="none"; } catch (e) {} }setInterval("apphbaddonidealtargetpay'.$id.'()",200);</script>';
			$code = "<div id=\"opfield".$this->addonID.$id."\"><div class=\"fields\"><label>Kies uw bank</label><div class=\"nodfield\"><select name=\"bank\">".$strResponse."</select></div></div></div>".$checkscript;

			$form_code = preg_replace( '/<!--addons-payment-fields-->/i', '<!--addons-payment-fields-->'.$code, $form_code );

			// output radio-buttons here
			$form_code = preg_replace( '/<!--addons-payment-options-->/i', '<div><input type="radio" name="bccf_payment_option_paypal" id="apphbaddonidtp'.$id.'" vt="'.$this->addonID.'" value="'.$this->addonID.'" checked> '.__('Pay with iDeal/TargetPay', 'appointment-hour-booking').'</div><!--addons-payment-options-->', $form_code );

            if (($rows[0]->enabled == '2' || $rows[0]->enabled == '4') && !strpos($form_code,'bccf_payment_option_paypal" vt="0') )
			    $form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" vt="0" value="0"> '.__( $cp_appb_plugin->get_option('pay_later_label','Pay later',$id), 'appointment-hour-booking').'</div>', $form_code );

			if (substr_count ($form_code, 'name="bccf_payment_option_paypal"') > 1)
			    $form_code = str_replace( 'id="field-c0" style="display:none">', 'id="field-c0">', $form_code);

            return $form_code;
		} // End insert_payment_fields


		/**
         * process payment
         */
		public function pp_idealtargetpay($params)
		{
            global $wpdb, $cp_appb_plugin;

			// documentation: https://goo.gl/w3kKoH

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID || floatval($params["final_price"]) == 0)
			    return;

            $pro_item_name = $cp_appb_plugin->get_option('product_name', 'Booking');
            foreach ($params as $item => $value)
                $pro_item_name = str_replace('<%'.$item.'%>',(is_array($value)?(implode(", ",$value)):($value)),$pro_item_name);

            $key = $rows[0]->idealtargetpay_api_username;
            $bank = $_POST["bank"];  //"INGBNL2A";
            try
            {

                $test=$rows[0]->mode; // Set to 1 for testing as described in paragraph 1.3
                $url= "https://www.targetpay.com/ideal/start?".
                "rtlo=".$key.
                "&bank=".$bank.
                "&description=".urlencode($pro_item_name).
                "&amount=".round($params["final_price"]*100,0).
                "&returnurl=".urlencode($cp_appb_plugin->get_site_url().'/?apphbidealtargetpay_ipnreturn=1&itemnumber='.$params[ 'itemnumber' ].'&d='.$params["formid"]).
                "&reporturl=".urlencode($cp_appb_plugin->get_site_url().'/?apphbidealtargetpay_ipncheck=1&itemnumber='.$params[ 'itemnumber' ].'&d='.$params["formid"]).
                "&test=".$test.
                "&ver=3";

                $strResponse = $this->httpGetRequest($url);
                $aResponse = explode('|', $strResponse );
                # Bad response
                if ( !isset ( $aResponse[1] ) ) die('Error' . $aResponse[0] );
                $responsetype = explode ( ' ', $aResponse[0] );
                $trxid = $responsetype[1];
                // Hier kunt u het transactie id aan uw order toevoegen.

                if( $responsetype[0] == "000000" ) header("Location: " . $aResponse[1] );
                else die($aResponse[0]);

            } catch (Exception $e) {
                echo "Error: ".$e->getMessage();
            }
            exit;
		} // end pp_idealtargetpay


		/**
		 * utility connection function
		 */
		private function httpGetRequest($url)
		{
		    $ch = curl_init( $url );
            curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1) ;
            $strResponse = curl_exec($ch);
            curl_close($ch);
            if ( $strResponse === false )
            {
               if ($url == 'https://www.targetpay.com/ideal/getissuers?ver=3&format=html')
                   $strResponse = '<option selected value="">Kies uw bank...</option><option value="ABNANL2A">ABN AMRO</option><option value="ASNBNL21">ASN Bank</option><option value="BUNQNL2A">bunq</option><option value="INGBNL2A">ING</option><option value="KNABNL2H">Knab</option><option value="RABONL2U">Rabobank</option><option value="RBRBNL21">RegioBank</option><option value="SNSBNL2A">SNS Bank</option><option value="TRIONL2U">Triodos Bank</option><option value="FVLBNL22">van Lanschot</option>';
               else
                   die("Could not fetch response " . $url );
            }
            return $strResponse;
        }


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}

		public function pp_idealtargetpay_return_page( )
		{
            global $wpdb, $cp_appb_plugin;
            if(
				!isset( $_GET['apphbidealtargetpay_ipnreturn'] ) ||
				$_GET['apphbidealtargetpay_ipnreturn'] != '1' ||
				!isset( $_GET["itemnumber"] )
			) return;

            $itemnumber = intval(@$_GET['itemnumber'] );
            $formid = intval(@$_GET['d'] );

            $rowstargetpay = $wpdb->get_row(
				$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid )
			);

			if(empty($rowstargetpay)) return;

			$once=1;
            $url= "https://www.targetpay.com/ideal/check?".
            "rtlo=".$rowstargetpay->idealtargetpay_api_username.
            "&trxid=".$_GET['trxid'].
            "&once=".$once;
            $result = $this->httpGetRequest($url);
			
			if ($result != '000000 OK')
			{
	            header( 'Location: '.$rowstargetpay->return_error );
			}
			else
			{
				/**
				 * Action called after process the data received by PayPal.
				 * To the function is passed an array with the data collected by the form.
				 */
				//do_action( 'apphb_payment_processed', $submission->paypal_post );
                $location = $cp_appb_plugin->get_option('fp_return_page', $cp_appb_plugin->get_site_url());
                header("Location: ".$location);
			}
            exit;
		}

		public function pp_idealtargetpay_update_status( )
		{
            global $wpdb, $cp_appb_plugin;
            if(
				!isset( $_GET['apphbidealtargetpay_ipncheck'] ) ||
				$_GET['apphbidealtargetpay_ipncheck'] != '1' ||
				!isset( $_GET["itemnumber"] )
			) return;

            $itemnumber = intval(@$_GET['itemnumber'] );

            $rowstargetpay = $wpdb->get_row(
				$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", intval(@$_GET["d"]) )
			);

			if(empty($rowstargetpay)) return;

            if (!( isset($_POST['rtlo']) && isset($_POST['trxid']) && isset($_POST['idealtrxid']) && isset($_POST['status']) ))
	        {
	            echo 'Payment failed.';
	            exit;
	        }

            $once=1;
            $url= "https://www.targetpay.com/ideal/check?".
            "rtlo=".$rowstargetpay->idealtargetpay_api_username.
            "&trxid=".$_POST['trxid'].
            "&once=".$once;
            $result = $this->httpGetRequest($url);
            if ($result != '000000 OK')
            {
	            echo 'Payment failed.';
	            exit;
	        }

            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $itemnumber) );
            if (empty( $myrows ))
			   return;
            $params = unserialize($myrows->posted_data);
            $params["paid"] = '1';
            $params["payment_type"] = "TargetPay/iDeal";
            $wpdb->query( $wpdb->prepare("UPDATE  ".$wpdb->prefix.$cp_appb_plugin->table_messages." SET posted_data=%s WHERE id=%d", serialize($params), $itemnumber) );
            $cp_appb_plugin->update_status($itemnumber, $cp_appb_plugin->get_option('defaultpaidstatus', '') );
            
            if (!count($myrows))
                $cp_appb_plugin->ready_to_go_reservation($itemnumber, "", $params); 

			$location = $cp_appb_plugin->get_option('fp_return_page', $cp_appb_plugin->get_site_url());
            header("Location: ".$location);
            exit;
		}

		/**
		 *	Delete the form from the addon's table
		 */
        public function delete_form( $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$wpdb->delete( $wpdb->prefix.$this->form_table, array('formid' => $formid), '%d' );
		} // delete_form

		/**
		 *	Clone the form's row
		 */
		public function clone_form( $original_form_id, $new_form_id )
		{
			global $wpdb, $cp_appb_plugin;

			$form_rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $original_form_id ), ARRAY_A);

			if(!empty($form_rows))
			{
				foreach($form_rows as $form_row)
				{
					unset($form_row["id"]);
					$form_row["formid"] = $new_form_id;
					$wpdb->insert( $wpdb->prefix.$this->form_table, $form_row);
				}
			}
		} // End clone_form

		/**
		 *	It is called when the form is exported to export the addons data too.
		 *  Receive an array with the other addons data, and the form's id for filtering.
		 */
		public function export_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			$rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ), ARRAY_A );
			if(!empty($rows))
			{
				$addons_array[ $this->addonID ] = array();
				foreach($rows as $row)
				{
					unset($row['id']);
					unset($row['formid']);
					$addons_array[ $this->addonID ][] = $row;
				}
			}
			return $addons_array;
		} // End export_form

		/**
		 *	It is called when the form is imported to import the addons data too.
		 *  Receive an array with all the addons data, and the new form's id.
		 */
		public function import_form($addons_array, $formid)
		{
			global $wpdb, $cp_appb_plugin;
			if(isset($addons_array[$this->addonID]))
			{
				foreach($addons_array[$this->addonID] as $row)
				{
					if(!empty($row))
					{
						$row['formid'] = $formid;
						$wpdb->insert(
							$wpdb->prefix.$this->form_table,
							$row
						);
					}
				}
			}
		} // End import_form

    } // End Class

    // Main add-on code
    $CPAPPB_iDealTargetPay_obj = new CPAPPB_iDealTargetPay();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_iDealTargetPay_obj->get_addon_id() ] = $CPAPPB_iDealTargetPay_obj;
}


?>