<?php
/*
    iCal Import Addon
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_TimezoneConversion' ) )
{
    class CPAPPB_TimezoneConversion extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-TimezoneConversion-20180607";
		protected $name = "Timezone Conversion";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
            
            $cp_appb_plugin->add_field_verify ($wpdb->prefix.$this->form_table, 'observe_day_light');
            $cp_appb_plugin->add_field_verify ($wpdb->prefix.$this->form_table, 'ical_daylight_zone');
            
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_TimezoneConversion_id' ] )
			)
			{
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									
									'timezone_enable'	 => $_REQUEST["timezone_enable"],
									'observe_day_light'	 => $_REQUEST["tzc_observe_day_light"],									
									'ical_daylight_zone' => $_REQUEST["tzc_ical_daylight_zone"],                                    
                                    
                                    'deftimezone'	 => $_REQUEST["deftimezone"],

								),
								array( '%d', '%d', '%s', '%s', '%s' )
							);           
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["timezone_enable"] = 0;
			    $row["deftimezone"] = '';
			    $row["observe_day_light"] = "true";
			    $row["ical_daylight_zone"] = "EUROPE";                
			} else {
			    $row["timezone_enable"] = $rows[0]->timezone_enable;
			    $row["deftimezone"] = $rows[0]->deftimezone;
			    $row["ical_daylight_zone"] = $rows[0]->ical_daylight_zone;
                $row["observe_day_light"] = $rows[0]->observe_day_light;                
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_TimezoneConversion_id" value="1" />
                     Enable timezone conversion for this calendar? :<br />
                        <?php $option = $row['timezone_enable']; ?>
                        <select name="timezone_enable" id="timezone_enable" onchange="cptimezone_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
                   
                   <div id="TimezoneConversioncontent_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                         <br />
                         <strong>Select Timezone for the original time-slots:</strong><br />
                         <?php $option = $row['deftimezone']; ?>
                         <select name="deftimezone" id="deftimezone" >               
                          <?php for ($i=-23;$i<24; $i++) {  $text = "GMT ".($i<0?"":"+").$i." hours"; ?><option value="<?php echo $i; ?>" <?php if ($option == $i) echo ' selected'; ?>><?php echo $text; ?></option><?php } ?>
                         </select><br /><em>This is the timezone where the time-slots are defined, usually the your timezone (administrator/service provider timezone). <br />Your computer timezone is: <strong style="color: #ff0000">GMT <span id="mytimezone"></span></strong></em>
                         <br /><br />
                         <strong>Note:</strong> Into the <a href="javascript:ahbGoToStep(3);">email content (Message) settings</a> use the tag <strong style="color: #ff0000">%apps_customer%</strong> to insert the customer times into the email. The tag <strong style="color: #ff0000">%customer_timezone%</strong> can be used to get the customer timezone into the email.
                         <table class="form-table">    
                           <tr valign="top">
                           <th scope="row"><?php _e('Observe daylight saving time?', 'appointment-hour-booking'); ?></th>
                           <td><select name="tzc_observe_day_light">
                                 <option value="true" <?php if ($row["observe_day_light"] == '' || $row["observe_day_light"] == 'true') echo ' selected'; ?>>Yes</option> 
                                 <option value="false" <?php if ($row["observe_day_light"] == 'false') echo ' selected'; ?>>No</option>
                                </select>
                           </td>
                           </tr>
                           <tr valign="top">
                           <th scope="row"><?php _e('Daylight saving time zone', 'appointment-hour-booking'); ?></th>
                           <td><select name="tzc_ical_daylight_zone">
                                 <option value="EUROPE" <?php if ($row["ical_daylight_zone"] == '' || $row["ical_daylight_zone"] == 'EUROPE') echo ' selected'; ?>>Europe</option> 
                                 <option value="USA" <?php if ($row["ical_daylight_zone"] == 'USA') echo ' selected'; ?>>USA</option>
                                </select>
                           </td>
                           </tr>     
                         </table>                    
                   </div>
                   <script type="text/javascript">
                       var d = new Date();
                       var n = -1 * (d.getTimezoneOffset()) / 60;
                       document.getElementById("mytimezone").innerHTML = (n>=0?'+':'') + n;
                       <?php if ($option == '') echo 'document.getElementById("deftimezone").options.selectedIndex =n+23;'; ?>
                       function cptimezone_display_option(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("TimezoneConversioncontent_yes").style.display = '';
                           else
                               document.getElementById("TimezoneConversioncontent_yes").style.display = 'none';
                       }
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_tzoneconversion';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on applies the timezone conversion to display the time-slots in the customer timezone", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
            
            add_filter( 'cpappb_the_form', array( &$this, 'filter_output_form'), 99, 2 );
            
            add_action( 'cpappb_process_data_before_insert', array( &$this, 'process_data_before_insert' ), 1, 1 );
            
            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;

			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    timezone_enable INT NOT NULL,
                    deftimezone TEXT,
					UNIQUE KEY id (id)
				) $charset_collate;";
            
			$wpdb->query($sql);
            
		} // end update_database
      

      
       public function process_data_before_insert(&$params)
       {
           global $wpdb, $cp_appb_plugin;
           $rows = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE timezone_enable=1 AND formid=".intval($params["formid"]) );
           if (count($rows) && isset($_POST["ctimezone"]) && $_POST["ctimezone"] != '')
           {
               $ctimezone_offset = -1 * ($this->adjust_timezone($rows[0]->deftimezone,$rows[0]->observe_day_light,$rows[0]->ical_daylight_zone) - floatval($_POST["ctimezone"]));
               $ctimezone_offset = floor($ctimezone_offset) * 60 + round( ($ctimezone_offset - floor($ctimezone_offset)) * 60 );
               $apps = $params["apps"];
               $apps_customer = array();
               $counter = 0;
               foreach ($apps as $app)
               {
                   $apps_customer[$counter] = $app;
                   $slot = $app["slot"];
                   $tmp2 = array("h1"=>intval(substr($slot,0,2)),"m1"=>intval(substr($slot,3,2)),"h2"=>intval(substr($slot,6,2)),"m2"=>intval(substr($slot,9,2)));
                   $org_date = $app["date"]." ".$tmp2["h1"].":".$tmp2["m1"];
                   $org_date2 = $app["date"]." ".$tmp2["h2"].":".$tmp2["m2"];
                   // here apply date conversion
                   $org_date = date("Y-m-d H:i", strtotime($org_date .($ctimezone_offset>=0?' +':' ').$ctimezone_offset." minutes"  ));
                   $org_date2 = date("Y-m-d H:i", strtotime($org_date2 .($ctimezone_offset>=0?' +':' ').$ctimezone_offset." minutes"  ));
                   $apps_customer[$counter]["date"] = date("Y-m-d", strtotime($org_date));
                   $apps_customer[$counter]["slot"] = date("H:i", strtotime($org_date))."/".date("H:i", strtotime($org_date2));
                   
                   $params["app_date_".($counter+1)."_customer"] = $cp_appb_plugin->format_date($apps_customer[$counter]["date"]);           
                   $params["app_slot_".($counter+1)."_customer"] = $cp_appb_plugin->format12hours(trim(date("H:i", strtotime($org_date))), @$app["military"] == 0)
                                                             ."/".
                                                             $cp_appb_plugin->format12hours(trim(date("H:i", strtotime($org_date2))), @$app["military"] == 0);
                   $counter++;                  
               }
               $params["apps_customer"] = $cp_appb_plugin->get_appointments_text ($apps_customer);
               $params["customer_timezone"] = sanitize_text_field((floatval($_POST["ctimezone"])>=0?'GMT +':'GMT ').$_POST["ctimezone"]);
           }
       }
      
		/**
         * Output time conversion`
         */      
        public function filter_output_form($form_code, $formid)
		{
            global $wpdb, $cp_appb_plugin;
             
            $rows = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE timezone_enable=1 AND formid=".intval($formid) );
            if (count($rows))
            {
                $form_code = '<script>var cp_hourbk_timezone='.$this->adjust_timezone($rows[0]->deftimezone,$rows[0]->observe_day_light,$rows[0]->ical_daylight_zone).';var cp_hourbk_observedaylight='.$rows[0]->observe_day_light.';var cp_hourbk_daylightzone="'.$rows[0]->ical_daylight_zone.'";</script>'. $form_code;
                
                $conversion_code = '<input type="hidden" name="ctimezone" id="ctimezone'.$formid.'" value="" /><script>var apphourbkdtz = new Date();var apphourtoffset = -1 * (apphourbkdtz.getTimezoneOffset()) / 60;document.getElementById("ctimezone'.$formid.'").value=apphourtoffset;</script>';
                
                $form_code = str_replace ('<!-- rcadon -->', '<!-- rcadon -->'.$conversion_code, $form_code);
            }
            return $form_code; 
        }
        
        
		/**
         * Output time conversion`
         */      
        public function adjust_timezone($original, $observe, $zone)
		{
            if ($observe && $observe != 'false')
            {
                $full_date = date("Ymd");
                $year = date("Y");
                if (strtoupper($zone) == 'EUROPE')
                {
                    $dst_start = strtotime('last Sunday GMT', strtotime("1 April $year GMT"));
                    $dst_stop = strtotime('last Sunday GMT', strtotime("1 November $year GMT"));
                } else { // USA
                    $dst_start = strtotime('first Sunday GMT', strtotime("1 April $year GMT"));
                    $dst_stop = strtotime('last Sunday GMT', strtotime("1 November $year GMT"));
                }
                if ($full_date >= gmdate("Ymd",$dst_start) && $full_date < gmdate("Ymd",$dst_stop))
                    $original++; // $datetime = date("Y-m-d H:i",strtotime($datetime." -1 hour"));
            }

            return $original;
        }            
        

		/************************ PUBLIC METHODS  *****************************/


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}
        


    } // End Class

    // Main add-on code
    $CPAPPB_TimezoneConversion_obj = new CPAPPB_TimezoneConversion();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_TimezoneConversion_obj->get_addon_id() ] = $CPAPPB_TimezoneConversion_obj;
}