<?php
/*
    Reference: https://www.twilio.com/docs/quickstart/php/sms/sending-via-rest#send-sms-via-rest
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_TwilioSMS' ) )
{
    class CPAPPB_TwilioSMS extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-TwilioSMS-20170903";
		protected $name = "Twilio SMS notifications for bookings";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
            
            $this->add_field_verify ('twilio_notification_status_change','TEXT');
            $this->add_field_verify ('twilio_phonefieldprefix');        
            $this->add_field_verify ('twilio_adminphone');                    
            $this->add_field_verify ('twilio_sendreminder');   
            $this->add_field_verify ('twilio_sendinitial');
            $this->add_field_verify ('twilio_stripzero');
            
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_TwilioSMS_id' ] )
			)
			{
                $_REQUEST["twilio_notification_to_customer"] = stripcslashes($_REQUEST["twilio_notification_to_customer"]);
                $_REQUEST["twilio_notification_status_change"] = stripcslashes($_REQUEST["twilio_notification_status_change"]);
              
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									
									'twilio_enable'	 => $_REQUEST["twilio_enable"],
                                    
                                    'twilio_accountsid'	                 => $_REQUEST["twilio_accountsid"],
                                    'twilio_authtoken'	                 => $_REQUEST["twilio_authtoken"],
                                    'twilio_phonefield'	                 => $_REQUEST["twilio_phonefield"],
                                    'twilio_phonefieldprefix'	         => $_REQUEST["twilio_phonefieldprefix"],
                                    'twilio_stripzero'	                 => $_REQUEST["twilio_stripzero"],
                                    'twilio_fromphone'	                 => $_REQUEST["twilio_fromphone"],
                                    'twilio_adminphone'	                 => $_REQUEST["twilio_adminphone"],
                                    'twilio_sendreminder'	             => $_REQUEST["twilio_sendreminder"],
                                    'twilio_sendinitial'	             => $_REQUEST["twilio_sendinitial"],
                                    'twilio_notification_to_customer'	 => $_REQUEST["twilio_notification_to_customer"],
                                    'twilio_notification_status_change'	 => $_REQUEST["twilio_notification_status_change"]

								),
								array( '%d', '%d',   
                                             '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s'
								              )
							);
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["twilio_enable"] = 0;
                $row["twilio_sendreminder"] = 0;
                $row["twilio_sendinitial"] = 0;
			    $row["twilio_accountsid"] = '';
                $row["twilio_authtoken"] = '';
                $row["twilio_phonefield"] = 'fieldname2';
                $row["twilio_phonefieldprefix"] = '';
                $row["twilio_stripzero"] = 'yes';
                $row["twilio_fromphone"] = '+15017250604';
                $row["twilio_adminphone"] = '';
                $row["twilio_notification_to_customer"] = "Reminder for appointment on %SMSDATE%";
                $row["twilio_notification_status_change"] = "Appointment on %SMSDATE% status changed to %status%";
                
			} else {
			    $row["twilio_enable"] = $rows[0]->twilio_enable;
                $row["twilio_sendreminder"] = $rows[0]->twilio_sendreminder;
                $row["twilio_sendinitial"] = $rows[0]->twilio_sendinitial;
			    $row["twilio_accountsid"] = $rows[0]->twilio_accountsid;
                $row["twilio_authtoken"] = $rows[0]->twilio_authtoken;
                $row["twilio_phonefield"] = $rows[0]->twilio_phonefield;
                $row["twilio_phonefieldprefix"] = $rows[0]->twilio_phonefieldprefix;
                $row["twilio_stripzero"] = $rows[0]->twilio_stripzero;
                $row["twilio_fromphone"] =  $rows[0]->twilio_fromphone;
                $row["twilio_adminphone"] =  $rows[0]->twilio_adminphone;
                $row["twilio_notification_to_customer"] = $rows[0]->twilio_notification_to_customer;
                $row["twilio_notification_status_change"] = $rows[0]->twilio_notification_status_change;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_TwilioSMS_id" value="1" />
                     Enable TwilioSMS? :<br />
                        <?php $option = $row['twilio_enable']; ?>
                        <select name="twilio_enable" id="twilio_enable" onchange="twilio_display_emails(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
                   
                   <div id="twilioemailcontent_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                         <br />
                         <strong>Important note: This add-on requires to enable also the "Reminder" addon.</strong> 
                         <br /><br />                         
                         <strong>Twilio AccountSid:</strong><br />
                         <input type="text" name="twilio_accountsid" size="70" value="<?php $text = esc_attr($row['twilio_accountsid']); echo $text; ?>" /><br />
                         <strong>Twilio AuthToken:</strong><br />
                         <input type="text" name="twilio_authtoken" size="70" value="<?php $text = esc_attr($row['twilio_authtoken']); echo $text; ?>" /><br />
                         <strong>Phone number used as "from":</strong><br />
                         <input type="text" name="twilio_fromphone" size="70" value="<?php $text = esc_attr($row['twilio_fromphone']); echo $text; ?>" /><br /><em>* Change the 'From' number above to be a valid Twilio number that you've purchased<br />
                         <strong>Admin notifications (copy of customer SMS) to phone number:</strong><br />
                         <input type="text" name="twilio_adminphone" size="70" value="<?php $text = esc_attr($row['twilio_adminphone']); echo $text; ?>" /><br /><em>* Optional. Be sure to include the country prefix, example: +1987654321<br />                         
                         <hr />
                         <strong>ID of the field that contains the phone number:</strong><br />
                         <input type="text" name="twilio_phonefield" size="70" value="<?php $text = esc_attr($row['twilio_phonefield']); echo $text; ?>" /><br /><em>* Click the field in the form builder to see its ID. Example: fieldname1, fieldname2, .... put only the ID without tags<br />
                         <strong>Add the following country code to all customer phone numbers:</strong><br />
                         <input type="text" name="twilio_phonefieldprefix" size="10" value="<?php $text = esc_attr($row['twilio_phonefieldprefix']); echo $text; ?>" /><br /><em>* Use this <strong>only</strong> if all your customers are from the same country and you don't request the country code in the phone number field.<br />
						 <strong><?php _e('Strip first zero from the phone number?','appointment-hour-booking'); ?>:</strong><br />
                         <?php $stripzero = ((isset($row) && !empty($row['twilio_stripzero'])) ? trim($row['twilio_stripzero']) : ''); ?>
						  <select name="twilio_stripzero">
                               <option <?php if ($stripzero) echo ' selected '; ?> value="yes">Yes</option>
                               <option <?php if (!$stripzero) echo ' selected '; ?> value="">No</option>
                          </select><br />						
                         
                         <hr />
                         <strong>Send SMS when a new booking is submitted:</strong><br />
                         <select name="twilio_sendinitial" style="margin-bottom: 7px;">
                          <option value="0" <?php if (!intval($row['twilio_sendinitial'])) echo " selected"?>>Yes</option>
                          <option value="1" <?php if (intval($row['twilio_sendinitial'])) echo " selected"?>>No</option>
                         </select><br />
                         <strong>Send SMS when a reminder is sent:</strong><br />
                         <select name="twilio_sendreminder">
                          <option value="0" <?php if (!intval($row['twilio_sendreminder'])) echo " selected"?>>Yes</option>
                          <option value="1" <?php if (intval($row['twilio_sendreminder'])) echo " selected"?>>No</option>
                         </select><br />
                         <hr />
                         <strong>Twilio SMS content:</strong><br />
                         <textarea cols="125" rows="3" name="twilio_notification_to_customer"><?php $text = esc_textarea($row['twilio_notification_to_customer']); echo $text; ?></textarea><br />
                         <strong>Twilio SMS on status modification (leave empty to ignore):</strong><br />
                         <textarea cols="125" rows="3" name="twilio_notification_status_change"><?php $text = esc_textarea($row['twilio_notification_status_change']); echo $text; ?></textarea><br />
                                                
                   </div>
                   <script type="text/javascript">
                       function twilio_display_emails(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("twilioemailcontent_yes").style.display = '';
                           else
                               document.getElementById("twilioemailcontent_yes").style.display = 'none';
                       }
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_TwilioSMS';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on adds support for Twilio SMS notifications", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
            
            add_action( 'cpappb_process_data_second_round', array( &$this, 'pp_TwilioSMS_send_new' ), 10, 2 );
            
			add_action( 'cpahb_reminder_sent', array( &$this, 'pp_TwilioSMS_send' ), 10, 1 );
            
            add_action( 'cpappb_update_status', array( &$this, 'pp_TwilioSMS_update_status' ), 10, 2 );

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb, $cp_appb_plugin;

			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    twilio_enable INT NOT NULL,
                    twilio_accountsid varchar(255) DEFAULT '' NOT NULL,
                    twilio_authtoken varchar(255) DEFAULT '' NOT NULL, 
                    twilio_phonefield varchar(255) DEFAULT '' NOT NULL, 
                    twilio_phonefieldprefix varchar(255) DEFAULT '' NOT NULL,
                    twilio_fromphone varchar(255) DEFAULT '' NOT NULL, 
                    twilio_adminphone varchar(255) DEFAULT '' NOT NULL,
                    twilio_sendinitial varchar(255) DEFAULT '' NOT NULL,
                    twilio_sendreminder varchar(255) DEFAULT '' NOT NULL,
                    twilio_notification_to_customer mediumtext,
					UNIQUE KEY id (id)
				) $charset_collate;";
            
			$wpdb->query($sql);
            
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}
        
        
        public function pp_TwilioSMS_update_status($itemnumber, $status)
		{
            global $wpdb, $cp_appb_plugin; 
            
            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $itemnumber) );
            $params = unserialize($myrows[0]->posted_data); 
            if ($status == '')
                $status = 'Approved';
            $params["status"] = $status;
            $params["is_status_change"] = true;
            $this->pp_TwilioSMS_send_new( $params  );           
        }
        

		public function pp_TwilioSMS_send_new( $params  )
		{
            global $wpdb, $cp_appb_plugin;
 
            $formid = $params["formid"];
            
            $settings = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE twilio_enable=1 AND formid=".intval($formid) ); 
            if (!count($settings))
                return;
            
            if (intval($settings[0]->twilio_sendinitial)) // this option has been disabled
                return;
            
            if (@$params["is_status_change"])
                $email_content_customer = $settings[0]->twilio_notification_status_change;
            else
                $email_content_customer = $settings[0]->twilio_notification_to_customer;          
            $email_content_customer = str_replace('<'.'%', '%', $email_content_customer);
            $email_content_customer = str_replace('%'.'>', '%', $email_content_customer);
            $email_content_customer = str_replace('%SMSDATE%', $params["app_date_1"]." ".$params["app_slot_1"], $email_content_customer);
            $email_content_customer = str_replace('%itemnumber%', $params["itemnumber"], $email_content_customer);
            foreach ($params as $item=> $value)
                $email_content_customer = str_replace('%'.$item.'%',(is_array($value)?(implode(", ",$value)):($value)),$email_content_customer); 
            for ($kit=0;$kit<500;$kit++)
                $email_content_customer = str_replace('%fieldname'.$kit.'%',"",$email_content_customer);                                        
            
            $email_content_customer = $cp_appb_plugin->replace_tags($email_content_customer, $params);
            
            // Step 2: set our AccountSid and AuthToken from https://twilio.com/console
            $AccountSid = $settings[0]->twilio_accountsid;
            $AuthToken = $settings[0]->twilio_authtoken;           
                        
            // Step 3: instantiate a new Twilio Rest Client
            if ($email_content_customer != '')
            {
                $phone = trim($params[$settings[0]->twilio_phonefield]);
                $phone = (@$settings[0]->twilio_stripzero? ltrim($phone,'0'):$phone);
                $this->_send_sms ($settings[0]->twilio_accountsid, $AuthToken, $settings[0]->twilio_fromphone,  $settings[0]->twilio_phonefieldprefix.$phone, $email_content_customer);
                               
                if ($settings[0]->twilio_adminphone) // copy to admin
                    $this->_send_sms ($settings[0]->twilio_accountsid, $AuthToken, $settings[0]->twilio_fromphone, $settings[0]->twilio_adminphone, $email_content_customer);
            }
               
         
		}
        
        
		public function pp_TwilioSMS_send( $params  )
		{
            global $wpdb, $cp_appb_plugin;
 
            $formid = $params["formid"];
            $slot = $params["slot"];
            $params = $params["params"];
            
            $settings = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE twilio_enable=1 AND formid=".intval($formid) ); 
            if (!count($settings))
                return;
            
            if (intval($settings[0]->twilio_sendreminder)) // this option has been disabled
                return;
            
            $email_content_customer = $settings[0]->twilio_notification_to_customer;          
            $email_content_customer = str_replace('<'.'%', '%', $email_content_customer);
            $email_content_customer = str_replace('%'.'>', '%', $email_content_customer);
            $email_content_customer = str_replace('%SMSDATE%', $slot["date"]." ".$slot["slot"], $email_content_customer);
            $email_content_customer = str_replace('%itemnumber%', $params["itemnumber"], $email_content_customer);
            foreach ($params as $item=> $value)
                $email_content_customer = str_replace('%'.$item.'%',(is_array($value)?(implode(", ",$value)):($value)),$email_content_customer); 
            for ($kit=0;$kit<500;$kit++)
                $email_content_customer = str_replace('%fieldname'.$kit.'%',"",$email_content_customer); 

            $email_content_customer = $cp_appb_plugin->replace_tags($email_content_customer, $params);            
            
            // Step 2: set our AccountSid and AuthToken from https://twilio.com/console
            $AccountSid = $settings[0]->twilio_accountsid;
            $AuthToken = $settings[0]->twilio_authtoken;                                  
                
            // Step 3: instantiate a new Twilio Rest Client
            $this->_send_sms ($settings[0]->twilio_accountsid, $AuthToken, $settings[0]->twilio_fromphone, $settings[0]->twilio_phonefieldprefix.$params[$settings[0]->twilio_phonefield], $email_content_customer);
            
            if ($settings[0]->twilio_adminphone) // copy to admin
                $this->_send_sms ($settings[0]->twilio_accountsid, $AuthToken, $settings[0]->twilio_fromphone, $settings[0]->twilio_adminphone, $email_content_customer);
         
		}
        
		/**
		 * Checks the format of phone's number and transform it is needed
		 */
		private function _phone_number($phone)
		{
			$phone = preg_replace('/[^\d\+]/', '', $phone);
			$phone = preg_replace('/^00/', '+', $phone);
			if(preg_match('/^\+?[1-9]\d{1,14}$/', $phone)) return $phone;
			return false;
		} // End _validate_phone_number

		/**
		 * Cuts the message to 160 characters
		 */
		private function _message($mssg)
		{
			return substr($mssg, 0, 960);
		} // End _message

		/**
		 * Sends the SMS using twilio
		 */
		private function _send_sms($_sid, $_auth, $from, $to, $mssg)
		{
			$to = explode(',', $to);
			$mssg = $this->_message($mssg);
			foreach($to as $phone)
			{
				$phone = $this->_phone_number($phone);
				if(!empty($phone))
				{
					$params = array(
						'From' => $from,
						'To' => $phone,
						'Body' => $mssg
					);
					$args = array(
						'headers' 	=> array(
							'Authorization' => 'Basic '. base64_encode( $_sid.':'.$_auth )
						),
						'body' 		=> $params,
						'timeout' 	=> 45,
						'sslverify'	=> false,
					);

					$request = wp_remote_post(
						'https://api.twilio.com/2010-04-01/Accounts/'.$_sid.'/Messages.json',
						$args
					);

					if(!is_wp_error($request))
					{
						$response_body = wp_remote_retrieve_body($request);
						$body = json_decode($response_body);
						if(!empty($body) && !empty($body->error_code) )
						{
							if(!empty($body->error_message)) error_log( print_r( $body->error_message, true ) );
						}
					}
					else
					{
						error_log( print_r( $request->get_error_message(), true ) );
					}
				}
			}
		} // End send_sms        


        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL", $table = '')
        {
            global $wpdb, $cp_appb_plugin;
            if ($table == '')
                $table = $this->form_table;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }
                
        

    } // End Class

    // Main add-on code
    $cpappb_TwilioSMS_obj = new CPAPPB_TwilioSMS();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $cpappb_TwilioSMS_obj->get_addon_id() ] = $cpappb_TwilioSMS_obj;
}

