<?php
/*
    iCal Import Addon
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_UserCalendarCreation' ) )
{
    class CPAPPB_UserCalendarCreation extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-UserCalendarCreation-20180607";
		protected $name = "User Calendar Creation";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
            
            $cp_appb_plugin->add_field_verify ($wpdb->prefix.$this->form_table, 'calcreate_roles', "TEXT");
            
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_UserCalendarCreation_id' ] )
			)
			{
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									
									'calcreate_enable'	 => $_REQUEST["calcreate_enable"],
                                    
                                    'calcreate_roles'	 => serialize($_REQUEST["calcreate_roles"])

								),
								array( '%d', '%d', '%s' )
							);
                            
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["calcreate_enable"] = 0;
                $row["calcreate_roles"] = "";
			} else {
			    $row["calcreate_enable"] = $rows[0]->calcreate_enable;
                $row["calcreate_roles"] = $rows[0]->calcreate_roles;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_UserCalendarCreation_id" value="1" />
                    Automatically create and assign a calendar for new registered users? :<br />
                        <?php $option = $row['calcreate_enable']; ?>
                        <select name="calcreate_enable" id="calcreate_enable" onchange="cpappbical_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
                   
                   <div id="UserCalendarCreationcontent_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                         <br />
                         <strong>Important Note: This calendar will be used as source. The calendar assigned to the user will be a cloned copy of this one.</strong><br /><br />                       
                    Create a calendar for the following user roles? :<br />
                        <?php 
                          global $wp_roles;
                          $all_roles = $wp_roles->roles;
                          $editable_roles = apply_filters('editable_roles', $all_roles);
                          $option = @unserialize($row['calcreate_roles']);
                     ?>
                        <select name="calcreate_roles[]" id="calcreate_roles[]" multiple style="height:150px;">
                         <?php foreach ($editable_roles as $item => $value) { ?>
                          <option value="<?php echo $item; ?>"<?php if (!is_array($option) || in_array($item,$option)) echo ' selected'; ?>><?php echo $item; ?></option>
                         <?php } ?>
                         </select><br />
                         <em>CTRL + click to mark multiple.<em>
                         
                   </div>
                   <script type="text/javascript">
                       function cpappbical_display_option(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("UserCalendarCreationcontent_yes").style.display = '';
                           else
                               document.getElementById("UserCalendarCreationcontent_yes").style.display = 'none';
                       }
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_UserCalendarCreation';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on creates and assign a calendar for each new registered user", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            add_action( 'user_register', array( &$this, 'UserCalendarCreation' ), 10, 1 );

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;

			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    calcreate_enable INT NOT NULL,
                    calcreate_roles TEXT,
					UNIQUE KEY id (id)
				) $charset_collate;";
            
			$wpdb->query($sql);
            
		} // end update_database
     
        
        public function get_user_role($user_id) 
        {
            global $wp_roles;
        
            $roles = array();
            $user = new WP_User( $user_id );
            if ( !empty( $user->roles ) && is_array( $user->roles ) ) {
                foreach ( $user->roles as $role )
                    $roles[] .= translate_user_role( $role );
            }
            return $roles;
        } 
        
		/**
         * 
         */
        public function UserCalendarCreation($user_id)
		{
			global $wpdb, $cp_appb_plugin;
            
            $rows = $wpdb->get_results( "SELECT ".$wpdb->prefix.$this->form_table.".* FROM ".$wpdb->prefix.$this->form_table." WHERE calcreate_enable=1");
            foreach ($rows as $item)
            {
                $roles = unserialize($item->calcreate_roles);
                $user_role = $this->get_user_role($user_id);
                if (!is_array($roles) || count(array_intersect($user_role,$roles)))
                {
                    $rowmains = $wpdb->get_results( "SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_items." WHERE id=".intval($item->formid), ARRAY_A);
                    unset($rowmains[0]["id"]);
                    $rowmains[0]["cp_user_access"] = serialize(array($user_id));
                    $udata = get_userdata( $user_id );
                    $rowmains[0]["fp_destination_emails"] = $udata->user_email;
                    $rowmains[0]["form_name"] = 'User: '.$udata->user_login.' - '.$rowmains[0]["form_name"];
                    $wpdb->insert( $wpdb->prefix.$cp_appb_plugin->table_items, $rowmains[0]);
                    do_action( 'cpapphourbk_cloneitem', $item->formid, $wpdb->insert_id );
                }
            }
		} // end UserCalendarCreation        


		/************************ PUBLIC METHODS  *****************************/


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}
        


    } // End Class

    // Main add-on code
    $CPAPPB_UserCalendarCreation_obj = new CPAPPB_UserCalendarCreation();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_UserCalendarCreation_obj->get_addon_id() ] = $CPAPPB_UserCalendarCreation_obj;
}