<?php
/*
Documentation: http://support.worldpay.com/support/bg/index.php?page=development&sub=integration&subsub=examples
               http://support.worldpay.com/support/kb/bg/paymentresponse/pr0000.html
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_WorldPay' ) )
{
    class CPAPPB_WorldPay extends CPAPPB_BaseAddon
    {
       
        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-WorldPay-20201216";
		protected $name = "WorldPay Payment Gateway";
		protected $description;
		
		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;			
			// Insertion in database
			if( 
				isset( $_REQUEST[ 'CPAPPB_WorldPay_id' ] )
			)
			{

			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert( 	
								$wpdb->prefix.$this->form_table, 
								array( 
									'formid' => $form_id,
									'worldpay_api_username'	 => $_REQUEST["worldpay_api_username"],
									'currency'	 => $_REQUEST["currency"],
									'enabled'	 => $_REQUEST["WorldPay_enabled"],
									'paypal_mode'	 => $_REQUEST["WorldPay_mode"]
								), 
								array( '%d', '%s', '%s','%s', '%s', '%s', '%s' ) 
							);					
			}		

			
			$rows = $wpdb->get_results( 
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id ) 
					);
			if (!count($rows))
			{
			    $row["worldpay_api_username"] = "";			    
			    $row["currency"] = "";
			    $row["enabled"] = "0";
			    $row["paypal_mode"] = "production";
			} else {
			    $row["worldpay_api_username"] = $rows[0]->worldpay_api_username;
			    $row["currency"] = $rows[0]->currency;
			    $row["enabled"] = $rows[0]->enabled;
			    $row["paypal_mode"] = $rows[0]->paypal_mode;
			}   
			
			?>
			<div id="metabox_basic_settings" class="postbox" >			
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside"> 
				   <input type="hidden" name="CPAPPB_WorldPay_id" value="1" />
                   <table class="form-table">
                    <tr valign="top">        
                    <th scope="row"><?php _e('Enable WorldPay? (if enabled PayPal Standard is disabled)', 'cpabc'); ?></th>
                    <td><select name="WorldPay_enabled">
                         <option value="0" <?php if (!$row["enabled"]) echo 'selected'; ?>><?php _e('No', 'cpabc'); ?></option>
                         <option value="1" <?php if ($row["enabled"]) echo 'selected'; ?>><?php _e('Yes', 'cpabc'); ?></option>
                         </select> 
                    </td>
                    </tr>   
                    <tr valign="top">        
                    <th scope="row"><?php _e('Your installation ID', 'cpabc'); ?></th>
                    <td><input type="text" name="worldpay_api_username" size="20" value="<?php echo esc_attr($row["worldpay_api_username"]); ?>" /><br />
                        <em>You will need to get the installation ID from your Worldpay account. Login to your account, click setting and under installations you should have an option called select junior and a number.<em></td>
                    </tr>   
                    <tr valign="top">        
                    <th scope="row"><?php _e('Currency', 'cpabc'); ?></th>
                    <td><input type="text" name="currency" size="20" value="<?php echo esc_attr($row["currency"]); ?>" /><br />
                        <em>Currency used for the transaction<em></td>
                    </tr>                    
                    <tr        
                    <tr valign="top">        
                    <th scope="row"><?php _e('Mode', 'cpabc');  ?></th>
                    <td><select name="WorldPay_mode">
                         <option value="production" <?php if ($row["paypal_mode"] != 'sandbox') echo 'selected'; ?>><?php _e('Production - real payments processed', 'cpabc'); ?></option> 
                         <option value="sandbox" <?php if ($row["paypal_mode"] == 'sandbox') echo 'selected'; ?>><?php _e('Test - Testing sandbox area', 'cpabc'); ?></option> 
                        </select>
                    </td>
                    </tr>                    
                   </table>  
				</div>
			</div>	
			<?php
		} // end get_addon_form_settings
		

		
		/************************ ADDON CODE *****************************/
		
        /************************ ATTRIBUTES *****************************/    
        
        private $form_table = 'CPAPPB_form_worldpay';        
        private $_inserted = false;
        
        /************************ CONSTRUCT *****************************/
		
        function __construct()
        {
			$this->description = __("The add-on adds support for WorldPay payments", 'cpabc' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
			
			add_action( 'cpappb_process_data', array( &$this, 'pp_WorldPay' ), 1, 2 );						

			add_action( 'init', array( &$this, 'pp_WorldPay_update_status' ), 10, 1 );
			
			//add_filter( 'CPAPPB_get_option', array( &$this, 'get_option' ), 10, 3 );					
			
            $this->update_database();
			
        } // End __construct
        

        
        /************************ PRIVATE METHODS *****************************/
        
		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;			
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
					enabled varchar(10) DEFAULT '0' NOT NULL ,
					worldpay_api_username varchar(255) DEFAULT '' NOT NULL ,					
					currency varchar(255) DEFAULT '' NOT NULL ,					
					paypal_mode varchar(255) DEFAULT '' NOT NULL ,				
					UNIQUE KEY id (id)
				);";
				//  WorldPay_api_signature varchar(255) DEFAULT '' NOT NULL ,
				//	currency varchar(255) DEFAULT '' NOT NULL ,
				
			$wpdb->query($sql);
		} // end update_database		        	
        
        
		/************************ PUBLIC METHODS  *****************************/                               

               
		/**
         * process payment
         */		
		public function pp_WorldPay($params)
		{               
            global $wpdb, $cp_appb_plugin;                    
            
            $rows = $wpdb->get_results( 
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] ) 
					);
			if (!$rows[0]->enabled)		
			    return;			    
            
            $productName = $cp_appb_plugin->get_option('product_name', 'Booking'); 
            
            //$paramList = array();            
            $item_number = $params["itemnumber"];
            $callback = ($cp_appb_plugin->get_site_url().'/?CPAPPB_worldpay_ipncheck=1&itemnumber='.$item_number);                               
                        
?>
<html>
<body>
<form action="https://secure<?php echo ($rows[0]->paypal_mode=="sandbox"?"-test":""); ?>.worldpay.com/wcc/purchase" name="BuyForm" method="POST">
<input type="hidden" name="instId"  value="<?php echo $rows[0]->worldpay_api_username; ?>"><!-- The "instId" value "211616" should be replaced with the Merchant's own installation Id -->
<input type="hidden" name="cartId" value="<?php echo $item_number; ?>"><!-- This is a unique identifier for merchants use. Example: PRODUCT123 -->
<input type="hidden" name="currency" value="<?php echo $rows[0]->currency; ?>"><!-- Choose appropriate currency that you would like to use -->
<input type="hidden" name="amount"  value="<?php echo $params["final_price"]; ?>">
<input type="hidden" name="desc" value="<?php echo $productName; ?>">
<input type="hidden" name="MC_callback" value="<?php echo $callback; ?>">
<input type="hidden" name="testMode" value="<?php echo ($rows[0]->paypal_mode=="sandbox"?"100":"0");?>"> <!-- 0 means live mode -->
</form>
<script type="text/javascript">
document.BuyForm.submit();
</script>
</body>
</html>
<?php            
            
            

            exit;   
		} // end pp_WorldPay               
		
		
		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}
		
		public function pp_WorldPay_update_status( )
		{
            global $wpdb;      
            if ( !isset( $_GET['CPAPPB_worldpay_ipncheck'] ) || $_GET['CPAPPB_worldpay_ipncheck'] != '1' ) // || !isset( $_GET["itemnumber"] ) 
                return;
                
            $itemnumber = intval($_POST["cartId"]);     

            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix.$cp_appb_plugin->table_messages." WHERE id=%d", $itemnumber) );         
            $rows = $wpdb->get_results( 
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $myrows[0]->calendar ) 
					);		                    

            /**
            // log data  
            $myrows1 = $wpdb->get_results( "SELECT * FROM ".CPAPPB_APPOINTMENTS_TABLE_NAME." WHERE id=".intval($itemnumber[0]) );
            $sql="UPDATE ".CPAPPB_APPOINTMENTS_TABLE_NAME." set question = '".$myrows1[0]->question
                 ."\n\nWorldPay_ResponseCode:".$responseParamList["RESPCODE"]
                 ."\n\nWorldPay_TXNID:".$responseParamList["TXNID"]
                 ."\n\nWorldPay_ORDERID:".$responseParamList["ORDERID"]
                 ."' WHERE id=".intval($itemnumber[0]);            
            $wpdb->query($sql);		            
			*/
			
			if ($_POST["transStatus"] != 'Y')  // transaction failed
			    return;

            $params = unserialize($myrows[0]->posted_data);
            $params["paid"] = '1';
            $params["payment_type"] = "WorldPay";
            $wpdb->query( $wpdb->prepare("UPDATE  ".$wpdb->prefix.$cp_appb_plugin->table_messages." SET posted_data=%s WHERE id=%d", serialize($params), $itemnumber) );
            $cp_appb_plugin->update_status($itemnumber, $cp_appb_plugin->get_option('defaultpaidstatus', '') );                        
            
            $cp_appb_plugin->ready_to_go_reservation($itemnumber, "", $params);         

            header("HTTP/1.1 200 OK"); 
            echo 'OK';            
            exit();             
              
		}

               
		/**
		 * Used to deactivate PayPal Standard if PayPal Pro is enabled for the form
		 */
		public function get_option( $value, $field, $id )
		{
			if( $field == 'enable_paypal' )
			{
			    global $wpdb;
			    $rows = $wpdb->get_results( 
						$wpdb->prepare( "SELECT enabled FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $id ) 
					);
			    if ( !empty( $rows ) && $rows[0]->enabled)
				    $value = 0;
			}	
			return $value;
		} // End get_option		
				              	          		        			
		
		
    } // End Class
    
    // Main add-on code
    $CPAPPB_WorldPay_obj = new CPAPPB_WorldPay();
    
	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $CPAPPB_WorldPay_obj->get_addon_id() ] = $CPAPPB_WorldPay_obj;
}



?>