<?php
/*

*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPAPPB_Zoom' ) )
{
    class CPAPPB_Zoom extends CPAPPB_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-Zoom-20170903";
		protected $name = "Zoom.us Meetings Integration";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb, $cp_appb_plugin;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPAPPB_Zoomlinks_id' ] )
			)
			{
                $cp_appb_plugin->add_field_verify ($wpdb->prefix.$this->form_table, 'zoom_oauth_key', "varchar(255) DEFAULT '' NOT NULL");
                $cp_appb_plugin->add_field_verify ($wpdb->prefix.$this->form_table, 'zoom_oauth_secret', "varchar(255) DEFAULT '' NOT NULL");
                $cp_appb_plugin->add_field_verify ($wpdb->prefix.$this->form_table, 'access_token', "TEXT");
                $cp_appb_plugin->add_field_verify ($wpdb->prefix.$this->form_table, 'zoom_itype', 'INT NOT NULL');
                
                $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
                if (count($rows))
                    $access_token = $rows[0]->access_token;
                else
                    $access_token = "";

			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,

									'zoom_api_key'	 => $_REQUEST["zoom_api_key"],
									'zoom_api_secret'	 => $_REQUEST["zoom_api_secret"],
                                    'access_token'	 => $access_token,
                                    
                                    'zoom_oauth_key'	 => $_REQUEST["zoom_oauth_key"],
									'zoom_oauth_secret'	 => $_REQUEST["zoom_oauth_secret"],

                                    'zoom_itype'	 => $_REQUEST["zoom_itype"],
                                    'zoom_enable'	 => $_REQUEST["zoom_enable"],
								),
								array( '%d', '%s', '%s', '%s', '%s', '%s', '%d' , '%d' )
							);
                            
                if (@$_POST["CPAPPB_Zoom_goauth"] == '1')
                {
                    $url = "https://zoom.us/oauth/authorize?response_type=code&client_id=".$_REQUEST["zoom_oauth_key"]."&redirect_uri=".urlencode($cp_appb_plugin->get_site_url()."/?cpapphb_zoomapi_auth=1&formid=".$form_id);
                    echo "<script>document.location='".$url."';</script>";
                    exit;
                } 
                else if (@$_POST["CPAPPB_Zoom_goauth"] == '2')
                {
                    $wpdb->update($wpdb->prefix.$this->form_table, array ( 'access_token' => '' ) , array( 'formid' => $form_id ) );
                }
                
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);        
                    
// https://zoom.us/oauth/authorize?response_type=code&client_id=Qr_Vd3SSZm_lkeoGH8lQ&redirect_uri=https%3A%2F%2Fdemows.dwbooster.com%2Ftemporal%2Fabc-platinum%2F%3Fcpapphb_zoomapi_auth%3D1%26formid%3D1
                    
			if (!count($rows))
			{
			    $row["zoom_api_key"] = '';
			    $row["zoom_api_secret"] = '';
                $row["zoom_oauth_key"] = '';
			    $row["zoom_oauth_secret"] = '';
                $row["access_token"] = '';
                $row["zoom_itype"] = '0'; 
                $row["zoom_enable"] = '24';              
			} else {
			    $row["zoom_api_key"] = $rows[0]->zoom_api_key;
			    $row["zoom_api_secret"] = $rows[0]->zoom_api_secret;
                $row["zoom_oauth_key"] = $rows[0]->zoom_oauth_key;
			    $row["zoom_oauth_secret"] = $rows[0]->zoom_oauth_secret;
                $row["access_token"] = $rows[0]->access_token;
                $row["zoom_itype"] = $rows[0]->zoom_itype;
                $row["zoom_enable"] = $rows[0]->zoom_enable;
			}

			?>
			<div id="metabox_basic_settings" class="postbox">
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3><a name="configzoom" id="configzoom"></a>
				<div class="inside">
				   <input type="hidden" name="CPAPPB_Zoomlinks_id" value="1" />
                   <input type="hidden" name="CPAPPB_Zoom_goauth" id="CPAPPB_Zoom_goauth" value="0" />
                    Enable <a href="https://zoom.us/" target="_blank">Zoom</a> integration for this booking form? :<br />
                        <?php $option = $row['zoom_enable']; ?>
                        <select name="zoom_enable" id="zoom_enable" onchange="cpappbzoom_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
         
                   <div id="UserCalendarzoom_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                   
                      Integration type?:<br />
                      <?php $option = $row['zoom_itype']; ?>
                      <select name="zoom_itype" id="zoom_itype" onchange="cpappbzoom_display_option_itype(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>JWT - Easier to setup</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>OAuth</option>
                      </select><br />
                         
                      
                      <div id="zoom_jwt">                      
                           <div style="font-size:120%;color:green; border: 1px dotted black;margin-top:10px;padding:15px;">To register your app, visit the <a href="https://marketplace.zoom.us/develop/create" target="_blank">Zoom App Marketplace</a> and click on the Develop option in the dropdown on the top-right corner and select Build App. A page with various app types will be displayed. <strong>Select JWT as the app type</strong> and click on Create. Then enter the API Key and API Secret in the fields below.</div>
                          <table class="form-table">
                            <tr valign="top">
                            <th scope="row">Zoom JWT API Key</th>
                            <td><input type="text" name="zoom_api_key" size="40" value="<?php echo esc_attr($row["zoom_api_key"]); ?>" /></td>
                            </tr>
                            <tr valign="top">
                            <th scope="row">Zoom JWT API Secret</th>
                            <td><input type="text" name="zoom_api_secret" size="40" value="<?php echo esc_attr($row["zoom_api_secret"]); ?>" /></td>
                            </tr>                           
                          </table>
                      </div>
                      

                      <div id="zoom_oauth" style="display:none">                      
                           <div style="font-size:120%;color:green; border: 1px dotted black;margin-top:10px;padding:15px;">To register your app, visit the <a href="https://marketplace.zoom.us/develop/create" target="_blank">Zoom App Marketplace</a> and click on the Develop option in the dropdown on the top-right corner and select Build App. A page with various app types will be displayed. <strong>Select OAuth as the app type</strong> and click on Create. Then setup the app using the URLs below and enter the Client ID and Secret in the fields below.</div>
                          <table class="form-table">
                            <tr valign="top">
                            <th scope="row">Zoom OAuth Client ID</th>
                            <td><input type="text" name="zoom_oauth_key" size="40" value="<?php echo esc_attr($row["zoom_oauth_key"]); ?>" /></td>
                            </tr>
                            <tr valign="top">
                            <th scope="row">Zoom OAuth Client Secret</th>
                            <td><input type="text" name="zoom_oauth_secret" size="40" value="<?php echo esc_attr($row["zoom_oauth_secret"]); ?>" /></td>
                            </tr>     
                            <tr valign="top">
                            <th scope="row">Redirect URL for OAuth:</th>
                            <td><?php echo $cp_appb_plugin->get_site_url(); ?>/?cpapphb_zoomapi_auth=1&formid=<?php echo $form_id; ?></td>
                            </tr> 
                            <tr valign="top">
                            <th scope="row">Whitelist URL:</th>
                            <td><?php echo $cp_appb_plugin->get_site_url(); ?>/</td>
                            </tr> 
                            <tr valign="top">
                            <th scope="row"></th>
                            <td>
                              <?php if ($row["access_token"]) { ?>
                                <div style="font-size:120%;color:green; border: 1px dotted black;margin-top:00px;padding:15px;">
                                  OAuth connection completed!<br />
                                  If you want to remove the connection you can use the following button:
                                  <input style="font-weight:normal;color:blue" type="button" name="oauthzoomauth" value="Remove Zoom Oauth authorization" onclick="javascript:ZoomOAuthRemoveAuth();">
                                </div>                               
                              <?php } else { ?>
                                <div style="font-size:120%;color:red; border: 1px dotted black;margin-top:00px;padding:15px;">
                                  When filled the above info click the following button to proceed with the authorization:<br />
                                  <input style="font-weight:bold;color:red" type="button" name="oauthzoomauth" value="Click here to proceed with the authorization" onclick="javascript:ZoomOAuthProceedAuth();">
                                </div>                            
                               <?php } ?>
                            </td>
                            </tr>  
                          </table>
                          
                          
                      </div>                      
                       
                          <div style="font-size:120%;color:blue; border: 1px dotted black;margin-top:10px;padding:15px;">Note: The following additional tags can be used in the emails:<br /><br />
                          <strong>%zoom%</strong>: The invitation link to the generated zoom meeting.<br />
                          <strong>%zoom_id%</strong>: The zoom meeting ID.<br />
                          <strong>%zoom_password%</strong>: The zoom meeting password.<br /><br />
                          ... the above tags are useful in the case of single time meetings, for multiple time bookings use %zoom_1%, %zoom_2%, %zoom_3%...
                          </div />
                        
                   </div>
                   <script type="text/javascript">

                       function ZoomOAuthProceedAuth()
                       {
                            if (confirm('This will save the settings and will redirect to Zoom to proceed with the authorization. Do you want to continue?'))
                            {
                                document.getElementById("CPAPPB_Zoom_goauth").value = '1';
                                document.cpformconf.submit();
                            }
                       }
                       function ZoomOAuthRemoveAuth()
                       {
                            if (confirm('This REMOVE the connection to Zoom. Do you want to continue?'))
                            {
                                document.getElementById("CPAPPB_Zoom_goauth").value = '2';
                                document.cpformconf.submit();
                            }
                       }
                       
                       <?php if (isset($_GET["step6"]) && $_GET["step6"] == '1') { ?>
                       	jQuery(function(){
		                      ahbGoToStep(6);
                          });
                       <?php } ?>
             
                       function cpappbzoom_display_option(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("UserCalendarzoom_yes").style.display = '';
                           else
                               document.getElementById("UserCalendarzoom_yes").style.display = 'none';
                       }
                       function cpappbzoom_display_option_itype(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                           {
                               document.getElementById("zoom_oauth").style.display = '';
                               document.getElementById("zoom_jwt").style.display = 'none';
                           }
                           else
                           {
                               document.getElementById("zoom_oauth").style.display = 'none';
                               document.getElementById("zoom_jwt").style.display = '';
                           }
                       }         
                       cpappbzoom_display_option_itype(document.getElementById("zoom_itype"));
                   </script>                   
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpappbk_form_Zoomlinks';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("Automatically creates a Zoom.us meeting for the booked time", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            add_action( 'cpappb_process_data', array( &$this, 'pp_Zoom_process_data' ), 1, 1 );
            
            add_action( 'init', array( &$this, 'pp_zoomoauth_checkauth' ), 1 );

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    zoom_api_key varchar(255) DEFAULT '' NOT NULL,
			        zoom_api_secret varchar(255) DEFAULT '' NOT NULL,
                    zoom_oauth_key varchar(255) DEFAULT '' NOT NULL,
			        zoom_oauth_secret varchar(255) DEFAULT '' NOT NULL,
                    access_token TEXT,
                    zoom_itype INT NOT NULL,
                    zoom_enable INT NOT NULL,
					UNIQUE KEY id (id)
				) $charset_collate;";

			$wpdb->query($sql);
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}

        
        public function refreshOAuthToken( $row)
        {
            global $wpdb;
            $access_token = unserialize($row->access_token);
            $args = array(
				'headers' 	=> array(
					'Authorization' => 'Basic '. base64_encode( $row->zoom_oauth_key.':'.$row->zoom_oauth_secret )
				),
				'body' 		=> array(),
				'timeout' 	=> 45,
				'sslverify'	=> false,
			);

            $url = "https://zoom.us/oauth/token?grant_type=refresh_token&refresh_token=".$access_token->refresh_token;
			$request = wp_remote_post(
				$url,
				$args
			);  
            if(!is_wp_error($request))
			{
				$response_body = wp_remote_retrieve_body($request);
				$body = json_decode($response_body);
				if(!empty($body) /** && !empty($body->error_code) */ )
				{
					if(!empty($body->error)) 
                    {
                        //echo '<strong>Authorization Error:</strong> '; print_r( $body );exit;
                        //error_log( print_r( $body ) );
                    }
                    else
                    {                        
                        $accessToken = serialize($body);
                        $wpdb->update($wpdb->prefix.$this->form_table, array ( 'access_token' => $accessToken ) , array( 'formid' => $row->formid ) );
                        return $body->access_token;
                    }
				}
			}
			else
			{
                //echo '<strong>Authorization Error:</strong> '; print_r( $request->get_error_message(), true );exit;
				//error_log( print_r( $request->get_error_message(), true ) );
			}
            return false;
        }            


        public function pp_Zoom_process_data( &$params )
        {
            global $wpdb, $cp_appb_plugin;
            
			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

			if (empty( $rows ) || !$rows[0]->zoom_enable)
			    return;
           
            $zoom_meeting = new AHB_Zoom_Api();
            $zoom_meeting->zoom_api_key = $rows[0]->zoom_api_key;
            $zoom_meeting->zoom_api_secret = $rows[0]->zoom_api_secret;
            if ($rows[0]->zoom_itype == 1)  // If OAuth then ... else use JWT
            {
                $token = $this->refreshOAuthToken($rows[0]);
                $zoom_meeting->zoom_oauth_token = $token;
            }            
            try{
                $count = 1;
                foreach($params["apps"] as $app)
                {
                    $time = explode("/", $app["slot"]);
                    $datetime = $app["date"]." ".trim($time[0]);
                    $duration = $app["duration"];
                       
                    $password = $this->randomPassword();
                    $z = $zoom_meeting->createAMeeting(
                    	array(
                    		'start_date'=>date("Y-m-d H:i:s", strtotime($datetime)),
                    		'meetingTopic'=> $cp_appb_plugin->replace_tags($cp_appb_plugin->get_option('product_name', 'Booking'),$params),
                            'password'=> $password,
                            'duration'=> $duration,
                    	)
                    );
                    //echo '<pre>'; print_r($z);
                    //echo $z->join_url."<br />";
                    //echo $z->start_url."<br />";
                    //echo $z->start_url."<br />";   
                    if ($count == 1)
                    {                        
                        $params["zoom"] = $z->join_url;
                        $params["zoom_id"] = $z->id;
                        $params["zoom_password"] = $password;
                    }
                    $params["zoom_".$count] = $z->join_url;
                    $params["zoom_id_".$count] = $z->id;
                    $params["zoom_password_".$count] = $password;
                    $count++;
                }
            } catch (Exception $ex) {
                $params["zoom"] = 'Zoom link cannot be automatically created: '.$ex->getMessage();
                $params["zoom_id"] = '';
                $params["zoom_password"] = '';
            }             
            
//echo '<pre>'.$token;print_r($params);exit;
            $wpdb->update( $wpdb->prefix.$cp_appb_plugin->table_messages,
                       array( 'posted_data' => serialize($params) ),
                       array ( 'id' => $params[ 'itemnumber' ]),
                       array( '%s' ),
	                   array( '%d' )
                       );
        }
        
        
		public function pp_zoomoauth_checkauth()
		{
            global $wpdb, $cp_appb_plugin;

            if (!isset($_GET["cpapphb_zoomapi_auth"]) || !isset($_GET["formid"]) || !current_user_can('edit_pages'))
                return;

            $form_id = intval($_GET["formid"]);

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);

			if (empty( $rows ) || !$rows[0]->zoom_enable)
			    return;


            $code = $_GET["code"];
            

			$args = array(
				'headers' 	=> array(
					'Authorization' => 'Basic '. base64_encode( $rows[0]->zoom_oauth_key.':'.$rows[0]->zoom_oauth_secret )
				),
				'body' 		=> array(),
				'timeout' 	=> 45,
				'sslverify'	=> false,
			);

            $url = "https://zoom.us/oauth/token?grant_type=authorization_code&code=".$code."&redirect_uri=".urlencode($cp_appb_plugin->get_site_url()."/?cpapphb_zoomapi_auth=1&formid=".$form_id);
			$request = wp_remote_post(            
				$url,
				$args
			);          

            if(!is_wp_error($request))
			{
				$response_body = wp_remote_retrieve_body($request);
				$body = json_decode($response_body);
				if(!empty($body) /** && !empty($body->error_code) */ )
				{
					if(!empty($body->error)) 
                    {
                        echo '<strong>Authorization Error:</strong> '; print_r( $body );exit;
                        error_log( print_r( $body ) );
                    }
                    else
                    {
                        //print_r($body);
                        $accessToken = serialize($body);
                        $wpdb->update($wpdb->prefix.$this->form_table, array ( 'access_token' => $accessToken ) , array( 'formid' => $form_id ) );
                        
                        echo "<script>document.location = '".get_admin_url()."admin.php?page=cp_apphourbooking&cal=".$form_id."&step6=1#configzoom';</script>";
                        exit;
                    }
				}
			}
			else
			{
                echo '<strong>Authorization Error:</strong> '; print_r( $request->get_error_message(), true );exit;
				error_log( print_r( $request->get_error_message(), true ) );
			}
                      

         }        
        
        
        function randomPassword($length = 8) 
        {
            $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
            $pass = array(); //remember to declare $pass as an array
            $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
            for ($i = 0; $i < $length; $i++) {
                $n = rand(0, $alphaLength);
                $pass[] = $alphabet[$n];
            }
            return implode($pass); //turn the array into a string
        }
        
  

    } // End Class

    // Main add-on code
    $cpappb_Zoom_obj = new CPAPPB_Zoom();

	// Add addon object to the objects list
	global $cpappb_addons_objs_list;
	$cpappb_addons_objs_list[ $cpappb_Zoom_obj->get_addon_id() ] = $cpappb_Zoom_obj;
}

if (!class_exists('AHB_Zoom_Api'))
{
    class AHB_Zoom_Api {
    		public $zoom_api_key = '';
    		public $zoom_api_secret = '';
            public $zoom_oauth_token = '';
    		
    		protected function sendRequest($data) {
                $request_url = 'https://api.zoom.us/v2/users/me/meetings';
                $headers = array(
    				"authorization: Bearer ". ($this->zoom_oauth_token?$this->zoom_oauth_token:$this->generateJWTKey()),
                    'content-type: application/json'
                );
                $postFields = json_encode($data);
    		    $ch = curl_init();
    			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    			curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
    			curl_setopt($ch, CURLOPT_URL, $request_url);
    			curl_setopt($ch, CURLOPT_POST, 1);
    			curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
    			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    			$response = curl_exec($ch);
    			$err = curl_error($ch);
    			curl_close($ch);
    			if(!$response){
    				return $err;
    			}
    			return json_decode($response);
    		}
    
    		//function to generate JWT
            private function generateJWTKey() {
                $key = $this->zoom_api_key;
                $secret = $this->zoom_api_secret;
                $token = array(
                    "iss" => $key,
                    "exp" => time() + 3600 //60 seconds as suggested
                );
                require_once __DIR__.'/gapi.addon/autoload.php';          
                return \Firebase\JWT\JWT::encode( $token, $secret );
            }
    		
    		public function createAMeeting( $data = array() ) {
                $post_time  = $data['start_date'];
    			$start_time = gmdate( "Y-m-d\TH:i:s", strtotime( $post_time ) );
                $createAMeetingArray = array();
                if ( ! empty( $data['alternative_host_ids'] ) ) {
                    if ( count( $data['alternative_host_ids'] ) > 1 ) {
                        $alternative_host_ids = implode( ",", $data['alternative_host_ids'] );
                    } else {
                        $alternative_host_ids = $data['alternative_host_ids'][0];
                    }
                }
                $createAMeetingArray['topic']      = @$data['meetingTopic'];
                $createAMeetingArray['agenda']     = ! empty( $data['agenda'] ) ? $data['agenda'] : "";
                $createAMeetingArray['type']       = ! empty( $data['type'] ) ? $data['type'] : 2; //Scheduled
                $createAMeetingArray['start_time'] = $start_time;
                $createAMeetingArray['timezone']   = @$data['timezone'];
                $createAMeetingArray['password']   = ! empty( $data['password'] ) ? $data['password'] : "";
                $createAMeetingArray['duration']   = ! empty( $data['duration'] ) ? $data['duration'] : 60;
                $createAMeetingArray['settings']   = array(
                    'join_before_host'  => ! empty( $data['join_before_host'] ) ? true : false,
                    'host_video'        => ! empty( $data['option_host_video'] ) ? true : false,
                    'participant_video' => ! empty( $data['option_participants_video'] ) ? true : false,
                    'mute_upon_entry'   => ! empty( $data['option_mute_participants'] ) ? true : false,
                    'enforce_login'     => ! empty( $data['option_enforce_login'] ) ? true : false,
                    'auto_recording'    => ! empty( $data['option_auto_recording'] ) ? $data['option_auto_recording'] : "none",
                    'alternative_hosts' => isset( $alternative_host_ids ) ? $alternative_host_ids : ""
                );
                return $this->sendRequest($createAMeetingArray);
            }
    
    
    }
}