<?php

global $wpdb;

$this->item = intval($_GET["cal"]);

$current_user = wp_get_current_user();
$current_user_access = current_user_can('edit_pages');

if ( !is_admin() || (!$current_user_access && !@in_array($current_user->ID, unserialize($this->get_option("cp_user_access","")))))
{
    echo 'Direct access not allowed.';
    exit;
}

// pre-select time-slots
$selection = array();
$rows = $wpdb->get_results( "SELECT time,posted_data FROM ".$wpdb->prefix.$this->table_messages." WHERE notifyto<>'".esc_sql($this->blocked_by_admin_indicator)."' AND  formid=".intval($this->item)." ORDER BY time DESC LIMIT 0,100000" );

$yearly_incoming = array();
$monthly_incoming = array();
$weekly_incoming = array();
$daily_incoming = array();

$yearly = array();
$monthly = array();
$weekly = array();
$daily = array();
$currentdate = strtotime(date("Y-m-d"));
foreach($rows as $item)
{        
    $data = unserialize($item->posted_data);
    foreach($data["apps"] as $app)
        if ( ($status == '-1' || $status == $app["cancelled"]) )
        {       
                $dt = strtotime($app["date"]);
                $dt_incoming = strtotime($item->time);
                if ($dt>=$currentdate)
                {  
                    //$selection[] = array($app["date"]." ".$app["slot"], $app["date"], $app["slot"]);
                    $yearly["x".date("Y",$dt)]++;
                    $monthly["x".date("Ym",$dt)]++;
                    $weekly["x".date("YW",$dt)]++;
                    $daily["x".date("Ymd",$dt)]++;                                   
                }
                $yearly_incoming["x".date("Y",$dt_incoming)]++;
                $monthly_incoming["x".date("Ym",$dt_incoming)]++;
                $weekly_incoming["x".date("YW",$dt_incoming)]++;
                $daily_incoming["x".date("Ymd",$dt_incoming)]++;                  
        }    
}

function getStatsBy($arr)
{
    foreach($arr as $key => $value)
       $str .= '<div><b>'.substr($key,1).'</b> '.$value.' appointments </div>';   
    return $str;  
}
function getStatsByMonthly($arr, $is_incoming = false)
{
    $dt = ($is_incoming ? strtotime("-11 months") : time());
    for ($i=0;$i<12;$i++)
    {
        $key = "x".date("Ym",$dt);
        $str .= '<div><b>'.date("Y M",$dt).'</b> '.(isset($arr[$key])?$arr[$key]:0).' appointments </div>'; 
        $dt = strtotime( "+1 month" ,$dt);    
    }   
    return $str;  
}
function getStatsByWeekly($arr, $is_incoming = false)
{
    $dt = ($is_incoming ? strtotime("-11 weeks") : time());
    for ($i=0;$i<12;$i++)
    {
        $key = "x".date("YW",$dt);
        $str .= '<div><b>'.date("Y W",$dt).'</b> '.(isset($arr[$key])?$arr[$key]:'0').' appointments </div>';         
        $dt = strtotime("+1 week",$dt);    
    }   
    return $str;  
}
function getStatsByDaily($arr, $is_incoming = false)
{
    $dt = ($is_incoming ? strtotime("-29 days") : time());
    for ($i=0;$i<30;$i++)
    {
        $key = "x".date("Ymd",$dt);
        $str .= '<div><b>'.date("Y M d",$dt).'</b> '.(isset($arr[$key])?$arr[$key]:'0').' appointments </div>'; 
        $dt = strtotime("+1 day",$dt);    
    }   
    return $str;  
}

echo '<div class="ahb-section-container"><table id="cTable" width="100%">';
echo '<tr><th colspan="4" style="background-color:#b0b0b0">Submission time stats (date in which the appointment request was received)</th></tr>';
echo '<tr><th>Incoming- Yearly Stats</th><th>Incoming - Monthly Stats (lastest 12 months)</th><th>Incoming - Weekly Stats (lastest 12 weeks)</th><th>Incoming - Daily Stats (lastest 30 days)</th></tr>';
echo '<tr><td>'.getStatsBy($yearly_incoming).'</td><td>'.getStatsByMonthly($monthly_incoming, true).'</td><td>'.getStatsByWeekly($weekly_incoming, true).'</td><td>'.getStatsByDaily($daily_incoming, true).'</td></tr>';
echo '</table></div>';

echo '<div class="ahb-section-container"><table id="cTable" width="100%">';
echo '<tr><th colspan="4" style="background-color:#b0b0b0">Booked times stats (appointment date)</th></tr>';
echo '<tr><th>Yearly Stats</th><th>Monthly Stats (next 12 months)</th><th>Weekly Stats (next 12 weeks)</th><th>Daily Stats(next 30 days)</th></tr>';
echo '<tr><td>'.getStatsBy($yearly).'</td><td>'.getStatsByMonthly($monthly).'</td><td>'.getStatsByWeekly($weekly).'</td><td>'.getStatsByDaily($daily).'</td></tr>';
echo '</table></div>';


?>
<style>
#cTable th{background:#ccc}
#cTable td{vertical-align:top}
</style>